// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/iam/v3beta/policy_bindings_service.proto

package iampb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PolicyBindings_CreatePolicyBinding_FullMethodName        = "/google.iam.v3beta.PolicyBindings/CreatePolicyBinding"
	PolicyBindings_GetPolicyBinding_FullMethodName           = "/google.iam.v3beta.PolicyBindings/GetPolicyBinding"
	PolicyBindings_UpdatePolicyBinding_FullMethodName        = "/google.iam.v3beta.PolicyBindings/UpdatePolicyBinding"
	PolicyBindings_DeletePolicyBinding_FullMethodName        = "/google.iam.v3beta.PolicyBindings/DeletePolicyBinding"
	PolicyBindings_ListPolicyBindings_FullMethodName         = "/google.iam.v3beta.PolicyBindings/ListPolicyBindings"
	PolicyBindings_SearchTargetPolicyBindings_FullMethodName = "/google.iam.v3beta.PolicyBindings/SearchTargetPolicyBindings"
)

// PolicyBindingsClient is the client API for PolicyBindings service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PolicyBindingsClient interface {
	// Creates a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on both the policy and target.
	// Once the binding is created, the policy is applied to the target.
	CreatePolicyBinding(ctx context.Context, in *CreatePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a policy binding.
	GetPolicyBinding(ctx context.Context, in *GetPolicyBindingRequest, opts ...grpc.CallOption) (*PolicyBinding, error)
	// Updates a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on the policy and target in the
	// binding to update, and the IAM permission to remove the existing policy
	// from the binding. Target is immutable and cannot be updated. Once the
	// binding is updated, the new policy is applied to the target.
	UpdatePolicyBinding(ctx context.Context, in *UpdatePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on both the policy and target.
	// Once the binding is deleted, the policy no longer applies to the target.
	DeletePolicyBinding(ctx context.Context, in *DeletePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists policy bindings.
	ListPolicyBindings(ctx context.Context, in *ListPolicyBindingsRequest, opts ...grpc.CallOption) (*ListPolicyBindingsResponse, error)
	// Search policy bindings by target. Returns all policy binding objects bound
	// directly to target.
	SearchTargetPolicyBindings(ctx context.Context, in *SearchTargetPolicyBindingsRequest, opts ...grpc.CallOption) (*SearchTargetPolicyBindingsResponse, error)
}

type policyBindingsClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyBindingsClient(cc grpc.ClientConnInterface) PolicyBindingsClient {
	return &policyBindingsClient{cc}
}

func (c *policyBindingsClient) CreatePolicyBinding(ctx context.Context, in *CreatePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PolicyBindings_CreatePolicyBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) GetPolicyBinding(ctx context.Context, in *GetPolicyBindingRequest, opts ...grpc.CallOption) (*PolicyBinding, error) {
	out := new(PolicyBinding)
	err := c.cc.Invoke(ctx, PolicyBindings_GetPolicyBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) UpdatePolicyBinding(ctx context.Context, in *UpdatePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PolicyBindings_UpdatePolicyBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) DeletePolicyBinding(ctx context.Context, in *DeletePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PolicyBindings_DeletePolicyBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) ListPolicyBindings(ctx context.Context, in *ListPolicyBindingsRequest, opts ...grpc.CallOption) (*ListPolicyBindingsResponse, error) {
	out := new(ListPolicyBindingsResponse)
	err := c.cc.Invoke(ctx, PolicyBindings_ListPolicyBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) SearchTargetPolicyBindings(ctx context.Context, in *SearchTargetPolicyBindingsRequest, opts ...grpc.CallOption) (*SearchTargetPolicyBindingsResponse, error) {
	out := new(SearchTargetPolicyBindingsResponse)
	err := c.cc.Invoke(ctx, PolicyBindings_SearchTargetPolicyBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyBindingsServer is the server API for PolicyBindings service.
// All implementations should embed UnimplementedPolicyBindingsServer
// for forward compatibility
type PolicyBindingsServer interface {
	// Creates a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on both the policy and target.
	// Once the binding is created, the policy is applied to the target.
	CreatePolicyBinding(context.Context, *CreatePolicyBindingRequest) (*longrunningpb.Operation, error)
	// Gets a policy binding.
	GetPolicyBinding(context.Context, *GetPolicyBindingRequest) (*PolicyBinding, error)
	// Updates a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on the policy and target in the
	// binding to update, and the IAM permission to remove the existing policy
	// from the binding. Target is immutable and cannot be updated. Once the
	// binding is updated, the new policy is applied to the target.
	UpdatePolicyBinding(context.Context, *UpdatePolicyBindingRequest) (*longrunningpb.Operation, error)
	// Deletes a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on both the policy and target.
	// Once the binding is deleted, the policy no longer applies to the target.
	DeletePolicyBinding(context.Context, *DeletePolicyBindingRequest) (*longrunningpb.Operation, error)
	// Lists policy bindings.
	ListPolicyBindings(context.Context, *ListPolicyBindingsRequest) (*ListPolicyBindingsResponse, error)
	// Search policy bindings by target. Returns all policy binding objects bound
	// directly to target.
	SearchTargetPolicyBindings(context.Context, *SearchTargetPolicyBindingsRequest) (*SearchTargetPolicyBindingsResponse, error)
}

// UnimplementedPolicyBindingsServer should be embedded to have forward compatible implementations.
type UnimplementedPolicyBindingsServer struct {
}

func (UnimplementedPolicyBindingsServer) CreatePolicyBinding(context.Context, *CreatePolicyBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicyBinding not implemented")
}
func (UnimplementedPolicyBindingsServer) GetPolicyBinding(context.Context, *GetPolicyBindingRequest) (*PolicyBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicyBinding not implemented")
}
func (UnimplementedPolicyBindingsServer) UpdatePolicyBinding(context.Context, *UpdatePolicyBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicyBinding not implemented")
}
func (UnimplementedPolicyBindingsServer) DeletePolicyBinding(context.Context, *DeletePolicyBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicyBinding not implemented")
}
func (UnimplementedPolicyBindingsServer) ListPolicyBindings(context.Context, *ListPolicyBindingsRequest) (*ListPolicyBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicyBindings not implemented")
}
func (UnimplementedPolicyBindingsServer) SearchTargetPolicyBindings(context.Context, *SearchTargetPolicyBindingsRequest) (*SearchTargetPolicyBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchTargetPolicyBindings not implemented")
}

// UnsafePolicyBindingsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PolicyBindingsServer will
// result in compilation errors.
type UnsafePolicyBindingsServer interface {
	mustEmbedUnimplementedPolicyBindingsServer()
}

func RegisterPolicyBindingsServer(s grpc.ServiceRegistrar, srv PolicyBindingsServer) {
	s.RegisterService(&PolicyBindings_ServiceDesc, srv)
}

func _PolicyBindings_CreatePolicyBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).CreatePolicyBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBindings_CreatePolicyBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).CreatePolicyBinding(ctx, req.(*CreatePolicyBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_GetPolicyBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).GetPolicyBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBindings_GetPolicyBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).GetPolicyBinding(ctx, req.(*GetPolicyBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_UpdatePolicyBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).UpdatePolicyBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBindings_UpdatePolicyBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).UpdatePolicyBinding(ctx, req.(*UpdatePolicyBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_DeletePolicyBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).DeletePolicyBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBindings_DeletePolicyBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).DeletePolicyBinding(ctx, req.(*DeletePolicyBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_ListPolicyBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPolicyBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).ListPolicyBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBindings_ListPolicyBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).ListPolicyBindings(ctx, req.(*ListPolicyBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_SearchTargetPolicyBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchTargetPolicyBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).SearchTargetPolicyBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBindings_SearchTargetPolicyBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).SearchTargetPolicyBindings(ctx, req.(*SearchTargetPolicyBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PolicyBindings_ServiceDesc is the grpc.ServiceDesc for PolicyBindings service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PolicyBindings_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.v3beta.PolicyBindings",
	HandlerType: (*PolicyBindingsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePolicyBinding",
			Handler:    _PolicyBindings_CreatePolicyBinding_Handler,
		},
		{
			MethodName: "GetPolicyBinding",
			Handler:    _PolicyBindings_GetPolicyBinding_Handler,
		},
		{
			MethodName: "UpdatePolicyBinding",
			Handler:    _PolicyBindings_UpdatePolicyBinding_Handler,
		},
		{
			MethodName: "DeletePolicyBinding",
			Handler:    _PolicyBindings_DeletePolicyBinding_Handler,
		},
		{
			MethodName: "ListPolicyBindings",
			Handler:    _PolicyBindings_ListPolicyBindings_Handler,
		},
		{
			MethodName: "SearchTargetPolicyBindings",
			Handler:    _PolicyBindings_SearchTargetPolicyBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/v3beta/policy_bindings_service.proto",
}
