// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/iap/v1/service.proto

package iappb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	IdentityAwareProxyAdminService_SetIamPolicy_FullMethodName                   = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/SetIamPolicy"
	IdentityAwareProxyAdminService_GetIamPolicy_FullMethodName                   = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetIamPolicy"
	IdentityAwareProxyAdminService_TestIamPermissions_FullMethodName             = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/TestIamPermissions"
	IdentityAwareProxyAdminService_GetIapSettings_FullMethodName                 = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetIapSettings"
	IdentityAwareProxyAdminService_UpdateIapSettings_FullMethodName              = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/UpdateIapSettings"
	IdentityAwareProxyAdminService_ValidateIapAttributeExpression_FullMethodName = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/ValidateIapAttributeExpression"
	IdentityAwareProxyAdminService_ListTunnelDestGroups_FullMethodName           = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/ListTunnelDestGroups"
	IdentityAwareProxyAdminService_CreateTunnelDestGroup_FullMethodName          = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/CreateTunnelDestGroup"
	IdentityAwareProxyAdminService_GetTunnelDestGroup_FullMethodName             = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetTunnelDestGroup"
	IdentityAwareProxyAdminService_DeleteTunnelDestGroup_FullMethodName          = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/DeleteTunnelDestGroup"
	IdentityAwareProxyAdminService_UpdateTunnelDestGroup_FullMethodName          = "/google.cloud.iap.v1.IdentityAwareProxyAdminService/UpdateTunnelDestGroup"
)

// IdentityAwareProxyAdminServiceClient is the client API for IdentityAwareProxyAdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type IdentityAwareProxyAdminServiceClient interface {
	// Sets the access control policy for an Identity-Aware Proxy protected
	// resource. Replaces any existing policy.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the access control policy for an Identity-Aware Proxy protected
	// resource.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on the Identity-Aware Proxy protected
	// resource.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Gets the IAP settings on a particular IAP protected resource.
	GetIapSettings(ctx context.Context, in *GetIapSettingsRequest, opts ...grpc.CallOption) (*IapSettings, error)
	// Updates the IAP settings on a particular IAP protected resource. It
	// replaces all fields unless the `update_mask` is set.
	UpdateIapSettings(ctx context.Context, in *UpdateIapSettingsRequest, opts ...grpc.CallOption) (*IapSettings, error)
	// Validates that a given CEL expression conforms to IAP restrictions.
	ValidateIapAttributeExpression(ctx context.Context, in *ValidateIapAttributeExpressionRequest, opts ...grpc.CallOption) (*ValidateIapAttributeExpressionResponse, error)
	// Lists the existing TunnelDestGroups. To group across all locations, use a
	// `-` as the location ID. For example:
	// `/v1/projects/123/iap_tunnel/locations/-/destGroups`
	ListTunnelDestGroups(ctx context.Context, in *ListTunnelDestGroupsRequest, opts ...grpc.CallOption) (*ListTunnelDestGroupsResponse, error)
	// Creates a new TunnelDestGroup.
	CreateTunnelDestGroup(ctx context.Context, in *CreateTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error)
	// Retrieves an existing TunnelDestGroup.
	GetTunnelDestGroup(ctx context.Context, in *GetTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error)
	// Deletes a TunnelDestGroup.
	DeleteTunnelDestGroup(ctx context.Context, in *DeleteTunnelDestGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a TunnelDestGroup.
	UpdateTunnelDestGroup(ctx context.Context, in *UpdateTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error)
}

type identityAwareProxyAdminServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewIdentityAwareProxyAdminServiceClient(cc grpc.ClientConnInterface) IdentityAwareProxyAdminServiceClient {
	return &identityAwareProxyAdminServiceClient{cc}
}

func (c *identityAwareProxyAdminServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) GetIapSettings(ctx context.Context, in *GetIapSettingsRequest, opts ...grpc.CallOption) (*IapSettings, error) {
	out := new(IapSettings)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_GetIapSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) UpdateIapSettings(ctx context.Context, in *UpdateIapSettingsRequest, opts ...grpc.CallOption) (*IapSettings, error) {
	out := new(IapSettings)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_UpdateIapSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) ValidateIapAttributeExpression(ctx context.Context, in *ValidateIapAttributeExpressionRequest, opts ...grpc.CallOption) (*ValidateIapAttributeExpressionResponse, error) {
	out := new(ValidateIapAttributeExpressionResponse)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_ValidateIapAttributeExpression_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) ListTunnelDestGroups(ctx context.Context, in *ListTunnelDestGroupsRequest, opts ...grpc.CallOption) (*ListTunnelDestGroupsResponse, error) {
	out := new(ListTunnelDestGroupsResponse)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_ListTunnelDestGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) CreateTunnelDestGroup(ctx context.Context, in *CreateTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error) {
	out := new(TunnelDestGroup)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_CreateTunnelDestGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) GetTunnelDestGroup(ctx context.Context, in *GetTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error) {
	out := new(TunnelDestGroup)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_GetTunnelDestGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) DeleteTunnelDestGroup(ctx context.Context, in *DeleteTunnelDestGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_DeleteTunnelDestGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) UpdateTunnelDestGroup(ctx context.Context, in *UpdateTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error) {
	out := new(TunnelDestGroup)
	err := c.cc.Invoke(ctx, IdentityAwareProxyAdminService_UpdateTunnelDestGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IdentityAwareProxyAdminServiceServer is the server API for IdentityAwareProxyAdminService service.
// All implementations should embed UnimplementedIdentityAwareProxyAdminServiceServer
// for forward compatibility
type IdentityAwareProxyAdminServiceServer interface {
	// Sets the access control policy for an Identity-Aware Proxy protected
	// resource. Replaces any existing policy.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the access control policy for an Identity-Aware Proxy protected
	// resource.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on the Identity-Aware Proxy protected
	// resource.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Gets the IAP settings on a particular IAP protected resource.
	GetIapSettings(context.Context, *GetIapSettingsRequest) (*IapSettings, error)
	// Updates the IAP settings on a particular IAP protected resource. It
	// replaces all fields unless the `update_mask` is set.
	UpdateIapSettings(context.Context, *UpdateIapSettingsRequest) (*IapSettings, error)
	// Validates that a given CEL expression conforms to IAP restrictions.
	ValidateIapAttributeExpression(context.Context, *ValidateIapAttributeExpressionRequest) (*ValidateIapAttributeExpressionResponse, error)
	// Lists the existing TunnelDestGroups. To group across all locations, use a
	// `-` as the location ID. For example:
	// `/v1/projects/123/iap_tunnel/locations/-/destGroups`
	ListTunnelDestGroups(context.Context, *ListTunnelDestGroupsRequest) (*ListTunnelDestGroupsResponse, error)
	// Creates a new TunnelDestGroup.
	CreateTunnelDestGroup(context.Context, *CreateTunnelDestGroupRequest) (*TunnelDestGroup, error)
	// Retrieves an existing TunnelDestGroup.
	GetTunnelDestGroup(context.Context, *GetTunnelDestGroupRequest) (*TunnelDestGroup, error)
	// Deletes a TunnelDestGroup.
	DeleteTunnelDestGroup(context.Context, *DeleteTunnelDestGroupRequest) (*emptypb.Empty, error)
	// Updates a TunnelDestGroup.
	UpdateTunnelDestGroup(context.Context, *UpdateTunnelDestGroupRequest) (*TunnelDestGroup, error)
}

// UnimplementedIdentityAwareProxyAdminServiceServer should be embedded to have forward compatible implementations.
type UnimplementedIdentityAwareProxyAdminServiceServer struct {
}

func (UnimplementedIdentityAwareProxyAdminServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) GetIapSettings(context.Context, *GetIapSettingsRequest) (*IapSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIapSettings not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) UpdateIapSettings(context.Context, *UpdateIapSettingsRequest) (*IapSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIapSettings not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) ValidateIapAttributeExpression(context.Context, *ValidateIapAttributeExpressionRequest) (*ValidateIapAttributeExpressionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateIapAttributeExpression not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) ListTunnelDestGroups(context.Context, *ListTunnelDestGroupsRequest) (*ListTunnelDestGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTunnelDestGroups not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) CreateTunnelDestGroup(context.Context, *CreateTunnelDestGroupRequest) (*TunnelDestGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTunnelDestGroup not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) GetTunnelDestGroup(context.Context, *GetTunnelDestGroupRequest) (*TunnelDestGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTunnelDestGroup not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) DeleteTunnelDestGroup(context.Context, *DeleteTunnelDestGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTunnelDestGroup not implemented")
}
func (UnimplementedIdentityAwareProxyAdminServiceServer) UpdateTunnelDestGroup(context.Context, *UpdateTunnelDestGroupRequest) (*TunnelDestGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTunnelDestGroup not implemented")
}

// UnsafeIdentityAwareProxyAdminServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to IdentityAwareProxyAdminServiceServer will
// result in compilation errors.
type UnsafeIdentityAwareProxyAdminServiceServer interface {
	mustEmbedUnimplementedIdentityAwareProxyAdminServiceServer()
}

func RegisterIdentityAwareProxyAdminServiceServer(s grpc.ServiceRegistrar, srv IdentityAwareProxyAdminServiceServer) {
	s.RegisterService(&IdentityAwareProxyAdminService_ServiceDesc, srv)
}

func _IdentityAwareProxyAdminService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_GetIapSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIapSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).GetIapSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_GetIapSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).GetIapSettings(ctx, req.(*GetIapSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_UpdateIapSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIapSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).UpdateIapSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_UpdateIapSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).UpdateIapSettings(ctx, req.(*UpdateIapSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_ValidateIapAttributeExpression_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateIapAttributeExpressionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).ValidateIapAttributeExpression(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_ValidateIapAttributeExpression_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).ValidateIapAttributeExpression(ctx, req.(*ValidateIapAttributeExpressionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_ListTunnelDestGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTunnelDestGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).ListTunnelDestGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_ListTunnelDestGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).ListTunnelDestGroups(ctx, req.(*ListTunnelDestGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_CreateTunnelDestGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTunnelDestGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).CreateTunnelDestGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_CreateTunnelDestGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).CreateTunnelDestGroup(ctx, req.(*CreateTunnelDestGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_GetTunnelDestGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTunnelDestGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).GetTunnelDestGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_GetTunnelDestGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).GetTunnelDestGroup(ctx, req.(*GetTunnelDestGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_DeleteTunnelDestGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTunnelDestGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).DeleteTunnelDestGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_DeleteTunnelDestGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).DeleteTunnelDestGroup(ctx, req.(*DeleteTunnelDestGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_UpdateTunnelDestGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTunnelDestGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).UpdateTunnelDestGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyAdminService_UpdateTunnelDestGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).UpdateTunnelDestGroup(ctx, req.(*UpdateTunnelDestGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// IdentityAwareProxyAdminService_ServiceDesc is the grpc.ServiceDesc for IdentityAwareProxyAdminService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var IdentityAwareProxyAdminService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.iap.v1.IdentityAwareProxyAdminService",
	HandlerType: (*IdentityAwareProxyAdminServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetIamPolicy",
			Handler:    _IdentityAwareProxyAdminService_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _IdentityAwareProxyAdminService_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _IdentityAwareProxyAdminService_TestIamPermissions_Handler,
		},
		{
			MethodName: "GetIapSettings",
			Handler:    _IdentityAwareProxyAdminService_GetIapSettings_Handler,
		},
		{
			MethodName: "UpdateIapSettings",
			Handler:    _IdentityAwareProxyAdminService_UpdateIapSettings_Handler,
		},
		{
			MethodName: "ValidateIapAttributeExpression",
			Handler:    _IdentityAwareProxyAdminService_ValidateIapAttributeExpression_Handler,
		},
		{
			MethodName: "ListTunnelDestGroups",
			Handler:    _IdentityAwareProxyAdminService_ListTunnelDestGroups_Handler,
		},
		{
			MethodName: "CreateTunnelDestGroup",
			Handler:    _IdentityAwareProxyAdminService_CreateTunnelDestGroup_Handler,
		},
		{
			MethodName: "GetTunnelDestGroup",
			Handler:    _IdentityAwareProxyAdminService_GetTunnelDestGroup_Handler,
		},
		{
			MethodName: "DeleteTunnelDestGroup",
			Handler:    _IdentityAwareProxyAdminService_DeleteTunnelDestGroup_Handler,
		},
		{
			MethodName: "UpdateTunnelDestGroup",
			Handler:    _IdentityAwareProxyAdminService_UpdateTunnelDestGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/iap/v1/service.proto",
}

const (
	IdentityAwareProxyOAuthService_ListBrands_FullMethodName                          = "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListBrands"
	IdentityAwareProxyOAuthService_CreateBrand_FullMethodName                         = "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateBrand"
	IdentityAwareProxyOAuthService_GetBrand_FullMethodName                            = "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetBrand"
	IdentityAwareProxyOAuthService_CreateIdentityAwareProxyClient_FullMethodName      = "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateIdentityAwareProxyClient"
	IdentityAwareProxyOAuthService_ListIdentityAwareProxyClients_FullMethodName       = "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListIdentityAwareProxyClients"
	IdentityAwareProxyOAuthService_GetIdentityAwareProxyClient_FullMethodName         = "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetIdentityAwareProxyClient"
	IdentityAwareProxyOAuthService_ResetIdentityAwareProxyClientSecret_FullMethodName = "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ResetIdentityAwareProxyClientSecret"
	IdentityAwareProxyOAuthService_DeleteIdentityAwareProxyClient_FullMethodName      = "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/DeleteIdentityAwareProxyClient"
)

// IdentityAwareProxyOAuthServiceClient is the client API for IdentityAwareProxyOAuthService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type IdentityAwareProxyOAuthServiceClient interface {
	// Lists the existing brands for the project.
	ListBrands(ctx context.Context, in *ListBrandsRequest, opts ...grpc.CallOption) (*ListBrandsResponse, error)
	// Constructs a new OAuth brand for the project if one does not exist.
	// The created brand is "internal only", meaning that OAuth clients created
	// under it only accept requests from users who belong to the same Google
	// Workspace organization as the project. The brand is created in an
	// un-reviewed status. NOTE: The "internal only" status can be manually
	// changed in the Google Cloud Console. Requires that a brand does not already
	// exist for the project, and that the specified support email is owned by the
	// caller.
	CreateBrand(ctx context.Context, in *CreateBrandRequest, opts ...grpc.CallOption) (*Brand, error)
	// Retrieves the OAuth brand of the project.
	GetBrand(ctx context.Context, in *GetBrandRequest, opts ...grpc.CallOption) (*Brand, error)
	// Creates an Identity Aware Proxy (IAP) OAuth client. The client is owned
	// by IAP. Requires that the brand for the project exists and that it is
	// set for internal-only use.
	CreateIdentityAwareProxyClient(ctx context.Context, in *CreateIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error)
	// Lists the existing clients for the brand.
	ListIdentityAwareProxyClients(ctx context.Context, in *ListIdentityAwareProxyClientsRequest, opts ...grpc.CallOption) (*ListIdentityAwareProxyClientsResponse, error)
	// Retrieves an Identity Aware Proxy (IAP) OAuth client.
	// Requires that the client is owned by IAP.
	GetIdentityAwareProxyClient(ctx context.Context, in *GetIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error)
	// Resets an Identity Aware Proxy (IAP) OAuth client secret. Useful if the
	// secret was compromised. Requires that the client is owned by IAP.
	ResetIdentityAwareProxyClientSecret(ctx context.Context, in *ResetIdentityAwareProxyClientSecretRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error)
	// Deletes an Identity Aware Proxy (IAP) OAuth client. Useful for removing
	// obsolete clients, managing the number of clients in a given project, and
	// cleaning up after tests. Requires that the client is owned by IAP.
	DeleteIdentityAwareProxyClient(ctx context.Context, in *DeleteIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type identityAwareProxyOAuthServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewIdentityAwareProxyOAuthServiceClient(cc grpc.ClientConnInterface) IdentityAwareProxyOAuthServiceClient {
	return &identityAwareProxyOAuthServiceClient{cc}
}

func (c *identityAwareProxyOAuthServiceClient) ListBrands(ctx context.Context, in *ListBrandsRequest, opts ...grpc.CallOption) (*ListBrandsResponse, error) {
	out := new(ListBrandsResponse)
	err := c.cc.Invoke(ctx, IdentityAwareProxyOAuthService_ListBrands_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) CreateBrand(ctx context.Context, in *CreateBrandRequest, opts ...grpc.CallOption) (*Brand, error) {
	out := new(Brand)
	err := c.cc.Invoke(ctx, IdentityAwareProxyOAuthService_CreateBrand_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) GetBrand(ctx context.Context, in *GetBrandRequest, opts ...grpc.CallOption) (*Brand, error) {
	out := new(Brand)
	err := c.cc.Invoke(ctx, IdentityAwareProxyOAuthService_GetBrand_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) CreateIdentityAwareProxyClient(ctx context.Context, in *CreateIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error) {
	out := new(IdentityAwareProxyClient)
	err := c.cc.Invoke(ctx, IdentityAwareProxyOAuthService_CreateIdentityAwareProxyClient_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) ListIdentityAwareProxyClients(ctx context.Context, in *ListIdentityAwareProxyClientsRequest, opts ...grpc.CallOption) (*ListIdentityAwareProxyClientsResponse, error) {
	out := new(ListIdentityAwareProxyClientsResponse)
	err := c.cc.Invoke(ctx, IdentityAwareProxyOAuthService_ListIdentityAwareProxyClients_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) GetIdentityAwareProxyClient(ctx context.Context, in *GetIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error) {
	out := new(IdentityAwareProxyClient)
	err := c.cc.Invoke(ctx, IdentityAwareProxyOAuthService_GetIdentityAwareProxyClient_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) ResetIdentityAwareProxyClientSecret(ctx context.Context, in *ResetIdentityAwareProxyClientSecretRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error) {
	out := new(IdentityAwareProxyClient)
	err := c.cc.Invoke(ctx, IdentityAwareProxyOAuthService_ResetIdentityAwareProxyClientSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) DeleteIdentityAwareProxyClient(ctx context.Context, in *DeleteIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, IdentityAwareProxyOAuthService_DeleteIdentityAwareProxyClient_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IdentityAwareProxyOAuthServiceServer is the server API for IdentityAwareProxyOAuthService service.
// All implementations should embed UnimplementedIdentityAwareProxyOAuthServiceServer
// for forward compatibility
type IdentityAwareProxyOAuthServiceServer interface {
	// Lists the existing brands for the project.
	ListBrands(context.Context, *ListBrandsRequest) (*ListBrandsResponse, error)
	// Constructs a new OAuth brand for the project if one does not exist.
	// The created brand is "internal only", meaning that OAuth clients created
	// under it only accept requests from users who belong to the same Google
	// Workspace organization as the project. The brand is created in an
	// un-reviewed status. NOTE: The "internal only" status can be manually
	// changed in the Google Cloud Console. Requires that a brand does not already
	// exist for the project, and that the specified support email is owned by the
	// caller.
	CreateBrand(context.Context, *CreateBrandRequest) (*Brand, error)
	// Retrieves the OAuth brand of the project.
	GetBrand(context.Context, *GetBrandRequest) (*Brand, error)
	// Creates an Identity Aware Proxy (IAP) OAuth client. The client is owned
	// by IAP. Requires that the brand for the project exists and that it is
	// set for internal-only use.
	CreateIdentityAwareProxyClient(context.Context, *CreateIdentityAwareProxyClientRequest) (*IdentityAwareProxyClient, error)
	// Lists the existing clients for the brand.
	ListIdentityAwareProxyClients(context.Context, *ListIdentityAwareProxyClientsRequest) (*ListIdentityAwareProxyClientsResponse, error)
	// Retrieves an Identity Aware Proxy (IAP) OAuth client.
	// Requires that the client is owned by IAP.
	GetIdentityAwareProxyClient(context.Context, *GetIdentityAwareProxyClientRequest) (*IdentityAwareProxyClient, error)
	// Resets an Identity Aware Proxy (IAP) OAuth client secret. Useful if the
	// secret was compromised. Requires that the client is owned by IAP.
	ResetIdentityAwareProxyClientSecret(context.Context, *ResetIdentityAwareProxyClientSecretRequest) (*IdentityAwareProxyClient, error)
	// Deletes an Identity Aware Proxy (IAP) OAuth client. Useful for removing
	// obsolete clients, managing the number of clients in a given project, and
	// cleaning up after tests. Requires that the client is owned by IAP.
	DeleteIdentityAwareProxyClient(context.Context, *DeleteIdentityAwareProxyClientRequest) (*emptypb.Empty, error)
}

// UnimplementedIdentityAwareProxyOAuthServiceServer should be embedded to have forward compatible implementations.
type UnimplementedIdentityAwareProxyOAuthServiceServer struct {
}

func (UnimplementedIdentityAwareProxyOAuthServiceServer) ListBrands(context.Context, *ListBrandsRequest) (*ListBrandsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBrands not implemented")
}
func (UnimplementedIdentityAwareProxyOAuthServiceServer) CreateBrand(context.Context, *CreateBrandRequest) (*Brand, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBrand not implemented")
}
func (UnimplementedIdentityAwareProxyOAuthServiceServer) GetBrand(context.Context, *GetBrandRequest) (*Brand, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBrand not implemented")
}
func (UnimplementedIdentityAwareProxyOAuthServiceServer) CreateIdentityAwareProxyClient(context.Context, *CreateIdentityAwareProxyClientRequest) (*IdentityAwareProxyClient, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIdentityAwareProxyClient not implemented")
}
func (UnimplementedIdentityAwareProxyOAuthServiceServer) ListIdentityAwareProxyClients(context.Context, *ListIdentityAwareProxyClientsRequest) (*ListIdentityAwareProxyClientsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIdentityAwareProxyClients not implemented")
}
func (UnimplementedIdentityAwareProxyOAuthServiceServer) GetIdentityAwareProxyClient(context.Context, *GetIdentityAwareProxyClientRequest) (*IdentityAwareProxyClient, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIdentityAwareProxyClient not implemented")
}
func (UnimplementedIdentityAwareProxyOAuthServiceServer) ResetIdentityAwareProxyClientSecret(context.Context, *ResetIdentityAwareProxyClientSecretRequest) (*IdentityAwareProxyClient, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetIdentityAwareProxyClientSecret not implemented")
}
func (UnimplementedIdentityAwareProxyOAuthServiceServer) DeleteIdentityAwareProxyClient(context.Context, *DeleteIdentityAwareProxyClientRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIdentityAwareProxyClient not implemented")
}

// UnsafeIdentityAwareProxyOAuthServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to IdentityAwareProxyOAuthServiceServer will
// result in compilation errors.
type UnsafeIdentityAwareProxyOAuthServiceServer interface {
	mustEmbedUnimplementedIdentityAwareProxyOAuthServiceServer()
}

func RegisterIdentityAwareProxyOAuthServiceServer(s grpc.ServiceRegistrar, srv IdentityAwareProxyOAuthServiceServer) {
	s.RegisterService(&IdentityAwareProxyOAuthService_ServiceDesc, srv)
}

func _IdentityAwareProxyOAuthService_ListBrands_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBrandsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).ListBrands(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyOAuthService_ListBrands_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).ListBrands(ctx, req.(*ListBrandsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_CreateBrand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBrandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).CreateBrand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyOAuthService_CreateBrand_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).CreateBrand(ctx, req.(*CreateBrandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_GetBrand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBrandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).GetBrand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyOAuthService_GetBrand_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).GetBrand(ctx, req.(*GetBrandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_CreateIdentityAwareProxyClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIdentityAwareProxyClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).CreateIdentityAwareProxyClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyOAuthService_CreateIdentityAwareProxyClient_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).CreateIdentityAwareProxyClient(ctx, req.(*CreateIdentityAwareProxyClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_ListIdentityAwareProxyClients_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIdentityAwareProxyClientsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).ListIdentityAwareProxyClients(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyOAuthService_ListIdentityAwareProxyClients_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).ListIdentityAwareProxyClients(ctx, req.(*ListIdentityAwareProxyClientsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_GetIdentityAwareProxyClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIdentityAwareProxyClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).GetIdentityAwareProxyClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyOAuthService_GetIdentityAwareProxyClient_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).GetIdentityAwareProxyClient(ctx, req.(*GetIdentityAwareProxyClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_ResetIdentityAwareProxyClientSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetIdentityAwareProxyClientSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).ResetIdentityAwareProxyClientSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyOAuthService_ResetIdentityAwareProxyClientSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).ResetIdentityAwareProxyClientSecret(ctx, req.(*ResetIdentityAwareProxyClientSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_DeleteIdentityAwareProxyClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIdentityAwareProxyClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).DeleteIdentityAwareProxyClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IdentityAwareProxyOAuthService_DeleteIdentityAwareProxyClient_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).DeleteIdentityAwareProxyClient(ctx, req.(*DeleteIdentityAwareProxyClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// IdentityAwareProxyOAuthService_ServiceDesc is the grpc.ServiceDesc for IdentityAwareProxyOAuthService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var IdentityAwareProxyOAuthService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.iap.v1.IdentityAwareProxyOAuthService",
	HandlerType: (*IdentityAwareProxyOAuthServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListBrands",
			Handler:    _IdentityAwareProxyOAuthService_ListBrands_Handler,
		},
		{
			MethodName: "CreateBrand",
			Handler:    _IdentityAwareProxyOAuthService_CreateBrand_Handler,
		},
		{
			MethodName: "GetBrand",
			Handler:    _IdentityAwareProxyOAuthService_GetBrand_Handler,
		},
		{
			MethodName: "CreateIdentityAwareProxyClient",
			Handler:    _IdentityAwareProxyOAuthService_CreateIdentityAwareProxyClient_Handler,
		},
		{
			MethodName: "ListIdentityAwareProxyClients",
			Handler:    _IdentityAwareProxyOAuthService_ListIdentityAwareProxyClients_Handler,
		},
		{
			MethodName: "GetIdentityAwareProxyClient",
			Handler:    _IdentityAwareProxyOAuthService_GetIdentityAwareProxyClient_Handler,
		},
		{
			MethodName: "ResetIdentityAwareProxyClientSecret",
			Handler:    _IdentityAwareProxyOAuthService_ResetIdentityAwareProxyClientSecret_Handler,
		},
		{
			MethodName: "DeleteIdentityAwareProxyClient",
			Handler:    _IdentityAwareProxyOAuthService_DeleteIdentityAwareProxyClient_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/iap/v1/service.proto",
}
