// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/networkconnectivity/v1/hub.proto

package networkconnectivitypb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported features for a location
type LocationFeature int32

const (
	// No publicly supported feature in this location
	LocationFeature_LOCATION_FEATURE_UNSPECIFIED LocationFeature = 0
	// Site-to-cloud spokes are supported in this location
	LocationFeature_SITE_TO_CLOUD_SPOKES LocationFeature = 1
	// Site-to-site spokes are supported in this location
	LocationFeature_SITE_TO_SITE_SPOKES LocationFeature = 2
)

// Enum value maps for LocationFeature.
var (
	LocationFeature_name = map[int32]string{
		0: "LOCATION_FEATURE_UNSPECIFIED",
		1: "SITE_TO_CLOUD_SPOKES",
		2: "SITE_TO_SITE_SPOKES",
	}
	LocationFeature_value = map[string]int32{
		"LOCATION_FEATURE_UNSPECIFIED": 0,
		"SITE_TO_CLOUD_SPOKES":         1,
		"SITE_TO_SITE_SPOKES":          2,
	}
)

func (x LocationFeature) Enum() *LocationFeature {
	p := new(LocationFeature)
	*p = x
	return p
}

func (x LocationFeature) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationFeature) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[0].Descriptor()
}

func (LocationFeature) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[0]
}

func (x LocationFeature) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationFeature.Descriptor instead.
func (LocationFeature) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{0}
}

// The route's type
type RouteType int32

const (
	// No route type information specified
	RouteType_ROUTE_TYPE_UNSPECIFIED RouteType = 0
	// The route leads to a destination within the primary address range of the
	// VPC network's subnet.
	RouteType_VPC_PRIMARY_SUBNET RouteType = 1
	// The route leads to a destination within the secondary address range of the
	// VPC network's subnet.
	RouteType_VPC_SECONDARY_SUBNET RouteType = 2
	// The route leads to a destination in a dynamic route. Dynamic routes are
	// derived from Border Gateway Protocol (BGP) advertisements received from an
	// NCC hybrid spoke.
	RouteType_DYNAMIC_ROUTE RouteType = 3
)

// Enum value maps for RouteType.
var (
	RouteType_name = map[int32]string{
		0: "ROUTE_TYPE_UNSPECIFIED",
		1: "VPC_PRIMARY_SUBNET",
		2: "VPC_SECONDARY_SUBNET",
		3: "DYNAMIC_ROUTE",
	}
	RouteType_value = map[string]int32{
		"ROUTE_TYPE_UNSPECIFIED": 0,
		"VPC_PRIMARY_SUBNET":     1,
		"VPC_SECONDARY_SUBNET":   2,
		"DYNAMIC_ROUTE":          3,
	}
)

func (x RouteType) Enum() *RouteType {
	p := new(RouteType)
	*p = x
	return p
}

func (x RouteType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[1].Descriptor()
}

func (RouteType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[1]
}

func (x RouteType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteType.Descriptor instead.
func (RouteType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{1}
}

// The State enum represents the lifecycle stage of a Network Connectivity
// Center resource.
type State int32

const (
	// No state information available
	State_STATE_UNSPECIFIED State = 0
	// The resource's create operation is in progress.
	State_CREATING State = 1
	// The resource is active
	State_ACTIVE State = 2
	// The resource's delete operation is in progress.
	State_DELETING State = 3
	// The resource's accept operation is in progress.
	State_ACCEPTING State = 8
	// The resource's reject operation is in progress.
	State_REJECTING State = 9
	// The resource's update operation is in progress.
	State_UPDATING State = 6
	// The resource is inactive.
	State_INACTIVE State = 7
	// The hub associated with this spoke resource has been deleted.
	// This state applies to spoke resources only.
	State_OBSOLETE State = 10
	// The resource is in an undefined state due to resource creation or deletion
	// failure. You can try to delete the resource later or contact support for
	// help.
	State_FAILED State = 11
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "CREATING",
		2:  "ACTIVE",
		3:  "DELETING",
		8:  "ACCEPTING",
		9:  "REJECTING",
		6:  "UPDATING",
		7:  "INACTIVE",
		10: "OBSOLETE",
		11: "FAILED",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"ACCEPTING":         8,
		"REJECTING":         9,
		"UPDATING":          6,
		"INACTIVE":          7,
		"OBSOLETE":          10,
		"FAILED":            11,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[2].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[2]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{2}
}

// The SpokeType enum represents the type of spoke. The type
// reflects the kind of resource that a spoke is associated with.
type SpokeType int32

const (
	// Unspecified spoke type.
	SpokeType_SPOKE_TYPE_UNSPECIFIED SpokeType = 0
	// Spokes associated with VPN tunnels.
	SpokeType_VPN_TUNNEL SpokeType = 1
	// Spokes associated with VLAN attachments.
	SpokeType_INTERCONNECT_ATTACHMENT SpokeType = 2
	// Spokes associated with router appliance instances.
	SpokeType_ROUTER_APPLIANCE SpokeType = 3
	// Spokes associated with VPC networks.
	SpokeType_VPC_NETWORK SpokeType = 4
	// Spokes that are backed by a producer VPC network.
	SpokeType_PRODUCER_VPC_NETWORK SpokeType = 7
)

// Enum value maps for SpokeType.
var (
	SpokeType_name = map[int32]string{
		0: "SPOKE_TYPE_UNSPECIFIED",
		1: "VPN_TUNNEL",
		2: "INTERCONNECT_ATTACHMENT",
		3: "ROUTER_APPLIANCE",
		4: "VPC_NETWORK",
		7: "PRODUCER_VPC_NETWORK",
	}
	SpokeType_value = map[string]int32{
		"SPOKE_TYPE_UNSPECIFIED":  0,
		"VPN_TUNNEL":              1,
		"INTERCONNECT_ATTACHMENT": 2,
		"ROUTER_APPLIANCE":        3,
		"VPC_NETWORK":             4,
		"PRODUCER_VPC_NETWORK":    7,
	}
)

func (x SpokeType) Enum() *SpokeType {
	p := new(SpokeType)
	*p = x
	return p
}

func (x SpokeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SpokeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[3].Descriptor()
}

func (SpokeType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[3]
}

func (x SpokeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SpokeType.Descriptor instead.
func (SpokeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{3}
}

// This enum controls the policy mode used in a hub.
type PolicyMode int32

const (
	// Policy mode is unspecified. It defaults to PRESET
	// with preset_topology = MESH.
	PolicyMode_POLICY_MODE_UNSPECIFIED PolicyMode = 0
	// Hub uses one of the preset topologies.
	PolicyMode_PRESET PolicyMode = 1
)

// Enum value maps for PolicyMode.
var (
	PolicyMode_name = map[int32]string{
		0: "POLICY_MODE_UNSPECIFIED",
		1: "PRESET",
	}
	PolicyMode_value = map[string]int32{
		"POLICY_MODE_UNSPECIFIED": 0,
		"PRESET":                  1,
	}
)

func (x PolicyMode) Enum() *PolicyMode {
	p := new(PolicyMode)
	*p = x
	return p
}

func (x PolicyMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolicyMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[4].Descriptor()
}

func (PolicyMode) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[4]
}

func (x PolicyMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PolicyMode.Descriptor instead.
func (PolicyMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{4}
}

// The list of available preset topologies.
type PresetTopology int32

const (
	// Preset topology is unspecified. When policy_mode = PRESET,
	// it defaults to MESH.
	PresetTopology_PRESET_TOPOLOGY_UNSPECIFIED PresetTopology = 0
	// Mesh topology is implemented. Group `default` is automatically created.
	// All spokes in the hub are added to group `default`.
	PresetTopology_MESH PresetTopology = 2
	// Star topology is implemented. Two groups, `center` and `edge`, are
	// automatically created along with hub creation. Spokes have to join one of
	// the groups during creation.
	PresetTopology_STAR PresetTopology = 3
)

// Enum value maps for PresetTopology.
var (
	PresetTopology_name = map[int32]string{
		0: "PRESET_TOPOLOGY_UNSPECIFIED",
		2: "MESH",
		3: "STAR",
	}
	PresetTopology_value = map[string]int32{
		"PRESET_TOPOLOGY_UNSPECIFIED": 0,
		"MESH":                        2,
		"STAR":                        3,
	}
)

func (x PresetTopology) Enum() *PresetTopology {
	p := new(PresetTopology)
	*p = x
	return p
}

func (x PresetTopology) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PresetTopology) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[5].Descriptor()
}

func (PresetTopology) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[5]
}

func (x PresetTopology) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PresetTopology.Descriptor instead.
func (PresetTopology) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{5}
}

// The Code enum represents the various reasons a state can be `INACTIVE`.
type Spoke_StateReason_Code int32

const (
	// No information available.
	Spoke_StateReason_CODE_UNSPECIFIED Spoke_StateReason_Code = 0
	// The proposed spoke is pending review.
	Spoke_StateReason_PENDING_REVIEW Spoke_StateReason_Code = 1
	// The proposed spoke has been rejected by the hub administrator.
	Spoke_StateReason_REJECTED Spoke_StateReason_Code = 2
	// The spoke has been deactivated internally.
	Spoke_StateReason_PAUSED Spoke_StateReason_Code = 3
	// Network Connectivity Center encountered errors while accepting
	// the spoke.
	Spoke_StateReason_FAILED Spoke_StateReason_Code = 4
	// The proposed spoke update is pending review.
	Spoke_StateReason_UPDATE_PENDING_REVIEW Spoke_StateReason_Code = 5
	// The proposed spoke update has been rejected by the hub administrator.
	Spoke_StateReason_UPDATE_REJECTED Spoke_StateReason_Code = 6
	// Network Connectivity Center encountered errors while accepting
	// the spoke update.
	Spoke_StateReason_UPDATE_FAILED Spoke_StateReason_Code = 7
)

// Enum value maps for Spoke_StateReason_Code.
var (
	Spoke_StateReason_Code_name = map[int32]string{
		0: "CODE_UNSPECIFIED",
		1: "PENDING_REVIEW",
		2: "REJECTED",
		3: "PAUSED",
		4: "FAILED",
		5: "UPDATE_PENDING_REVIEW",
		6: "UPDATE_REJECTED",
		7: "UPDATE_FAILED",
	}
	Spoke_StateReason_Code_value = map[string]int32{
		"CODE_UNSPECIFIED":      0,
		"PENDING_REVIEW":        1,
		"REJECTED":              2,
		"PAUSED":                3,
		"FAILED":                4,
		"UPDATE_PENDING_REVIEW": 5,
		"UPDATE_REJECTED":       6,
		"UPDATE_FAILED":         7,
	}
)

func (x Spoke_StateReason_Code) Enum() *Spoke_StateReason_Code {
	p := new(Spoke_StateReason_Code)
	*p = x
	return p
}

func (x Spoke_StateReason_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Spoke_StateReason_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[6].Descriptor()
}

func (Spoke_StateReason_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[6]
}

func (x Spoke_StateReason_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Spoke_StateReason_Code.Descriptor instead.
func (Spoke_StateReason_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{2, 0, 0}
}

// Enum that controls which spoke fields are included in the response.
type ListHubSpokesRequest_SpokeView int32

const (
	// The spoke view is unspecified. When the spoke view is unspecified, the
	// API returns the same fields as the `BASIC` view.
	ListHubSpokesRequest_SPOKE_VIEW_UNSPECIFIED ListHubSpokesRequest_SpokeView = 0
	// Includes `name`, `create_time`, `hub`, `unique_id`, `state`, `reasons`,
	// and `spoke_type`. This is the default value.
	ListHubSpokesRequest_BASIC ListHubSpokesRequest_SpokeView = 1
	// Includes all spoke fields except `labels`.
	// You can use the `DETAILED` view only when you set the `spoke_locations`
	// field to `[global]`.
	ListHubSpokesRequest_DETAILED ListHubSpokesRequest_SpokeView = 2
)

// Enum value maps for ListHubSpokesRequest_SpokeView.
var (
	ListHubSpokesRequest_SpokeView_name = map[int32]string{
		0: "SPOKE_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "DETAILED",
	}
	ListHubSpokesRequest_SpokeView_value = map[string]int32{
		"SPOKE_VIEW_UNSPECIFIED": 0,
		"BASIC":                  1,
		"DETAILED":               2,
	}
)

func (x ListHubSpokesRequest_SpokeView) Enum() *ListHubSpokesRequest_SpokeView {
	p := new(ListHubSpokesRequest_SpokeView)
	*p = x
	return p
}

func (x ListHubSpokesRequest_SpokeView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListHubSpokesRequest_SpokeView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[7].Descriptor()
}

func (ListHubSpokesRequest_SpokeView) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[7]
}

func (x ListHubSpokesRequest_SpokeView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListHubSpokesRequest_SpokeView.Descriptor instead.
func (ListHubSpokesRequest_SpokeView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{13, 0}
}

// The Code enum represents the state of the Private Service Connect
// propagation.
type PscPropagationStatus_Code int32

const (
	// The code is unspecified.
	PscPropagationStatus_CODE_UNSPECIFIED PscPropagationStatus_Code = 0
	// The propagated Private Service Connect connection is ready.
	PscPropagationStatus_READY PscPropagationStatus_Code = 1
	// The Private Service Connect connection is propagating. This is a
	// transient state.
	PscPropagationStatus_PROPAGATING PscPropagationStatus_Code = 2
	// The Private Service Connect connection propagation failed because the VPC
	// network or the project of the target spoke has exceeded the connection
	// limit set by the producer.
	PscPropagationStatus_ERROR_PRODUCER_PROPAGATED_CONNECTION_LIMIT_EXCEEDED PscPropagationStatus_Code = 3
	// The Private Service Connect connection propagation failed because the NAT
	// IP subnet space has been exhausted. It is equivalent to the `Needs
	// attention` status of the Private Service Connect connection. See
	// https://cloud.google.com/vpc/docs/about-accessing-vpc-hosted-services-endpoints#connection-statuses.
	PscPropagationStatus_ERROR_PRODUCER_NAT_IP_SPACE_EXHAUSTED PscPropagationStatus_Code = 4
	// The Private Service Connect connection propagation failed because the
	// `PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK` quota in the
	// producer VPC network has been exceeded.
	PscPropagationStatus_ERROR_PRODUCER_QUOTA_EXCEEDED PscPropagationStatus_Code = 5
	// The Private Service Connect connection propagation failed because the
	// `PSC_PROPAGATED_CONNECTIONS_PER_VPC_NETWORK` quota in the consumer
	// VPC network has been exceeded.
	PscPropagationStatus_ERROR_CONSUMER_QUOTA_EXCEEDED PscPropagationStatus_Code = 6
)

// Enum value maps for PscPropagationStatus_Code.
var (
	PscPropagationStatus_Code_name = map[int32]string{
		0: "CODE_UNSPECIFIED",
		1: "READY",
		2: "PROPAGATING",
		3: "ERROR_PRODUCER_PROPAGATED_CONNECTION_LIMIT_EXCEEDED",
		4: "ERROR_PRODUCER_NAT_IP_SPACE_EXHAUSTED",
		5: "ERROR_PRODUCER_QUOTA_EXCEEDED",
		6: "ERROR_CONSUMER_QUOTA_EXCEEDED",
	}
	PscPropagationStatus_Code_value = map[string]int32{
		"CODE_UNSPECIFIED": 0,
		"READY":            1,
		"PROPAGATING":      2,
		"ERROR_PRODUCER_PROPAGATED_CONNECTION_LIMIT_EXCEEDED": 3,
		"ERROR_PRODUCER_NAT_IP_SPACE_EXHAUSTED":               4,
		"ERROR_PRODUCER_QUOTA_EXCEEDED":                       5,
		"ERROR_CONSUMER_QUOTA_EXCEEDED":                       6,
	}
)

func (x PscPropagationStatus_Code) Enum() *PscPropagationStatus_Code {
	p := new(PscPropagationStatus_Code)
	*p = x
	return p
}

func (x PscPropagationStatus_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PscPropagationStatus_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[8].Descriptor()
}

func (PscPropagationStatus_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[8]
}

func (x PscPropagationStatus_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PscPropagationStatus_Code.Descriptor instead.
func (PscPropagationStatus_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{18, 0}
}

// A Network Connectivity Center hub is a global management resource to which
// you attach spokes. A single hub can contain spokes from multiple regions.
// However, if any of a hub's spokes use the site-to-site data transfer feature,
// the resources associated with those spokes must all be in the same VPC
// network. Spokes that do not use site-to-site data transfer can be associated
// with any VPC network in your project.
type Hub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the hub. Hub names must be unique. They use the
	// following form:
	//
	//	`projects/{project_number}/locations/global/hubs/{hub_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the hub was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the hub was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional labels in key-value pair format. For more information about
	// labels, see [Requirements for
	// labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. An optional description of the hub.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The Google-generated UUID for the hub. This value is unique
	// across all hub resources. If a hub is deleted and another with the same
	// name is created, the new hub is assigned a different unique_id.
	UniqueId string `protobuf:"bytes,8,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
	// Output only. The current lifecycle state of this hub.
	State State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.State" json:"state,omitempty"`
	// The VPC networks associated with this hub's spokes.
	//
	// This field is read-only. Network Connectivity Center automatically
	// populates it based on the set of spokes attached to the hub.
	RoutingVpcs []*RoutingVPC `protobuf:"bytes,10,rep,name=routing_vpcs,json=routingVpcs,proto3" json:"routing_vpcs,omitempty"`
	// Output only. The route tables that belong to this hub. They use the
	// following form:
	//
	//	`projects/{project_number}/locations/global/hubs/{hub_id}/routeTables/{route_table_id}`
	//
	// This field is read-only. Network Connectivity Center automatically
	// populates it based on the route tables nested under the hub.
	RouteTables []string `protobuf:"bytes,11,rep,name=route_tables,json=routeTables,proto3" json:"route_tables,omitempty"`
	// Output only. A summary of the spokes associated with a hub. The
	// summary includes a count of spokes according to type
	// and according to state. If any spokes are inactive,
	// the summary also lists the reasons they are inactive,
	// including a count for each reason.
	SpokeSummary *SpokeSummary `protobuf:"bytes,12,opt,name=spoke_summary,json=spokeSummary,proto3" json:"spoke_summary,omitempty"`
	// Optional. The policy mode of this hub. This field can be either
	// PRESET or CUSTOM. If unspecified, the
	// policy_mode defaults to PRESET.
	PolicyMode PolicyMode `protobuf:"varint,13,opt,name=policy_mode,json=policyMode,proto3,enum=google.cloud.networkconnectivity.v1.PolicyMode" json:"policy_mode,omitempty"`
	// Optional. The topology implemented in this hub. Currently, this field is
	// only used when policy_mode = PRESET. The available preset topologies are
	// MESH and STAR. If preset_topology is unspecified and policy_mode = PRESET,
	// the preset_topology defaults to MESH. When policy_mode = CUSTOM,
	// the preset_topology is set to PRESET_TOPOLOGY_UNSPECIFIED.
	PresetTopology PresetTopology `protobuf:"varint,14,opt,name=preset_topology,json=presetTopology,proto3,enum=google.cloud.networkconnectivity.v1.PresetTopology" json:"preset_topology,omitempty"`
	// Optional. Whether Private Service Connect connection propagation is enabled
	// for the hub. If true, Private Service Connect endpoints in VPC spokes
	// attached to the hub are made accessible to other VPC spokes attached to the
	// hub. The default value is false.
	ExportPsc *bool `protobuf:"varint,15,opt,name=export_psc,json=exportPsc,proto3,oneof" json:"export_psc,omitempty"`
}

func (x *Hub) Reset() {
	*x = Hub{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Hub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hub) ProtoMessage() {}

func (x *Hub) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hub.ProtoReflect.Descriptor instead.
func (*Hub) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{0}
}

func (x *Hub) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Hub) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Hub) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Hub) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Hub) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Hub) GetUniqueId() string {
	if x != nil {
		return x.UniqueId
	}
	return ""
}

func (x *Hub) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Hub) GetRoutingVpcs() []*RoutingVPC {
	if x != nil {
		return x.RoutingVpcs
	}
	return nil
}

func (x *Hub) GetRouteTables() []string {
	if x != nil {
		return x.RouteTables
	}
	return nil
}

func (x *Hub) GetSpokeSummary() *SpokeSummary {
	if x != nil {
		return x.SpokeSummary
	}
	return nil
}

func (x *Hub) GetPolicyMode() PolicyMode {
	if x != nil {
		return x.PolicyMode
	}
	return PolicyMode_POLICY_MODE_UNSPECIFIED
}

func (x *Hub) GetPresetTopology() PresetTopology {
	if x != nil {
		return x.PresetTopology
	}
	return PresetTopology_PRESET_TOPOLOGY_UNSPECIFIED
}

func (x *Hub) GetExportPsc() bool {
	if x != nil && x.ExportPsc != nil {
		return *x.ExportPsc
	}
	return false
}

// RoutingVPC contains information about the VPC networks associated
// with the spokes of a Network Connectivity Center hub.
type RoutingVPC struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the VPC network.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Output only. If true, indicates that this VPC network is currently
	// associated with spokes that use the data transfer feature (spokes where the
	// site_to_site_data_transfer field is set to true). If you create new spokes
	// that use data transfer, they must be associated with this VPC network. At
	// most, one VPC network will have this field set to true.
	RequiredForNewSiteToSiteDataTransferSpokes bool `protobuf:"varint,2,opt,name=required_for_new_site_to_site_data_transfer_spokes,json=requiredForNewSiteToSiteDataTransferSpokes,proto3" json:"required_for_new_site_to_site_data_transfer_spokes,omitempty"`
}

func (x *RoutingVPC) Reset() {
	*x = RoutingVPC{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoutingVPC) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutingVPC) ProtoMessage() {}

func (x *RoutingVPC) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutingVPC.ProtoReflect.Descriptor instead.
func (*RoutingVPC) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{1}
}

func (x *RoutingVPC) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *RoutingVPC) GetRequiredForNewSiteToSiteDataTransferSpokes() bool {
	if x != nil {
		return x.RequiredForNewSiteToSiteDataTransferSpokes
	}
	return false
}

// A Network Connectivity Center spoke represents one or more network
// connectivity resources.
//
// When you create a spoke, you associate it with a hub. You must also
// identify a value for exactly one of the following fields:
//
// * linked_vpn_tunnels
// * linked_interconnect_attachments
// * linked_router_appliance_instances
// * linked_vpc_network
type Spoke struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the spoke. Spoke names must be unique. They use the
	// following form:
	//
	//	`projects/{project_number}/locations/{region}/spokes/{spoke_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the spoke was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the spoke was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional labels in key-value pair format. For more information about
	// labels, see [Requirements for
	// labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. An optional description of the spoke.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Immutable. The name of the hub that this spoke is attached to.
	Hub string `protobuf:"bytes,6,opt,name=hub,proto3" json:"hub,omitempty"`
	// Optional. The name of the group that this spoke is associated with.
	Group string `protobuf:"bytes,23,opt,name=group,proto3" json:"group,omitempty"`
	// Optional. VPN tunnels that are associated with the spoke.
	LinkedVpnTunnels *LinkedVpnTunnels `protobuf:"bytes,17,opt,name=linked_vpn_tunnels,json=linkedVpnTunnels,proto3" json:"linked_vpn_tunnels,omitempty"`
	// Optional. VLAN attachments that are associated with the spoke.
	LinkedInterconnectAttachments *LinkedInterconnectAttachments `protobuf:"bytes,18,opt,name=linked_interconnect_attachments,json=linkedInterconnectAttachments,proto3" json:"linked_interconnect_attachments,omitempty"`
	// Optional. Router appliance instances that are associated with the spoke.
	LinkedRouterApplianceInstances *LinkedRouterApplianceInstances `protobuf:"bytes,19,opt,name=linked_router_appliance_instances,json=linkedRouterApplianceInstances,proto3" json:"linked_router_appliance_instances,omitempty"`
	// Optional. VPC network that is associated with the spoke.
	LinkedVpcNetwork *LinkedVpcNetwork `protobuf:"bytes,20,opt,name=linked_vpc_network,json=linkedVpcNetwork,proto3" json:"linked_vpc_network,omitempty"`
	// Optional. The linked producer VPC that is associated with the spoke.
	LinkedProducerVpcNetwork *LinkedProducerVpcNetwork `protobuf:"bytes,26,opt,name=linked_producer_vpc_network,json=linkedProducerVpcNetwork,proto3" json:"linked_producer_vpc_network,omitempty"`
	// Output only. The Google-generated UUID for the spoke. This value is unique
	// across all spoke resources. If a spoke is deleted and another with the same
	// name is created, the new spoke is assigned a different `unique_id`.
	UniqueId string `protobuf:"bytes,11,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
	// Output only. The current lifecycle state of this spoke.
	State State `protobuf:"varint,15,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.State" json:"state,omitempty"`
	// Output only. The reasons for current state of the spoke.
	Reasons []*Spoke_StateReason `protobuf:"bytes,21,rep,name=reasons,proto3" json:"reasons,omitempty"`
	// Output only. The type of resource associated with the spoke.
	SpokeType SpokeType `protobuf:"varint,22,opt,name=spoke_type,json=spokeType,proto3,enum=google.cloud.networkconnectivity.v1.SpokeType" json:"spoke_type,omitempty"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,27,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. The list of fields waiting for hub administration's approval.
	FieldPathsPendingUpdate []string `protobuf:"bytes,28,rep,name=field_paths_pending_update,json=fieldPathsPendingUpdate,proto3" json:"field_paths_pending_update,omitempty"`
}

func (x *Spoke) Reset() {
	*x = Spoke{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Spoke) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Spoke) ProtoMessage() {}

func (x *Spoke) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Spoke.ProtoReflect.Descriptor instead.
func (*Spoke) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{2}
}

func (x *Spoke) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Spoke) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Spoke) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Spoke) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Spoke) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Spoke) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *Spoke) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *Spoke) GetLinkedVpnTunnels() *LinkedVpnTunnels {
	if x != nil {
		return x.LinkedVpnTunnels
	}
	return nil
}

func (x *Spoke) GetLinkedInterconnectAttachments() *LinkedInterconnectAttachments {
	if x != nil {
		return x.LinkedInterconnectAttachments
	}
	return nil
}

func (x *Spoke) GetLinkedRouterApplianceInstances() *LinkedRouterApplianceInstances {
	if x != nil {
		return x.LinkedRouterApplianceInstances
	}
	return nil
}

func (x *Spoke) GetLinkedVpcNetwork() *LinkedVpcNetwork {
	if x != nil {
		return x.LinkedVpcNetwork
	}
	return nil
}

func (x *Spoke) GetLinkedProducerVpcNetwork() *LinkedProducerVpcNetwork {
	if x != nil {
		return x.LinkedProducerVpcNetwork
	}
	return nil
}

func (x *Spoke) GetUniqueId() string {
	if x != nil {
		return x.UniqueId
	}
	return ""
}

func (x *Spoke) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Spoke) GetReasons() []*Spoke_StateReason {
	if x != nil {
		return x.Reasons
	}
	return nil
}

func (x *Spoke) GetSpokeType() SpokeType {
	if x != nil {
		return x.SpokeType
	}
	return SpokeType_SPOKE_TYPE_UNSPECIFIED
}

func (x *Spoke) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Spoke) GetFieldPathsPendingUpdate() []string {
	if x != nil {
		return x.FieldPathsPendingUpdate
	}
	return nil
}

type RouteTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the route table. Route table names must be unique.
	// They use the following form:
	//
	//	`projects/{project_number}/locations/global/hubs/{hub}/routeTables/{route_table_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the route table was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the route table was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional labels in key-value pair format. For more information about
	// labels, see [Requirements for
	// labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An optional description of the route table.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The Google-generated UUID for the route table. This value is
	// unique across all route table resources. If a route table is deleted and
	// another with the same name is created, the new route table is assigned
	// a different `uid`.
	Uid string `protobuf:"bytes,6,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The current lifecycle state of this route table.
	State State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.State" json:"state,omitempty"`
}

func (x *RouteTable) Reset() {
	*x = RouteTable{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouteTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteTable) ProtoMessage() {}

func (x *RouteTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteTable.ProtoReflect.Descriptor instead.
func (*RouteTable) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{3}
}

func (x *RouteTable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RouteTable) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *RouteTable) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *RouteTable) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *RouteTable) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RouteTable) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *RouteTable) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

// A route defines a path from VM instances within a spoke to a specific
// destination resource. Only VPC spokes have routes.
type Route struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the route. Route names must be unique. Route names
	// use the following form:
	//
	//	`projects/{project_number}/locations/global/hubs/{hub}/routeTables/{route_table_id}/routes/{route_id}`
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the route was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the route was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The destination IP address range.
	IpCidrRange string `protobuf:"bytes,1,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// Output only. The route's type. Its type is determined by the properties of
	// its IP address range.
	Type RouteType `protobuf:"varint,10,opt,name=type,proto3,enum=google.cloud.networkconnectivity.v1.RouteType" json:"type,omitempty"`
	// Immutable. The destination VPC network for packets on this route.
	NextHopVpcNetwork *NextHopVpcNetwork `protobuf:"bytes,2,opt,name=next_hop_vpc_network,json=nextHopVpcNetwork,proto3" json:"next_hop_vpc_network,omitempty"`
	// Optional labels in key-value pair format. For more information about
	// labels, see [Requirements for
	// labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An optional description of the route.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The Google-generated UUID for the route. This value is unique
	// across all Network Connectivity Center route resources. If a
	// route is deleted and another with the same name is created,
	// the new route is assigned a different `uid`.
	Uid string `protobuf:"bytes,8,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The current lifecycle state of the route.
	State State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.State" json:"state,omitempty"`
	// Immutable. The spoke that this route leads to.
	// Example: projects/12345/locations/global/spokes/SPOKE
	Spoke string `protobuf:"bytes,11,opt,name=spoke,proto3" json:"spoke,omitempty"`
	// Output only. The origin location of the route.
	// Uses the following form: "projects/{project}/locations/{location}"
	// Example: projects/1234/locations/us-central1
	Location string `protobuf:"bytes,12,opt,name=location,proto3" json:"location,omitempty"`
	// Output only. The priority of this route. Priority is used to break ties in
	// cases where a destination matches more than one route. In these cases the
	// route with the lowest-numbered priority value wins.
	Priority int64 `protobuf:"varint,13,opt,name=priority,proto3" json:"priority,omitempty"`
	// Immutable. The next-hop VPN tunnel for packets on this route.
	NextHopVpnTunnel *NextHopVPNTunnel `protobuf:"bytes,14,opt,name=next_hop_vpn_tunnel,json=nextHopVpnTunnel,proto3" json:"next_hop_vpn_tunnel,omitempty"`
	// Immutable. The next-hop Router appliance instance for packets on this
	// route.
	NextHopRouterApplianceInstance *NextHopRouterApplianceInstance `protobuf:"bytes,15,opt,name=next_hop_router_appliance_instance,json=nextHopRouterApplianceInstance,proto3" json:"next_hop_router_appliance_instance,omitempty"`
	// Immutable. The next-hop VLAN attachment for packets on this route.
	NextHopInterconnectAttachment *NextHopInterconnectAttachment `protobuf:"bytes,16,opt,name=next_hop_interconnect_attachment,json=nextHopInterconnectAttachment,proto3" json:"next_hop_interconnect_attachment,omitempty"`
}

func (x *Route) Reset() {
	*x = Route{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Route) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Route) ProtoMessage() {}

func (x *Route) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Route.ProtoReflect.Descriptor instead.
func (*Route) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{4}
}

func (x *Route) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Route) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Route) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Route) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *Route) GetType() RouteType {
	if x != nil {
		return x.Type
	}
	return RouteType_ROUTE_TYPE_UNSPECIFIED
}

func (x *Route) GetNextHopVpcNetwork() *NextHopVpcNetwork {
	if x != nil {
		return x.NextHopVpcNetwork
	}
	return nil
}

func (x *Route) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Route) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Route) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Route) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Route) GetSpoke() string {
	if x != nil {
		return x.Spoke
	}
	return ""
}

func (x *Route) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Route) GetPriority() int64 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Route) GetNextHopVpnTunnel() *NextHopVPNTunnel {
	if x != nil {
		return x.NextHopVpnTunnel
	}
	return nil
}

func (x *Route) GetNextHopRouterApplianceInstance() *NextHopRouterApplianceInstance {
	if x != nil {
		return x.NextHopRouterApplianceInstance
	}
	return nil
}

func (x *Route) GetNextHopInterconnectAttachment() *NextHopInterconnectAttachment {
	if x != nil {
		return x.NextHopInterconnectAttachment
	}
	return nil
}

// A group represents a subset of spokes attached to a hub.
type Group struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the group. Group names must be unique. They
	// use the following form:
	//
	//	`projects/{project_number}/locations/global/hubs/{hub}/groups/{group_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the group was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the group was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels in key-value pair format. For more information about
	// labels, see [Requirements for
	// labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The description of the group.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The Google-generated UUID for the group. This value is unique
	// across all group resources. If a group is deleted and
	// another with the same name is created, the new route table is assigned
	// a different unique_id.
	Uid string `protobuf:"bytes,6,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The current lifecycle state of this group.
	State State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.State" json:"state,omitempty"`
	// Optional. The auto-accept setting for this group.
	AutoAccept *AutoAccept `protobuf:"bytes,8,opt,name=auto_accept,json=autoAccept,proto3" json:"auto_accept,omitempty"`
	// Output only. The name of the route table that corresponds to this group.
	// They use the following form:
	// `projects/{project_number}/locations/global/hubs/{hub_id}/routeTables/{route_table_id}`
	RouteTable string `protobuf:"bytes,9,opt,name=route_table,json=routeTable,proto3" json:"route_table,omitempty"`
}

func (x *Group) Reset() {
	*x = Group{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Group) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Group) ProtoMessage() {}

func (x *Group) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Group.ProtoReflect.Descriptor instead.
func (*Group) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{5}
}

func (x *Group) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Group) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Group) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Group) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Group) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Group) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Group) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Group) GetAutoAccept() *AutoAccept {
	if x != nil {
		return x.AutoAccept
	}
	return nil
}

func (x *Group) GetRouteTable() string {
	if x != nil {
		return x.RouteTable
	}
	return ""
}

// The auto-accept setting for a group controls whether
// proposed spokes are automatically attached to the hub. If auto-accept is
// enabled, the spoke immediately is attached to the hub and becomes part of the
// group. In this case, the new spoke is in the ACTIVE state.
// If auto-accept is disabled, the spoke goes to the INACTIVE
// state, and it must be reviewed and accepted by a hub
// administrator.
type AutoAccept struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of project ids or project numbers for which you want
	// to enable auto-accept. The auto-accept setting is applied to
	// spokes being created or updated in these projects.
	AutoAcceptProjects []string `protobuf:"bytes,1,rep,name=auto_accept_projects,json=autoAcceptProjects,proto3" json:"auto_accept_projects,omitempty"`
}

func (x *AutoAccept) Reset() {
	*x = AutoAccept{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoAccept) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoAccept) ProtoMessage() {}

func (x *AutoAccept) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoAccept.ProtoReflect.Descriptor instead.
func (*AutoAccept) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{6}
}

func (x *AutoAccept) GetAutoAcceptProjects() []string {
	if x != nil {
		return x.AutoAcceptProjects
	}
	return nil
}

// Request for
// [HubService.ListHubs][google.cloud.networkconnectivity.v1.HubService.ListHubs]
// method.
type ListHubsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListHubsRequest) Reset() {
	*x = ListHubsRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListHubsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHubsRequest) ProtoMessage() {}

func (x *ListHubsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHubsRequest.ProtoReflect.Descriptor instead.
func (*ListHubsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{7}
}

func (x *ListHubsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListHubsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListHubsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListHubsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListHubsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for
// [HubService.ListHubs][google.cloud.networkconnectivity.v1.HubService.ListHubs]
// method.
type ListHubsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested hubs.
	Hubs []*Hub `protobuf:"bytes,1,rep,name=hubs,proto3" json:"hubs,omitempty"`
	// The token for the next page of the response. To see more results,
	// use this value as the page_token for your next request. If this value
	// is empty, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListHubsResponse) Reset() {
	*x = ListHubsResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListHubsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHubsResponse) ProtoMessage() {}

func (x *ListHubsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHubsResponse.ProtoReflect.Descriptor instead.
func (*ListHubsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{8}
}

func (x *ListHubsResponse) GetHubs() []*Hub {
	if x != nil {
		return x.Hubs
	}
	return nil
}

func (x *ListHubsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListHubsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for
// [HubService.GetHub][google.cloud.networkconnectivity.v1.HubService.GetHub]
// method.
type GetHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetHubRequest) Reset() {
	*x = GetHubRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHubRequest) ProtoMessage() {}

func (x *GetHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHubRequest.ProtoReflect.Descriptor instead.
func (*GetHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{9}
}

func (x *GetHubRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for
// [HubService.CreateHub][google.cloud.networkconnectivity.v1.HubService.CreateHub]
// method.
type CreateHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A unique identifier for the hub.
	HubId string `protobuf:"bytes,2,opt,name=hub_id,json=hubId,proto3" json:"hub_id,omitempty"`
	// Required. The initial values for a new hub.
	Hub *Hub `protobuf:"bytes,3,opt,name=hub,proto3" json:"hub,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateHubRequest) Reset() {
	*x = CreateHubRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateHubRequest) ProtoMessage() {}

func (x *CreateHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateHubRequest.ProtoReflect.Descriptor instead.
func (*CreateHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{10}
}

func (x *CreateHubRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateHubRequest) GetHubId() string {
	if x != nil {
		return x.HubId
	}
	return ""
}

func (x *CreateHubRequest) GetHub() *Hub {
	if x != nil {
		return x.Hub
	}
	return nil
}

func (x *CreateHubRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for
// [HubService.UpdateHub][google.cloud.networkconnectivity.v1.HubService.UpdateHub]
// method.
type UpdateHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. In the case of an update to an existing hub, field mask is used
	// to specify the fields to be overwritten. The fields specified in the
	// update_mask are relative to the resource, not the full request. A field is
	// overwritten if it is in the mask. If the user does not provide a mask, then
	// all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The state that the hub should be in after the update.
	Hub *Hub `protobuf:"bytes,2,opt,name=hub,proto3" json:"hub,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateHubRequest) Reset() {
	*x = UpdateHubRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateHubRequest) ProtoMessage() {}

func (x *UpdateHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateHubRequest.ProtoReflect.Descriptor instead.
func (*UpdateHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateHubRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateHubRequest) GetHub() *Hub {
	if x != nil {
		return x.Hub
	}
	return nil
}

func (x *UpdateHubRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for
// [HubService.DeleteHub][google.cloud.networkconnectivity.v1.HubService.DeleteHub].
type DeleteHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteHubRequest) Reset() {
	*x = DeleteHubRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteHubRequest) ProtoMessage() {}

func (x *DeleteHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteHubRequest.ProtoReflect.Descriptor instead.
func (*DeleteHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteHubRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteHubRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for
// [HubService.ListHubSpokes][google.cloud.networkconnectivity.v1.HubService.ListHubSpokes].
type ListHubSpokesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of locations.
	// Specify one of the following: `[global]`, a single region (for
	// example, `[us-central1]`), or a combination of
	// values (for example, `[global, us-central1, us-west1]`).
	// If the spoke_locations field is populated, the list of results
	// includes only spokes in the specified location.
	// If the spoke_locations field is not populated, the list of results
	// includes spokes in all locations.
	SpokeLocations []string `protobuf:"bytes,2,rep,name=spoke_locations,json=spokeLocations,proto3" json:"spoke_locations,omitempty"`
	// The maximum number of results to return per page.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of results.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by name or create_time.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// The view of the spoke to return.
	// The view that you use determines which spoke fields are included in the
	// response.
	View ListHubSpokesRequest_SpokeView `protobuf:"varint,7,opt,name=view,proto3,enum=google.cloud.networkconnectivity.v1.ListHubSpokesRequest_SpokeView" json:"view,omitempty"`
}

func (x *ListHubSpokesRequest) Reset() {
	*x = ListHubSpokesRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListHubSpokesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHubSpokesRequest) ProtoMessage() {}

func (x *ListHubSpokesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHubSpokesRequest.ProtoReflect.Descriptor instead.
func (*ListHubSpokesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{13}
}

func (x *ListHubSpokesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListHubSpokesRequest) GetSpokeLocations() []string {
	if x != nil {
		return x.SpokeLocations
	}
	return nil
}

func (x *ListHubSpokesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListHubSpokesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListHubSpokesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListHubSpokesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListHubSpokesRequest) GetView() ListHubSpokesRequest_SpokeView {
	if x != nil {
		return x.View
	}
	return ListHubSpokesRequest_SPOKE_VIEW_UNSPECIFIED
}

// The response for
// [HubService.ListHubSpokes][google.cloud.networkconnectivity.v1.HubService.ListHubSpokes].
type ListHubSpokesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested spokes.
	// The spoke fields can be partially populated based on the `view` field in
	// the request message.
	Spokes []*Spoke `protobuf:"bytes,1,rep,name=spokes,proto3" json:"spokes,omitempty"`
	// The token for the next page of the response. To see more results,
	// use this value as the page_token for your next request. If this value
	// is empty, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListHubSpokesResponse) Reset() {
	*x = ListHubSpokesResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListHubSpokesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHubSpokesResponse) ProtoMessage() {}

func (x *ListHubSpokesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHubSpokesResponse.ProtoReflect.Descriptor instead.
func (*ListHubSpokesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{14}
}

func (x *ListHubSpokesResponse) GetSpokes() []*Spoke {
	if x != nil {
		return x.Spokes
	}
	return nil
}

func (x *ListHubSpokesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListHubSpokesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request for
// [HubService.QueryHubStatus][google.cloud.networkconnectivity.v1.HubService.QueryHubStatus].
type QueryHubStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The maximum number of results to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression that filters the list of results.
	// The filter can be used to filter the results by the following fields:
	//   - `psc_propagation_status.source_spoke`
	//   - `psc_propagation_status.source_group`
	//   - `psc_propagation_status.source_forwarding_rule`
	//   - `psc_propagation_status.target_spoke`
	//   - `psc_propagation_status.target_group`
	//   - `psc_propagation_status.code`
	//   - `psc_propagation_status.message`
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Sort the results in ascending order by the specified fields.
	// A comma-separated list of any of these fields:
	//   - `psc_propagation_status.source_spoke`
	//   - `psc_propagation_status.source_group`
	//   - `psc_propagation_status.source_forwarding_rule`
	//   - `psc_propagation_status.target_spoke`
	//   - `psc_propagation_status.target_group`
	//   - `psc_propagation_status.code`
	//
	// If `group_by` is set, the value of the `order_by` field must be the
	// same as or a subset of the `group_by` field.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. Aggregate the results by the specified fields.
	// A comma-separated list of any of these fields:
	//   - `psc_propagation_status.source_spoke`
	//   - `psc_propagation_status.source_group`
	//   - `psc_propagation_status.source_forwarding_rule`
	//   - `psc_propagation_status.target_spoke`
	//   - `psc_propagation_status.target_group`
	//   - `psc_propagation_status.code`
	GroupBy string `protobuf:"bytes,6,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
}

func (x *QueryHubStatusRequest) Reset() {
	*x = QueryHubStatusRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryHubStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryHubStatusRequest) ProtoMessage() {}

func (x *QueryHubStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryHubStatusRequest.ProtoReflect.Descriptor instead.
func (*QueryHubStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{15}
}

func (x *QueryHubStatusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryHubStatusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryHubStatusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *QueryHubStatusRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *QueryHubStatusRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *QueryHubStatusRequest) GetGroupBy() string {
	if x != nil {
		return x.GroupBy
	}
	return ""
}

// The response for
// [HubService.QueryHubStatus][google.cloud.networkconnectivity.v1.HubService.QueryHubStatus].
type QueryHubStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of hub status.
	HubStatusEntries []*HubStatusEntry `protobuf:"bytes,1,rep,name=hub_status_entries,json=hubStatusEntries,proto3" json:"hub_status_entries,omitempty"`
	// The token for the next page of the response. To see more results,
	// use this value as the page_token for your next request. If this value
	// is empty, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *QueryHubStatusResponse) Reset() {
	*x = QueryHubStatusResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryHubStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryHubStatusResponse) ProtoMessage() {}

func (x *QueryHubStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryHubStatusResponse.ProtoReflect.Descriptor instead.
func (*QueryHubStatusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{16}
}

func (x *QueryHubStatusResponse) GetHubStatusEntries() []*HubStatusEntry {
	if x != nil {
		return x.HubStatusEntries
	}
	return nil
}

func (x *QueryHubStatusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A hub status entry represents the status of a set of propagated Private
// Service Connect connections grouped by certain fields.
type HubStatusEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of propagated Private Service Connect connections with this
	// status. If the `group_by` field was not set in the request message, the
	// value of this field is 1.
	Count int32 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// The fields that this entry is grouped by. This has the same value as the
	// `group_by` field in the request message.
	GroupBy string `protobuf:"bytes,2,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// The Private Service Connect propagation status.
	PscPropagationStatus *PscPropagationStatus `protobuf:"bytes,3,opt,name=psc_propagation_status,json=pscPropagationStatus,proto3" json:"psc_propagation_status,omitempty"`
}

func (x *HubStatusEntry) Reset() {
	*x = HubStatusEntry{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HubStatusEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HubStatusEntry) ProtoMessage() {}

func (x *HubStatusEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HubStatusEntry.ProtoReflect.Descriptor instead.
func (*HubStatusEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{17}
}

func (x *HubStatusEntry) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *HubStatusEntry) GetGroupBy() string {
	if x != nil {
		return x.GroupBy
	}
	return ""
}

func (x *HubStatusEntry) GetPscPropagationStatus() *PscPropagationStatus {
	if x != nil {
		return x.PscPropagationStatus
	}
	return nil
}

// The status of one or more propagated Private Service Connect connections in a
// hub.
type PscPropagationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the spoke that the source forwarding rule belongs to.
	SourceSpoke string `protobuf:"bytes,1,opt,name=source_spoke,json=sourceSpoke,proto3" json:"source_spoke,omitempty"`
	// The name of the group that the source spoke belongs to.
	SourceGroup string `protobuf:"bytes,2,opt,name=source_group,json=sourceGroup,proto3" json:"source_group,omitempty"`
	// The name of the forwarding rule exported to the hub.
	SourceForwardingRule string `protobuf:"bytes,3,opt,name=source_forwarding_rule,json=sourceForwardingRule,proto3" json:"source_forwarding_rule,omitempty"`
	// The name of the spoke that the source forwarding rule propagates to.
	TargetSpoke string `protobuf:"bytes,4,opt,name=target_spoke,json=targetSpoke,proto3" json:"target_spoke,omitempty"`
	// The name of the group that the target spoke belongs to.
	TargetGroup string `protobuf:"bytes,5,opt,name=target_group,json=targetGroup,proto3" json:"target_group,omitempty"`
	// The propagation status.
	Code PscPropagationStatus_Code `protobuf:"varint,6,opt,name=code,proto3,enum=google.cloud.networkconnectivity.v1.PscPropagationStatus_Code" json:"code,omitempty"`
	// The human-readable summary of the Private Service Connect connection
	// propagation status.
	Message string `protobuf:"bytes,7,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *PscPropagationStatus) Reset() {
	*x = PscPropagationStatus{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PscPropagationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscPropagationStatus) ProtoMessage() {}

func (x *PscPropagationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscPropagationStatus.ProtoReflect.Descriptor instead.
func (*PscPropagationStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{18}
}

func (x *PscPropagationStatus) GetSourceSpoke() string {
	if x != nil {
		return x.SourceSpoke
	}
	return ""
}

func (x *PscPropagationStatus) GetSourceGroup() string {
	if x != nil {
		return x.SourceGroup
	}
	return ""
}

func (x *PscPropagationStatus) GetSourceForwardingRule() string {
	if x != nil {
		return x.SourceForwardingRule
	}
	return ""
}

func (x *PscPropagationStatus) GetTargetSpoke() string {
	if x != nil {
		return x.TargetSpoke
	}
	return ""
}

func (x *PscPropagationStatus) GetTargetGroup() string {
	if x != nil {
		return x.TargetGroup
	}
	return ""
}

func (x *PscPropagationStatus) GetCode() PscPropagationStatus_Code {
	if x != nil {
		return x.Code
	}
	return PscPropagationStatus_CODE_UNSPECIFIED
}

func (x *PscPropagationStatus) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// The request for
// [HubService.ListSpokes][google.cloud.networkconnectivity.v1.HubService.ListSpokes].
type ListSpokesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListSpokesRequest) Reset() {
	*x = ListSpokesRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSpokesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpokesRequest) ProtoMessage() {}

func (x *ListSpokesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpokesRequest.ProtoReflect.Descriptor instead.
func (*ListSpokesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{19}
}

func (x *ListSpokesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSpokesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSpokesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSpokesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSpokesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response for
// [HubService.ListSpokes][google.cloud.networkconnectivity.v1.HubService.ListSpokes].
type ListSpokesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested spokes.
	Spokes []*Spoke `protobuf:"bytes,1,rep,name=spokes,proto3" json:"spokes,omitempty"`
	// The token for the next page of the response. To see more results,
	// use this value as the page_token for your next request. If this value
	// is empty, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListSpokesResponse) Reset() {
	*x = ListSpokesResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSpokesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpokesResponse) ProtoMessage() {}

func (x *ListSpokesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpokesResponse.ProtoReflect.Descriptor instead.
func (*ListSpokesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{20}
}

func (x *ListSpokesResponse) GetSpokes() []*Spoke {
	if x != nil {
		return x.Spokes
	}
	return nil
}

func (x *ListSpokesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSpokesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request for
// [HubService.GetSpoke][google.cloud.networkconnectivity.v1.HubService.GetSpoke].
type GetSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spoke resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpokeRequest) Reset() {
	*x = GetSpokeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpokeRequest) ProtoMessage() {}

func (x *GetSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpokeRequest.ProtoReflect.Descriptor instead.
func (*GetSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{21}
}

func (x *GetSpokeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [HubService.CreateSpoke][google.cloud.networkconnectivity.v1.HubService.CreateSpoke].
type CreateSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Unique id for the spoke to create.
	SpokeId string `protobuf:"bytes,2,opt,name=spoke_id,json=spokeId,proto3" json:"spoke_id,omitempty"`
	// Required. The initial values for a new spoke.
	Spoke *Spoke `protobuf:"bytes,3,opt,name=spoke,proto3" json:"spoke,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSpokeRequest) Reset() {
	*x = CreateSpokeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpokeRequest) ProtoMessage() {}

func (x *CreateSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpokeRequest.ProtoReflect.Descriptor instead.
func (*CreateSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{22}
}

func (x *CreateSpokeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSpokeRequest) GetSpokeId() string {
	if x != nil {
		return x.SpokeId
	}
	return ""
}

func (x *CreateSpokeRequest) GetSpoke() *Spoke {
	if x != nil {
		return x.Spoke
	}
	return nil
}

func (x *CreateSpokeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for
// [HubService.UpdateSpoke][google.cloud.networkconnectivity.v1.HubService.UpdateSpoke]
// method.
type UpdateSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. In the case of an update to an existing spoke, field mask is used
	// to specify the fields to be overwritten. The fields specified in the
	// update_mask are relative to the resource, not the full request. A field is
	// overwritten if it is in the mask. If the user does not provide a mask, then
	// all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The state that the spoke should be in after the update.
	Spoke *Spoke `protobuf:"bytes,2,opt,name=spoke,proto3" json:"spoke,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateSpokeRequest) Reset() {
	*x = UpdateSpokeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpokeRequest) ProtoMessage() {}

func (x *UpdateSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpokeRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{23}
}

func (x *UpdateSpokeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSpokeRequest) GetSpoke() *Spoke {
	if x != nil {
		return x.Spoke
	}
	return nil
}

func (x *UpdateSpokeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for
// [HubService.DeleteSpoke][google.cloud.networkconnectivity.v1.HubService.DeleteSpoke].
type DeleteSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spoke to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteSpokeRequest) Reset() {
	*x = DeleteSpokeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSpokeRequest) ProtoMessage() {}

func (x *DeleteSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSpokeRequest.ProtoReflect.Descriptor instead.
func (*DeleteSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{24}
}

func (x *DeleteSpokeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteSpokeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for
// [HubService.AcceptHubSpoke][google.cloud.networkconnectivity.v1.HubService.AcceptHubSpoke].
type AcceptHubSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub into which to accept the spoke.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The URI of the spoke to accept into the hub.
	SpokeUri string `protobuf:"bytes,2,opt,name=spoke_uri,json=spokeUri,proto3" json:"spoke_uri,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *AcceptHubSpokeRequest) Reset() {
	*x = AcceptHubSpokeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcceptHubSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceptHubSpokeRequest) ProtoMessage() {}

func (x *AcceptHubSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceptHubSpokeRequest.ProtoReflect.Descriptor instead.
func (*AcceptHubSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{25}
}

func (x *AcceptHubSpokeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AcceptHubSpokeRequest) GetSpokeUri() string {
	if x != nil {
		return x.SpokeUri
	}
	return ""
}

func (x *AcceptHubSpokeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The response for
// [HubService.AcceptHubSpoke][google.cloud.networkconnectivity.v1.HubService.AcceptHubSpoke].
type AcceptHubSpokeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The spoke that was operated on.
	Spoke *Spoke `protobuf:"bytes,1,opt,name=spoke,proto3" json:"spoke,omitempty"`
}

func (x *AcceptHubSpokeResponse) Reset() {
	*x = AcceptHubSpokeResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcceptHubSpokeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceptHubSpokeResponse) ProtoMessage() {}

func (x *AcceptHubSpokeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceptHubSpokeResponse.ProtoReflect.Descriptor instead.
func (*AcceptHubSpokeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{26}
}

func (x *AcceptHubSpokeResponse) GetSpoke() *Spoke {
	if x != nil {
		return x.Spoke
	}
	return nil
}

// The request for
// [HubService.RejectHubSpoke][google.cloud.networkconnectivity.v1.HubService.RejectHubSpoke].
type RejectHubSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub from which to reject the spoke.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The URI of the spoke to reject from the hub.
	SpokeUri string `protobuf:"bytes,2,opt,name=spoke_uri,json=spokeUri,proto3" json:"spoke_uri,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Additional information provided by the hub administrator.
	Details string `protobuf:"bytes,4,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *RejectHubSpokeRequest) Reset() {
	*x = RejectHubSpokeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RejectHubSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectHubSpokeRequest) ProtoMessage() {}

func (x *RejectHubSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectHubSpokeRequest.ProtoReflect.Descriptor instead.
func (*RejectHubSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{27}
}

func (x *RejectHubSpokeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RejectHubSpokeRequest) GetSpokeUri() string {
	if x != nil {
		return x.SpokeUri
	}
	return ""
}

func (x *RejectHubSpokeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *RejectHubSpokeRequest) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

// The response for
// [HubService.RejectHubSpoke][google.cloud.networkconnectivity.v1.HubService.RejectHubSpoke].
type RejectHubSpokeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The spoke that was operated on.
	Spoke *Spoke `protobuf:"bytes,1,opt,name=spoke,proto3" json:"spoke,omitempty"`
}

func (x *RejectHubSpokeResponse) Reset() {
	*x = RejectHubSpokeResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RejectHubSpokeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectHubSpokeResponse) ProtoMessage() {}

func (x *RejectHubSpokeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectHubSpokeResponse.ProtoReflect.Descriptor instead.
func (*RejectHubSpokeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{28}
}

func (x *RejectHubSpokeResponse) GetSpoke() *Spoke {
	if x != nil {
		return x.Spoke
	}
	return nil
}

// The request for
// [HubService.AcceptSpokeUpdate][google.cloud.networkconnectivity.v1.HubService.AcceptSpokeUpdate].
type AcceptSpokeUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub to accept spoke update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The URI of the spoke to accept update.
	SpokeUri string `protobuf:"bytes,2,opt,name=spoke_uri,json=spokeUri,proto3" json:"spoke_uri,omitempty"`
	// Required. The etag of the spoke to accept update.
	SpokeEtag string `protobuf:"bytes,3,opt,name=spoke_etag,json=spokeEtag,proto3" json:"spoke_etag,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *AcceptSpokeUpdateRequest) Reset() {
	*x = AcceptSpokeUpdateRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcceptSpokeUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceptSpokeUpdateRequest) ProtoMessage() {}

func (x *AcceptSpokeUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceptSpokeUpdateRequest.ProtoReflect.Descriptor instead.
func (*AcceptSpokeUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{29}
}

func (x *AcceptSpokeUpdateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AcceptSpokeUpdateRequest) GetSpokeUri() string {
	if x != nil {
		return x.SpokeUri
	}
	return ""
}

func (x *AcceptSpokeUpdateRequest) GetSpokeEtag() string {
	if x != nil {
		return x.SpokeEtag
	}
	return ""
}

func (x *AcceptSpokeUpdateRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The response for
// [HubService.AcceptSpokeUpdate][google.cloud.networkconnectivity.v1.HubService.AcceptSpokeUpdate].
type AcceptSpokeUpdateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The spoke that was operated on.
	Spoke *Spoke `protobuf:"bytes,1,opt,name=spoke,proto3" json:"spoke,omitempty"`
}

func (x *AcceptSpokeUpdateResponse) Reset() {
	*x = AcceptSpokeUpdateResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcceptSpokeUpdateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceptSpokeUpdateResponse) ProtoMessage() {}

func (x *AcceptSpokeUpdateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceptSpokeUpdateResponse.ProtoReflect.Descriptor instead.
func (*AcceptSpokeUpdateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{30}
}

func (x *AcceptSpokeUpdateResponse) GetSpoke() *Spoke {
	if x != nil {
		return x.Spoke
	}
	return nil
}

// The request for
// [HubService.RejectSpokeUpdate][google.cloud.networkconnectivity.v1.HubService.RejectSpokeUpdate].
type RejectSpokeUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub to reject spoke update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The URI of the spoke to reject update.
	SpokeUri string `protobuf:"bytes,2,opt,name=spoke_uri,json=spokeUri,proto3" json:"spoke_uri,omitempty"`
	// Required. The etag of the spoke to reject update.
	SpokeEtag string `protobuf:"bytes,3,opt,name=spoke_etag,json=spokeEtag,proto3" json:"spoke_etag,omitempty"`
	// Optional. Additional information provided by the hub administrator.
	Details string `protobuf:"bytes,4,opt,name=details,proto3" json:"details,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *RejectSpokeUpdateRequest) Reset() {
	*x = RejectSpokeUpdateRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RejectSpokeUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectSpokeUpdateRequest) ProtoMessage() {}

func (x *RejectSpokeUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectSpokeUpdateRequest.ProtoReflect.Descriptor instead.
func (*RejectSpokeUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{31}
}

func (x *RejectSpokeUpdateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RejectSpokeUpdateRequest) GetSpokeUri() string {
	if x != nil {
		return x.SpokeUri
	}
	return ""
}

func (x *RejectSpokeUpdateRequest) GetSpokeEtag() string {
	if x != nil {
		return x.SpokeEtag
	}
	return ""
}

func (x *RejectSpokeUpdateRequest) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

func (x *RejectSpokeUpdateRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The response for
// [HubService.RejectSpokeUpdate][google.cloud.networkconnectivity.v1.HubService.RejectSpokeUpdate].
type RejectSpokeUpdateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The spoke that was operated on.
	Spoke *Spoke `protobuf:"bytes,1,opt,name=spoke,proto3" json:"spoke,omitempty"`
}

func (x *RejectSpokeUpdateResponse) Reset() {
	*x = RejectSpokeUpdateResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RejectSpokeUpdateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectSpokeUpdateResponse) ProtoMessage() {}

func (x *RejectSpokeUpdateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectSpokeUpdateResponse.ProtoReflect.Descriptor instead.
func (*RejectSpokeUpdateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{32}
}

func (x *RejectSpokeUpdateResponse) GetSpoke() *Spoke {
	if x != nil {
		return x.Spoke
	}
	return nil
}

// The request for
// [HubService.GetRouteTable][google.cloud.networkconnectivity.v1.HubService.GetRouteTable].
type GetRouteTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the route table resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRouteTableRequest) Reset() {
	*x = GetRouteTableRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRouteTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRouteTableRequest) ProtoMessage() {}

func (x *GetRouteTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRouteTableRequest.ProtoReflect.Descriptor instead.
func (*GetRouteTableRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{33}
}

func (x *GetRouteTableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [HubService.GetRoute][google.cloud.networkconnectivity.v1.HubService.GetRoute].
type GetRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the route resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRouteRequest) Reset() {
	*x = GetRouteRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRouteRequest) ProtoMessage() {}

func (x *GetRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRouteRequest.ProtoReflect.Descriptor instead.
func (*GetRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{34}
}

func (x *GetRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for
// [HubService.ListRoutes][google.cloud.networkconnectivity.v1.HubService.ListRoutes]
// method.
type ListRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRoutesRequest) Reset() {
	*x = ListRoutesRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRoutesRequest) ProtoMessage() {}

func (x *ListRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRoutesRequest.ProtoReflect.Descriptor instead.
func (*ListRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{35}
}

func (x *ListRoutesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRoutesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRoutesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRoutesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRoutesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for
// [HubService.ListRoutes][google.cloud.networkconnectivity.v1.HubService.ListRoutes]
// method.
type ListRoutesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested routes.
	Routes []*Route `protobuf:"bytes,1,rep,name=routes,proto3" json:"routes,omitempty"`
	// The token for the next page of the response. To see more results,
	// use this value as the page_token for your next request. If this value
	// is empty, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// RouteTables that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRoutesResponse) Reset() {
	*x = ListRoutesResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRoutesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRoutesResponse) ProtoMessage() {}

func (x *ListRoutesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRoutesResponse.ProtoReflect.Descriptor instead.
func (*ListRoutesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{36}
}

func (x *ListRoutesResponse) GetRoutes() []*Route {
	if x != nil {
		return x.Routes
	}
	return nil
}

func (x *ListRoutesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRoutesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for
// [HubService.ListRouteTables][google.cloud.networkconnectivity.v1.HubService.ListRouteTables]
// method.
type ListRouteTablesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRouteTablesRequest) Reset() {
	*x = ListRouteTablesRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRouteTablesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRouteTablesRequest) ProtoMessage() {}

func (x *ListRouteTablesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRouteTablesRequest.ProtoReflect.Descriptor instead.
func (*ListRouteTablesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{37}
}

func (x *ListRouteTablesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRouteTablesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRouteTablesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRouteTablesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRouteTablesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for
// [HubService.ListRouteTables][google.cloud.networkconnectivity.v1.HubService.ListRouteTables]
// method.
type ListRouteTablesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested route tables.
	RouteTables []*RouteTable `protobuf:"bytes,1,rep,name=route_tables,json=routeTables,proto3" json:"route_tables,omitempty"`
	// The token for the next page of the response. To see more results,
	// use this value as the page_token for your next request. If this value
	// is empty, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Hubs that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRouteTablesResponse) Reset() {
	*x = ListRouteTablesResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRouteTablesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRouteTablesResponse) ProtoMessage() {}

func (x *ListRouteTablesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRouteTablesResponse.ProtoReflect.Descriptor instead.
func (*ListRouteTablesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{38}
}

func (x *ListRouteTablesResponse) GetRouteTables() []*RouteTable {
	if x != nil {
		return x.RouteTables
	}
	return nil
}

func (x *ListRouteTablesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRouteTablesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for
// [HubService.ListGroups][google.cloud.networkconnectivity.v1.HubService.ListGroups]
// method.
type ListGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListGroupsRequest) Reset() {
	*x = ListGroupsRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupsRequest) ProtoMessage() {}

func (x *ListGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{39}
}

func (x *ListGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGroupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListGroupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for
// [HubService.ListGroups][google.cloud.networkconnectivity.v1.HubService.ListGroups]
// method.
type ListGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested groups.
	Groups []*Group `protobuf:"bytes,1,rep,name=groups,proto3" json:"groups,omitempty"`
	// The token for the next page of the response. To see more results,
	// use this value as the page_token for your next request. If this value
	// is empty, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Hubs that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListGroupsResponse) Reset() {
	*x = ListGroupsResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupsResponse) ProtoMessage() {}

func (x *ListGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{40}
}

func (x *ListGroupsResponse) GetGroups() []*Group {
	if x != nil {
		return x.Groups
	}
	return nil
}

func (x *ListGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGroupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A collection of Cloud VPN tunnel resources. These resources should be
// redundant HA VPN tunnels that all advertise the same prefixes to Google
// Cloud. Alternatively, in a passive/active configuration, all tunnels
// should be capable of advertising the same prefixes.
type LinkedVpnTunnels struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URIs of linked VPN tunnel resources.
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
	// A value that controls whether site-to-site data transfer is enabled for
	// these resources. Data transfer is available only in [supported
	// locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
	SiteToSiteDataTransfer bool `protobuf:"varint,2,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
	// Output only. The VPC network where these VPN tunnels are located.
	VpcNetwork string `protobuf:"bytes,3,opt,name=vpc_network,json=vpcNetwork,proto3" json:"vpc_network,omitempty"`
	// Optional. IP ranges allowed to be included during import from hub (does not
	// control transit connectivity). The only allowed value for now is
	// "ALL_IPV4_RANGES".
	IncludeImportRanges []string `protobuf:"bytes,5,rep,name=include_import_ranges,json=includeImportRanges,proto3" json:"include_import_ranges,omitempty"`
}

func (x *LinkedVpnTunnels) Reset() {
	*x = LinkedVpnTunnels{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinkedVpnTunnels) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkedVpnTunnels) ProtoMessage() {}

func (x *LinkedVpnTunnels) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkedVpnTunnels.ProtoReflect.Descriptor instead.
func (*LinkedVpnTunnels) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{41}
}

func (x *LinkedVpnTunnels) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *LinkedVpnTunnels) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

func (x *LinkedVpnTunnels) GetVpcNetwork() string {
	if x != nil {
		return x.VpcNetwork
	}
	return ""
}

func (x *LinkedVpnTunnels) GetIncludeImportRanges() []string {
	if x != nil {
		return x.IncludeImportRanges
	}
	return nil
}

// A collection of VLAN attachment resources. These resources should
// be redundant attachments that all advertise the same prefixes to Google
// Cloud. Alternatively, in active/passive configurations, all attachments
// should be capable of advertising the same prefixes.
type LinkedInterconnectAttachments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URIs of linked interconnect attachment resources
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
	// A value that controls whether site-to-site data transfer is enabled for
	// these resources. Data transfer is available only in [supported
	// locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
	SiteToSiteDataTransfer bool `protobuf:"varint,2,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
	// Output only. The VPC network where these VLAN attachments are located.
	VpcNetwork string `protobuf:"bytes,3,opt,name=vpc_network,json=vpcNetwork,proto3" json:"vpc_network,omitempty"`
	// Optional. IP ranges allowed to be included during import from hub (does not
	// control transit connectivity). The only allowed value for now is
	// "ALL_IPV4_RANGES".
	IncludeImportRanges []string `protobuf:"bytes,5,rep,name=include_import_ranges,json=includeImportRanges,proto3" json:"include_import_ranges,omitempty"`
}

func (x *LinkedInterconnectAttachments) Reset() {
	*x = LinkedInterconnectAttachments{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinkedInterconnectAttachments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkedInterconnectAttachments) ProtoMessage() {}

func (x *LinkedInterconnectAttachments) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkedInterconnectAttachments.ProtoReflect.Descriptor instead.
func (*LinkedInterconnectAttachments) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{42}
}

func (x *LinkedInterconnectAttachments) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *LinkedInterconnectAttachments) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

func (x *LinkedInterconnectAttachments) GetVpcNetwork() string {
	if x != nil {
		return x.VpcNetwork
	}
	return ""
}

func (x *LinkedInterconnectAttachments) GetIncludeImportRanges() []string {
	if x != nil {
		return x.IncludeImportRanges
	}
	return nil
}

// A collection of router appliance instances. If you configure multiple router
// appliance instances to receive data from the same set of sites outside of
// Google Cloud, we recommend that you associate those instances with the same
// spoke.
type LinkedRouterApplianceInstances struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of router appliance instances.
	Instances []*RouterApplianceInstance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// A value that controls whether site-to-site data transfer is enabled for
	// these resources. Data transfer is available only in [supported
	// locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
	SiteToSiteDataTransfer bool `protobuf:"varint,2,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
	// Output only. The VPC network where these router appliance instances are
	// located.
	VpcNetwork string `protobuf:"bytes,3,opt,name=vpc_network,json=vpcNetwork,proto3" json:"vpc_network,omitempty"`
	// Optional. IP ranges allowed to be included during import from hub (does not
	// control transit connectivity). The only allowed value for now is
	// "ALL_IPV4_RANGES".
	IncludeImportRanges []string `protobuf:"bytes,5,rep,name=include_import_ranges,json=includeImportRanges,proto3" json:"include_import_ranges,omitempty"`
}

func (x *LinkedRouterApplianceInstances) Reset() {
	*x = LinkedRouterApplianceInstances{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinkedRouterApplianceInstances) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkedRouterApplianceInstances) ProtoMessage() {}

func (x *LinkedRouterApplianceInstances) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkedRouterApplianceInstances.ProtoReflect.Descriptor instead.
func (*LinkedRouterApplianceInstances) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{43}
}

func (x *LinkedRouterApplianceInstances) GetInstances() []*RouterApplianceInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *LinkedRouterApplianceInstances) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

func (x *LinkedRouterApplianceInstances) GetVpcNetwork() string {
	if x != nil {
		return x.VpcNetwork
	}
	return ""
}

func (x *LinkedRouterApplianceInstances) GetIncludeImportRanges() []string {
	if x != nil {
		return x.IncludeImportRanges
	}
	return nil
}

// An existing VPC network.
type LinkedVpcNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI of the VPC network resource.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. IP ranges encompassing the subnets to be excluded from peering.
	ExcludeExportRanges []string `protobuf:"bytes,2,rep,name=exclude_export_ranges,json=excludeExportRanges,proto3" json:"exclude_export_ranges,omitempty"`
	// Optional. IP ranges allowed to be included from peering.
	IncludeExportRanges []string `protobuf:"bytes,3,rep,name=include_export_ranges,json=includeExportRanges,proto3" json:"include_export_ranges,omitempty"`
	// Optional. The proposed include export IP ranges waiting for hub
	// administration's approval.
	ProposedIncludeExportRanges []string `protobuf:"bytes,5,rep,name=proposed_include_export_ranges,json=proposedIncludeExportRanges,proto3" json:"proposed_include_export_ranges,omitempty"`
	// Output only. The proposed exclude export IP ranges waiting for hub
	// administration's approval.
	ProposedExcludeExportRanges []string `protobuf:"bytes,6,rep,name=proposed_exclude_export_ranges,json=proposedExcludeExportRanges,proto3" json:"proposed_exclude_export_ranges,omitempty"`
	// Output only. The list of Producer VPC spokes that this VPC spoke is a
	// service consumer VPC spoke for. These producer VPCs are connected through
	// VPC peering to this spoke's backing VPC network. Because they are directly
	// connected throuh VPC peering, NCC export filters do not apply between the
	// service consumer VPC spoke and any of its producer VPC spokes. This VPC
	// spoke cannot be deleted as long as any of these producer VPC spokes are
	// connected to the NCC Hub.
	ProducerVpcSpokes []string `protobuf:"bytes,4,rep,name=producer_vpc_spokes,json=producerVpcSpokes,proto3" json:"producer_vpc_spokes,omitempty"`
}

func (x *LinkedVpcNetwork) Reset() {
	*x = LinkedVpcNetwork{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinkedVpcNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkedVpcNetwork) ProtoMessage() {}

func (x *LinkedVpcNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkedVpcNetwork.ProtoReflect.Descriptor instead.
func (*LinkedVpcNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{44}
}

func (x *LinkedVpcNetwork) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *LinkedVpcNetwork) GetExcludeExportRanges() []string {
	if x != nil {
		return x.ExcludeExportRanges
	}
	return nil
}

func (x *LinkedVpcNetwork) GetIncludeExportRanges() []string {
	if x != nil {
		return x.IncludeExportRanges
	}
	return nil
}

func (x *LinkedVpcNetwork) GetProposedIncludeExportRanges() []string {
	if x != nil {
		return x.ProposedIncludeExportRanges
	}
	return nil
}

func (x *LinkedVpcNetwork) GetProposedExcludeExportRanges() []string {
	if x != nil {
		return x.ProposedExcludeExportRanges
	}
	return nil
}

func (x *LinkedVpcNetwork) GetProducerVpcSpokes() []string {
	if x != nil {
		return x.ProducerVpcSpokes
	}
	return nil
}

type LinkedProducerVpcNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The URI of the Service Consumer VPC that the Producer VPC is
	// peered with.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The Service Consumer Network spoke.
	ServiceConsumerVpcSpoke string `protobuf:"bytes,6,opt,name=service_consumer_vpc_spoke,json=serviceConsumerVpcSpoke,proto3" json:"service_consumer_vpc_spoke,omitempty"`
	// Immutable. The name of the VPC peering between the Service Consumer VPC and
	// the Producer VPC (defined in the Tenant project) which is added to the NCC
	// hub. This peering must be in ACTIVE state.
	Peering string `protobuf:"bytes,2,opt,name=peering,proto3" json:"peering,omitempty"`
	// Output only. The URI of the Producer VPC.
	ProducerNetwork string `protobuf:"bytes,5,opt,name=producer_network,json=producerNetwork,proto3" json:"producer_network,omitempty"`
	// Optional. IP ranges encompassing the subnets to be excluded from peering.
	ExcludeExportRanges []string `protobuf:"bytes,3,rep,name=exclude_export_ranges,json=excludeExportRanges,proto3" json:"exclude_export_ranges,omitempty"`
	// Optional. IP ranges allowed to be included from peering.
	IncludeExportRanges []string `protobuf:"bytes,4,rep,name=include_export_ranges,json=includeExportRanges,proto3" json:"include_export_ranges,omitempty"`
	// Optional. The proposed include export IP ranges waiting for hub
	// administration's approval.
	ProposedIncludeExportRanges []string `protobuf:"bytes,7,rep,name=proposed_include_export_ranges,json=proposedIncludeExportRanges,proto3" json:"proposed_include_export_ranges,omitempty"`
	// Output only. The proposed exclude export IP ranges waiting for hub
	// administration's approval.
	ProposedExcludeExportRanges []string `protobuf:"bytes,8,rep,name=proposed_exclude_export_ranges,json=proposedExcludeExportRanges,proto3" json:"proposed_exclude_export_ranges,omitempty"`
}

func (x *LinkedProducerVpcNetwork) Reset() {
	*x = LinkedProducerVpcNetwork{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinkedProducerVpcNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkedProducerVpcNetwork) ProtoMessage() {}

func (x *LinkedProducerVpcNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkedProducerVpcNetwork.ProtoReflect.Descriptor instead.
func (*LinkedProducerVpcNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{45}
}

func (x *LinkedProducerVpcNetwork) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *LinkedProducerVpcNetwork) GetServiceConsumerVpcSpoke() string {
	if x != nil {
		return x.ServiceConsumerVpcSpoke
	}
	return ""
}

func (x *LinkedProducerVpcNetwork) GetPeering() string {
	if x != nil {
		return x.Peering
	}
	return ""
}

func (x *LinkedProducerVpcNetwork) GetProducerNetwork() string {
	if x != nil {
		return x.ProducerNetwork
	}
	return ""
}

func (x *LinkedProducerVpcNetwork) GetExcludeExportRanges() []string {
	if x != nil {
		return x.ExcludeExportRanges
	}
	return nil
}

func (x *LinkedProducerVpcNetwork) GetIncludeExportRanges() []string {
	if x != nil {
		return x.IncludeExportRanges
	}
	return nil
}

func (x *LinkedProducerVpcNetwork) GetProposedIncludeExportRanges() []string {
	if x != nil {
		return x.ProposedIncludeExportRanges
	}
	return nil
}

func (x *LinkedProducerVpcNetwork) GetProposedExcludeExportRanges() []string {
	if x != nil {
		return x.ProposedExcludeExportRanges
	}
	return nil
}

// A router appliance instance is a Compute Engine virtual machine (VM) instance
// that acts as a BGP speaker. A router appliance instance is specified by the
// URI of the VM and the internal IP address of one of the VM's network
// interfaces.
type RouterApplianceInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the VM.
	VirtualMachine string `protobuf:"bytes,1,opt,name=virtual_machine,json=virtualMachine,proto3" json:"virtual_machine,omitempty"`
	// The IP address on the VM to use for peering.
	IpAddress string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
}

func (x *RouterApplianceInstance) Reset() {
	*x = RouterApplianceInstance{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouterApplianceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouterApplianceInstance) ProtoMessage() {}

func (x *RouterApplianceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouterApplianceInstance.ProtoReflect.Descriptor instead.
func (*RouterApplianceInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{46}
}

func (x *RouterApplianceInstance) GetVirtualMachine() string {
	if x != nil {
		return x.VirtualMachine
	}
	return ""
}

func (x *RouterApplianceInstance) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

// Metadata about locations
type LocationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of supported features
	LocationFeatures []LocationFeature `protobuf:"varint,1,rep,packed,name=location_features,json=locationFeatures,proto3,enum=google.cloud.networkconnectivity.v1.LocationFeature" json:"location_features,omitempty"`
}

func (x *LocationMetadata) Reset() {
	*x = LocationMetadata{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationMetadata) ProtoMessage() {}

func (x *LocationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationMetadata.ProtoReflect.Descriptor instead.
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{47}
}

func (x *LocationMetadata) GetLocationFeatures() []LocationFeature {
	if x != nil {
		return x.LocationFeatures
	}
	return nil
}

type NextHopVpcNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the VPC network resource
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *NextHopVpcNetwork) Reset() {
	*x = NextHopVpcNetwork{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NextHopVpcNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextHopVpcNetwork) ProtoMessage() {}

func (x *NextHopVpcNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextHopVpcNetwork.ProtoReflect.Descriptor instead.
func (*NextHopVpcNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{48}
}

func (x *NextHopVpcNetwork) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// A route next hop that leads to a VPN tunnel resource.
type NextHopVPNTunnel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the VPN tunnel resource.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The VPC network where this VPN tunnel is located.
	VpcNetwork string `protobuf:"bytes,2,opt,name=vpc_network,json=vpcNetwork,proto3" json:"vpc_network,omitempty"`
	// Indicates whether site-to-site data transfer is allowed for this VPN tunnel
	// resource. Data transfer is available only in [supported
	// locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
	SiteToSiteDataTransfer bool `protobuf:"varint,3,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
}

func (x *NextHopVPNTunnel) Reset() {
	*x = NextHopVPNTunnel{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NextHopVPNTunnel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextHopVPNTunnel) ProtoMessage() {}

func (x *NextHopVPNTunnel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextHopVPNTunnel.ProtoReflect.Descriptor instead.
func (*NextHopVPNTunnel) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{49}
}

func (x *NextHopVPNTunnel) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *NextHopVPNTunnel) GetVpcNetwork() string {
	if x != nil {
		return x.VpcNetwork
	}
	return ""
}

func (x *NextHopVPNTunnel) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

// A route next hop that leads to a Router appliance instance.
type NextHopRouterApplianceInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the Router appliance instance.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The VPC network where this VM is located.
	VpcNetwork string `protobuf:"bytes,2,opt,name=vpc_network,json=vpcNetwork,proto3" json:"vpc_network,omitempty"`
	// Indicates whether site-to-site data transfer is allowed for this Router
	// appliance instance resource. Data transfer is available only in [supported
	// locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
	SiteToSiteDataTransfer bool `protobuf:"varint,3,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
}

func (x *NextHopRouterApplianceInstance) Reset() {
	*x = NextHopRouterApplianceInstance{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NextHopRouterApplianceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextHopRouterApplianceInstance) ProtoMessage() {}

func (x *NextHopRouterApplianceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextHopRouterApplianceInstance.ProtoReflect.Descriptor instead.
func (*NextHopRouterApplianceInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{50}
}

func (x *NextHopRouterApplianceInstance) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *NextHopRouterApplianceInstance) GetVpcNetwork() string {
	if x != nil {
		return x.VpcNetwork
	}
	return ""
}

func (x *NextHopRouterApplianceInstance) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

// A route next hop that leads to an interconnect attachment resource.
type NextHopInterconnectAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the interconnect attachment resource.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The VPC network where this interconnect attachment is located.
	VpcNetwork string `protobuf:"bytes,2,opt,name=vpc_network,json=vpcNetwork,proto3" json:"vpc_network,omitempty"`
	// Indicates whether site-to-site data transfer is allowed for this
	// interconnect attachment resource. Data transfer is available only in
	// [supported
	// locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
	SiteToSiteDataTransfer bool `protobuf:"varint,3,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
}

func (x *NextHopInterconnectAttachment) Reset() {
	*x = NextHopInterconnectAttachment{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NextHopInterconnectAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextHopInterconnectAttachment) ProtoMessage() {}

func (x *NextHopInterconnectAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextHopInterconnectAttachment.ProtoReflect.Descriptor instead.
func (*NextHopInterconnectAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{51}
}

func (x *NextHopInterconnectAttachment) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *NextHopInterconnectAttachment) GetVpcNetwork() string {
	if x != nil {
		return x.VpcNetwork
	}
	return ""
}

func (x *NextHopInterconnectAttachment) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

// Summarizes information about the spokes associated with a hub.
// The summary includes a count of spokes according to type
// and according to state. If any spokes are inactive,
// the summary also lists the reasons they are inactive,
// including a count for each reason.
type SpokeSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Counts the number of spokes of each type that are
	// associated with a specific hub.
	SpokeTypeCounts []*SpokeSummary_SpokeTypeCount `protobuf:"bytes,1,rep,name=spoke_type_counts,json=spokeTypeCounts,proto3" json:"spoke_type_counts,omitempty"`
	// Output only. Counts the number of spokes that are in each state
	// and associated with a given hub.
	SpokeStateCounts []*SpokeSummary_SpokeStateCount `protobuf:"bytes,2,rep,name=spoke_state_counts,json=spokeStateCounts,proto3" json:"spoke_state_counts,omitempty"`
	// Output only. Counts the number of spokes that are inactive for each
	// possible reason and associated with a given hub.
	SpokeStateReasonCounts []*SpokeSummary_SpokeStateReasonCount `protobuf:"bytes,3,rep,name=spoke_state_reason_counts,json=spokeStateReasonCounts,proto3" json:"spoke_state_reason_counts,omitempty"`
}

func (x *SpokeSummary) Reset() {
	*x = SpokeSummary{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpokeSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpokeSummary) ProtoMessage() {}

func (x *SpokeSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpokeSummary.ProtoReflect.Descriptor instead.
func (*SpokeSummary) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{52}
}

func (x *SpokeSummary) GetSpokeTypeCounts() []*SpokeSummary_SpokeTypeCount {
	if x != nil {
		return x.SpokeTypeCounts
	}
	return nil
}

func (x *SpokeSummary) GetSpokeStateCounts() []*SpokeSummary_SpokeStateCount {
	if x != nil {
		return x.SpokeStateCounts
	}
	return nil
}

func (x *SpokeSummary) GetSpokeStateReasonCounts() []*SpokeSummary_SpokeStateReasonCount {
	if x != nil {
		return x.SpokeStateReasonCounts
	}
	return nil
}

// The request for
// [HubService.GetGroup][google.cloud.networkconnectivity.v1.HubService.GetGroup].
type GetGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the route table resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGroupRequest) Reset() {
	*x = GetGroupRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupRequest) ProtoMessage() {}

func (x *GetGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupRequest.ProtoReflect.Descriptor instead.
func (*GetGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{53}
}

func (x *GetGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for
// [HubService.UpdateGroup][google.cloud.networkconnectivity.v1.HubService.UpdateGroup]
// method.
type UpdateGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. In the case of an update to an existing group, field mask is used
	// to specify the fields to be overwritten. The fields specified in the
	// update_mask are relative to the resource, not the full request. A field is
	// overwritten if it is in the mask. If the user does not provide a mask, then
	// all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The state that the group should be in after the update.
	Group *Group `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server knows to ignore the request
	// if it has already been completed. The server guarantees that a request
	// doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateGroupRequest) Reset() {
	*x = UpdateGroupRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGroupRequest) ProtoMessage() {}

func (x *UpdateGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{54}
}

func (x *UpdateGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateGroupRequest) GetGroup() *Group {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *UpdateGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The reason a spoke is inactive.
type Spoke_StateReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The code associated with this reason.
	Code Spoke_StateReason_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.networkconnectivity.v1.Spoke_StateReason_Code" json:"code,omitempty"`
	// Human-readable details about this reason.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Additional information provided by the user in the RejectSpoke call.
	UserDetails string `protobuf:"bytes,3,opt,name=user_details,json=userDetails,proto3" json:"user_details,omitempty"`
}

func (x *Spoke_StateReason) Reset() {
	*x = Spoke_StateReason{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Spoke_StateReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Spoke_StateReason) ProtoMessage() {}

func (x *Spoke_StateReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Spoke_StateReason.ProtoReflect.Descriptor instead.
func (*Spoke_StateReason) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Spoke_StateReason) GetCode() Spoke_StateReason_Code {
	if x != nil {
		return x.Code
	}
	return Spoke_StateReason_CODE_UNSPECIFIED
}

func (x *Spoke_StateReason) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Spoke_StateReason) GetUserDetails() string {
	if x != nil {
		return x.UserDetails
	}
	return ""
}

// The number of spokes of a given type that are associated
// with a specific hub. The type indicates what kind of
// resource is associated with the spoke.
type SpokeSummary_SpokeTypeCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The type of the spokes.
	SpokeType SpokeType `protobuf:"varint,1,opt,name=spoke_type,json=spokeType,proto3,enum=google.cloud.networkconnectivity.v1.SpokeType" json:"spoke_type,omitempty"`
	// Output only. The total number of spokes of this type that are
	// associated with the hub.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *SpokeSummary_SpokeTypeCount) Reset() {
	*x = SpokeSummary_SpokeTypeCount{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpokeSummary_SpokeTypeCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpokeSummary_SpokeTypeCount) ProtoMessage() {}

func (x *SpokeSummary_SpokeTypeCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpokeSummary_SpokeTypeCount.ProtoReflect.Descriptor instead.
func (*SpokeSummary_SpokeTypeCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{52, 0}
}

func (x *SpokeSummary_SpokeTypeCount) GetSpokeType() SpokeType {
	if x != nil {
		return x.SpokeType
	}
	return SpokeType_SPOKE_TYPE_UNSPECIFIED
}

func (x *SpokeSummary_SpokeTypeCount) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// The number of spokes that are in a particular state
// and associated with a given hub.
type SpokeSummary_SpokeStateCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The state of the spokes.
	State State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.State" json:"state,omitempty"`
	// Output only. The total number of spokes that are in this state
	// and associated with a given hub.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *SpokeSummary_SpokeStateCount) Reset() {
	*x = SpokeSummary_SpokeStateCount{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpokeSummary_SpokeStateCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpokeSummary_SpokeStateCount) ProtoMessage() {}

func (x *SpokeSummary_SpokeStateCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpokeSummary_SpokeStateCount.ProtoReflect.Descriptor instead.
func (*SpokeSummary_SpokeStateCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{52, 1}
}

func (x *SpokeSummary_SpokeStateCount) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *SpokeSummary_SpokeStateCount) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// The number of spokes in the hub that are inactive for this reason.
type SpokeSummary_SpokeStateReasonCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The reason that a spoke is inactive.
	StateReasonCode Spoke_StateReason_Code `protobuf:"varint,1,opt,name=state_reason_code,json=stateReasonCode,proto3,enum=google.cloud.networkconnectivity.v1.Spoke_StateReason_Code" json:"state_reason_code,omitempty"`
	// Output only. The total number of spokes that are inactive for a
	// particular reason and associated with a given hub.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *SpokeSummary_SpokeStateReasonCount) Reset() {
	*x = SpokeSummary_SpokeStateReasonCount{}
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpokeSummary_SpokeStateReasonCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpokeSummary_SpokeStateReasonCount) ProtoMessage() {}

func (x *SpokeSummary_SpokeStateReasonCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpokeSummary_SpokeStateReasonCount.ProtoReflect.Descriptor instead.
func (*SpokeSummary_SpokeStateReasonCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{52, 2}
}

func (x *SpokeSummary_SpokeStateReasonCount) GetStateReasonCode() Spoke_StateReason_Code {
	if x != nil {
		return x.StateReasonCode
	}
	return Spoke_StateReason_CODE_UNSPECIFIED
}

func (x *SpokeSummary_SpokeStateReasonCount) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

var File_google_cloud_networkconnectivity_v1_hub_proto protoreflect.FileDescriptor

var file_google_cloud_networkconnectivity_v1_hub_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x68, 0x75, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x07, 0x0a, 0x03,
	0x48, 0x75, 0x62, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x52,
	0x0a, 0x0c, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x70, 0x63, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x50, 0x43, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x70,
	0x63, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x0d, 0x73, 0x70,
	0x6f, 0x6b, 0x65, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x70, 0x6f, 0x6b, 0x65,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x55, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x61,
	0x0a, 0x0f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67,
	0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x65, 0x73, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67,
	0x79, 0x12, 0x27, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x73, 0x63, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x50, 0x73, 0x63, 0x88, 0x01, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x5b, 0xea, 0x41, 0x58, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48,
	0x75, 0x62, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x7b, 0x68, 0x75,
	0x62, 0x7d, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x73,
	0x63, 0x22, 0xb0, 0x01, 0x0a, 0x0a, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x50, 0x43,
	0x12, 0x35, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa,
	0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x6b, 0x0a, 0x32, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x2a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x64, 0x46, 0x6f, 0x72, 0x4e, 0x65, 0x77, 0x53, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x53, 0x69,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x73, 0x22, 0xf0, 0x0e, 0x0a, 0x05, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x03, 0x68, 0x75, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52,
	0x03, 0x68, 0x75, 0x62, 0x12, 0x46, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x17, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x68, 0x0a, 0x12,
	0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x76, 0x70, 0x6e, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x70, 0x6e, 0x54,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x8f, 0x01, 0x0a, 0x1f, 0x6c, 0x69, 0x6e, 0x6b, 0x65,
	0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x6c, 0x69, 0x6e, 0x6b, 0x65,
	0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x93, 0x01, 0x0a, 0x21, 0x6c, 0x69, 0x6e,
	0x6b, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x65,
	0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1e,
	0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x68,
	0x0a, 0x12, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x70,
	0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x81, 0x01, 0x0a, 0x1b, 0x6c, 0x69, 0x6e,
	0x6b, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x76, 0x70, 0x63,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x18, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x65, 0x72, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x20, 0x0a, 0x09,
	0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x12, 0x45,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x55, 0x0a, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73,
	0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f,
	0x6b, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12, 0x52, 0x0a, 0x0a,
	0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x40, 0x0a, 0x1a, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x5f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x1c, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x17, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x73, 0x50, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x1a, 0xb7, 0x02, 0x0a, 0x0b,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x04, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x6f, 0x6b, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x73,
	0x65, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x99, 0x01, 0x0a, 0x04, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41,
	0x55, 0x53, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x10, 0x05, 0x12, 0x13, 0x0a,
	0x0f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x07, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x65, 0xea, 0x41, 0x62, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12,
	0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x2f,
	0x7b, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x7d, 0x22, 0xb7, 0x04, 0x0a, 0x0a, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x3a, 0x7c, 0xea, 0x41, 0x79, 0x0a, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x48, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62,
	0x73, 0x2f, 0x7b, 0x68, 0x75, 0x62, 0x7d, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x7d, 0x22, 0xb6, 0x0a, 0x0a, 0x05, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x69, 0x70, 0x5f, 0x63,
	0x69, 0x64, 0x72, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x69, 0x70, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x47, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x6c, 0x0a, 0x14, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f,
	0x70, 0x5f, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f,
	0x70, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x11, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x45, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x70, 0x6f, 0x6b, 0x65, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x69, 0x0a,
	0x13, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x76, 0x70, 0x6e, 0x5f, 0x74, 0x75,
	0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x56, 0x50, 0x4e, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x10, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x56,
	0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x94, 0x01, 0x0a, 0x22, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x78, 0x74,
	0x48, 0x6f, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x1e, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x90, 0x01, 0x0a, 0x20, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x1d, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65,
	0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x8a, 0x01,
	0xea, 0x41, 0x86, 0x01, 0x0a, 0x2b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x12, 0x57, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x7b, 0x68, 0x75, 0x62,
	0x7d, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x7d, 0x2f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x7d, 0x22, 0xa4, 0x05, 0x0a, 0x05, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x75, 0x69, 0x64, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x55, 0x0a, 0x0b, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x41, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x41, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x7b, 0x68, 0x75,
	0x62, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x7d, 0x22, 0x43, 0x0a, 0x0a, 0x41, 0x75, 0x74, 0x6f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x12,
	0x35, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x22, 0xc3, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x48,
	0x75, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9a, 0x01, 0x0a,
	0x10, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3c, 0x0a, 0x04, 0x68, 0x75, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x62, 0x52, 0x04, 0x68, 0x75, 0x62, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x53, 0x0a, 0x0d, 0x47, 0x65, 0x74,
	0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd6,
	0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x06, 0x68, 0x75, 0x62, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x68, 0x75, 0x62,
	0x49, 0x64, 0x12, 0x3f, 0x0a, 0x03, 0x68, 0x75, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03,
	0x68, 0x75, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb9, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3f,
	0x0a, 0x03, 0x68, 0x75, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x75, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x68, 0x75, 0x62, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0x7a, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x75, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x8d, 0x03, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x12, 0x57, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62,
	0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x40, 0x0a,
	0x09, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x50,
	0x4f, 0x4b, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22,
	0xa5, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x73, 0x70, 0x6f,
	0x6b, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x06, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xfe, 0x01, 0x0a, 0x15, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x48, 0x75, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x79, 0x22, 0xa3, 0x01, 0x0a, 0x16, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x48, 0x75, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x12, 0x68, 0x75, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x68, 0x75, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb2,
	0x01, 0x0a, 0x0e, 0x48, 0x75, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x62, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x42, 0x79, 0x12, 0x6f, 0x0a, 0x16, 0x70, 0x73, 0x63, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x61, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x50, 0x72, 0x6f, 0x70,
	0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x14, 0x70,
	0x73, 0x63, 0x50, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0xab, 0x04, 0x0a, 0x14, 0x50, 0x73, 0x63, 0x50, 0x72, 0x6f, 0x70, 0x61,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x52,
	0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x50, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xe2, 0x01, 0x0a,
	0x04, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52,
	0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x50, 0x41, 0x47,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x37, 0x0a, 0x33, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x41, 0x47,
	0x41, 0x54, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x29, 0x0a, 0x25, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43,
	0x45, 0x52, 0x5f, 0x4e, 0x41, 0x54, 0x5f, 0x49, 0x50, 0x5f, 0x53, 0x50, 0x41, 0x43, 0x45, 0x5f,
	0x45, 0x58, 0x48, 0x41, 0x55, 0x53, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x21, 0x0a, 0x1d, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52, 0x5f, 0x51, 0x55,
	0x4f, 0x54, 0x41, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x05, 0x12, 0x21,
	0x0a, 0x1d, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52,
	0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10,
	0x06, 0x22, 0xc5, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x42, 0x0a, 0x06, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x06, 0x73, 0x70,
	0x6f, 0x6b, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x57,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x6f, 0x6b,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe2, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x49,
	0x64, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc1, 0x01, 0x0a,
	0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x7e, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xce, 0x01, 0x0a, 0x15, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4d,
	0x0a, 0x09, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x52, 0x08, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x5a, 0x0a, 0x16, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x73,
	0x70, 0x6f, 0x6b, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x22, 0xed, 0x01,
	0x0a, 0x15, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x09, 0x73,
	0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x6f, 0x6b, 0x65,
	0x52, 0x08, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1d,
	0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x5a, 0x0a,
	0x16, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f,
	0x6b, 0x65, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x18, 0x41, 0x63,
	0x63, 0x65, 0x70, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x09, 0x73, 0x70,
	0x6f, 0x6b, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52,
	0x08, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x70, 0x6f,
	0x6b, 0x65, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x45, 0x74, 0x61, 0x67, 0x12, 0x2a, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x5d, 0x0a, 0x19, 0x41, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b,
	0x65, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x22, 0x9c, 0x02, 0x0a, 0x18, 0x52, 0x65, 0x6a,
	0x65, 0x63, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x09, 0x73, 0x70, 0x6f,
	0x6b, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x08,
	0x73, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x70, 0x6f, 0x6b,
	0x65, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x45, 0x74, 0x61, 0x67, 0x12, 0x1d, 0x0a, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2a, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x5d, 0x0a, 0x19, 0x52, 0x65, 0x6a, 0x65, 0x63,
	0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52,
	0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x22, 0x61, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5a, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd1, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x42, 0x0a, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xcf,
	0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xb7, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0c,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xca, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42,
	0x0a, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x8b, 0x02, 0x0a,
	0x10, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c,
	0x73, 0x12, 0x39, 0x0a, 0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x6e,
	0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x12, 0x3a, 0x0a, 0x1a,
	0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x16, 0x73, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x53, 0x69, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x0b, 0x76, 0x70, 0x63, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0a, 0x76, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0xa5, 0x02, 0x0a, 0x1d, 0x4c,
	0x69, 0x6e, 0x6b, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x46, 0x0a, 0x04,
	0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x0a,
	0x2d, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04,
	0x75, 0x72, 0x69, 0x73, 0x12, 0x3a, 0x0a, 0x1a, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x5f,
	0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x73, 0x69, 0x74, 0x65, 0x54, 0x6f,
	0x53, 0x69, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x12, 0x47, 0x0a, 0x0b, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0a, 0x76,
	0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x22, 0xba, 0x02, 0x0a, 0x1e, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x3a, 0x0a, 0x1a, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x74,
	0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x73, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x53, 0x69, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x12, 0x47, 0x0a,
	0x0b, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0a, 0x76, 0x70, 0x63, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22,
	0xb4, 0x03, 0x0a, 0x10, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x38, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x37,
	0x0a, 0x15, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x13, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x48, 0x0a, 0x1e, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x70,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x1e, 0x70, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1b, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65,
	0x64, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x5f, 0x76, 0x70, 0x63, 0x5f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x56, 0x70, 0x63,
	0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x22, 0xc3, 0x04, 0x0a, 0x18, 0x4c, 0x69, 0x6e, 0x6b, 0x65,
	0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x6d, 0x0a, 0x1a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x76, 0x70, 0x63, 0x5f, 0x73, 0x70,
	0x6f, 0x6b, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x17, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x56, 0x70, 0x63, 0x53,
	0x70, 0x6f, 0x6b, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x12, 0x51, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x37, 0x0a, 0x15, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12,
	0x37, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x1e, 0x70, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x49,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x12, 0x48, 0x0a, 0x1e, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x1b, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0x87, 0x01, 0x0a,
	0x17, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x76, 0x69, 0x72, 0x74,
	0x75, 0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c,
	0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x75, 0x0a, 0x10, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x11, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x10, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0x4a, 0x0a,
	0x11, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x12, 0x35, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xcd, 0x01, 0x0a, 0x10, 0x4e, 0x65,
	0x78, 0x74, 0x48, 0x6f, 0x70, 0x56, 0x50, 0x4e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x37,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x44, 0x0a, 0x0b, 0x76, 0x70, 0x63, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x0a, 0x76, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3a, 0x0a,
	0x1a, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x16, 0x73, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x53, 0x69, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x22, 0xda, 0x01, 0x0a, 0x1e, 0x4e, 0x65,
	0x78, 0x74, 0x48, 0x6f, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x12, 0x44, 0x0a, 0x0b, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0a,
	0x76, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3a, 0x0a, 0x1a, 0x73, 0x69,
	0x74, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16,
	0x73, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x53, 0x69, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x22, 0xe7, 0x01, 0x0a, 0x1d, 0x4e, 0x65, 0x78, 0x74, 0x48,
	0x6f, 0x70, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x44,
	0x0a, 0x0b, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0a, 0x76, 0x70, 0x63, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3a, 0x0a, 0x1a, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x5f,
	0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x73, 0x69, 0x74, 0x65, 0x54, 0x6f,
	0x53, 0x69, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x22, 0x9a, 0x06, 0x0a, 0x0c, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x71, 0x0a, 0x11, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e,
	0x53, 0x70, 0x6f, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x12, 0x74, 0x0a, 0x12, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x87, 0x01, 0x0a, 0x19, 0x73,
	0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x73, 0x70,
	0x6f, 0x6b, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x1a, 0x7f, 0x0a, 0x0e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0a, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x73, 0x0a, 0x0f, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x19, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xa0, 0x01, 0x0a, 0x15, 0x53,
	0x70, 0x6f, 0x6b, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x57, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x45, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x2a, 0x66, 0x0a, 0x0f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x20, 0x0a,
	0x1c, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x18, 0x0a, 0x14, 0x53, 0x49, 0x54, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x53, 0x50, 0x4f, 0x4b, 0x45, 0x53, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x49, 0x54,
	0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x53, 0x49, 0x54, 0x45, 0x5f, 0x53, 0x50, 0x4f, 0x4b, 0x45, 0x53,
	0x10, 0x02, 0x2a, 0x6c, 0x0a, 0x09, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x56,
	0x50, 0x43, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45,
	0x54, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x56, 0x50, 0x43, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e,
	0x44, 0x41, 0x52, 0x59, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x10, 0x02, 0x12, 0x11, 0x0a,
	0x0d, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0x03,
	0x2a, 0x9a, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x43, 0x43,
	0x45, 0x50, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x4a, 0x45,
	0x43, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x10,
	0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x0b, 0x2a, 0x95, 0x01,
	0x0a, 0x09, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x53,
	0x50, 0x4f, 0x4b, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x50, 0x4e, 0x5f, 0x54,
	0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x54, 0x54, 0x41, 0x43, 0x48, 0x4d, 0x45,
	0x4e, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x52, 0x5f, 0x41,
	0x50, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x50,
	0x43, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x50,
	0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x10, 0x07, 0x2a, 0x35, 0x0a, 0x0a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x50, 0x52, 0x45, 0x53, 0x45, 0x54, 0x10, 0x01, 0x2a, 0x45, 0x0a, 0x0e,
	0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12, 0x1f,
	0x0a, 0x1b, 0x50, 0x52, 0x45, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x4f, 0x50, 0x4f, 0x4c, 0x4f, 0x47,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x08, 0x0a, 0x04, 0x4d, 0x45, 0x53, 0x48, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x41,
	0x52, 0x10, 0x03, 0x32, 0xf0, 0x26, 0x0a, 0x0a, 0x48, 0x75, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xb7, 0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x73, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x48, 0x75, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x7d, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x12, 0xa4, 0x01, 0x0a,
	0x06, 0x47, 0x65, 0x74, 0x48, 0x75, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x75, 0x62, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x75,
	0x62, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x75,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0xca, 0x41, 0x18, 0x0a, 0x03, 0x48, 0x75,
	0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x68, 0x75,
	0x62, 0x2c, 0x68, 0x75, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x3a, 0x03,
	0x68, 0x75, 0x62, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x7d, 0x2f, 0x68, 0x75,
	0x62, 0x73, 0x12, 0xce, 0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x75, 0x62,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x75, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca, 0x41, 0x18, 0x0a, 0x03, 0x48, 0x75, 0x62,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x0f, 0x68, 0x75, 0x62, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x03, 0x68, 0x75, 0x62,
	0x32, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x68, 0x75, 0x62, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x75,
	0x62, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x75,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xcf, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48,
	0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f,
	0x6b, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x73, 0x12, 0xd3, 0x01, 0x0a, 0x0e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x75,
	0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x48, 0x75, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48,
	0x75, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12,
	0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0xba, 0x01, 0x0a, 0x0a, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x6f, 0x6b,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x12, 0xa7, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x53,
	0x70, 0x6f, 0x6b, 0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xd5, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b,
	0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41, 0x1a, 0x0a, 0x05,
	0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x22, 0x2a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x12, 0xd7, 0x01, 0x0a, 0x0b, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x70, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x11, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x05, 0x73, 0x70, 0x6f, 0x6b,
	0x65, 0x32, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xf1, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x48, 0x75,
	0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6a,
	0x65, 0x63, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x83, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x16, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x48,
	0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x0e, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6a, 0x65,
	0x63, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0xf1, 0x01, 0x0a, 0x0e, 0x41, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x16, 0x41, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x48, 0x75, 0x62, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0e, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x70,
	0x6f, 0x6b, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a,
	0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x8b, 0x02, 0x0a, 0x11,
	0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x97, 0x01, 0xca, 0x41, 0x2e, 0x0a, 0x19, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x70, 0x6f,
	0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f,
	0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x8b, 0x02, 0x0a, 0x11, 0x52, 0x65,
	0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x6f, 0x6b,
	0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x01,
	0xca, 0x41, 0x2e, 0x0a, 0x19, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x19, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75,
	0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x6f, 0x6b,
	0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0xcd, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x66, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70,
	0x6f, 0x6b, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc1, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x22, 0x53, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12,
	0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f,
	0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0xda, 0x01, 0x0a,
	0x0f, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x08, 0x47, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68,
	0x75, 0x62, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc6, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38,
	0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x7c, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x32, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75,
	0x62, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x56,
	0xca, 0x41, 0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xc2, 0x03, 0xea, 0x41, 0x60, 0x0a, 0x20, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x3c,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0xea, 0x41, 0x57, 0x0a,
	0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65,
	0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x42,
	0x08, 0x48, 0x75, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x70, 0x62,
	0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x70, 0x62, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkconnectivity_v1_hub_proto_rawDescOnce sync.Once
	file_google_cloud_networkconnectivity_v1_hub_proto_rawDescData = file_google_cloud_networkconnectivity_v1_hub_proto_rawDesc
)

func file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP() []byte {
	file_google_cloud_networkconnectivity_v1_hub_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkconnectivity_v1_hub_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkconnectivity_v1_hub_proto_rawDescData)
	})
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescData
}

var file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes = make([]protoimpl.MessageInfo, 64)
var file_google_cloud_networkconnectivity_v1_hub_proto_goTypes = []any{
	(LocationFeature)(0),                       // 0: google.cloud.networkconnectivity.v1.LocationFeature
	(RouteType)(0),                             // 1: google.cloud.networkconnectivity.v1.RouteType
	(State)(0),                                 // 2: google.cloud.networkconnectivity.v1.State
	(SpokeType)(0),                             // 3: google.cloud.networkconnectivity.v1.SpokeType
	(PolicyMode)(0),                            // 4: google.cloud.networkconnectivity.v1.PolicyMode
	(PresetTopology)(0),                        // 5: google.cloud.networkconnectivity.v1.PresetTopology
	(Spoke_StateReason_Code)(0),                // 6: google.cloud.networkconnectivity.v1.Spoke.StateReason.Code
	(ListHubSpokesRequest_SpokeView)(0),        // 7: google.cloud.networkconnectivity.v1.ListHubSpokesRequest.SpokeView
	(PscPropagationStatus_Code)(0),             // 8: google.cloud.networkconnectivity.v1.PscPropagationStatus.Code
	(*Hub)(nil),                                // 9: google.cloud.networkconnectivity.v1.Hub
	(*RoutingVPC)(nil),                         // 10: google.cloud.networkconnectivity.v1.RoutingVPC
	(*Spoke)(nil),                              // 11: google.cloud.networkconnectivity.v1.Spoke
	(*RouteTable)(nil),                         // 12: google.cloud.networkconnectivity.v1.RouteTable
	(*Route)(nil),                              // 13: google.cloud.networkconnectivity.v1.Route
	(*Group)(nil),                              // 14: google.cloud.networkconnectivity.v1.Group
	(*AutoAccept)(nil),                         // 15: google.cloud.networkconnectivity.v1.AutoAccept
	(*ListHubsRequest)(nil),                    // 16: google.cloud.networkconnectivity.v1.ListHubsRequest
	(*ListHubsResponse)(nil),                   // 17: google.cloud.networkconnectivity.v1.ListHubsResponse
	(*GetHubRequest)(nil),                      // 18: google.cloud.networkconnectivity.v1.GetHubRequest
	(*CreateHubRequest)(nil),                   // 19: google.cloud.networkconnectivity.v1.CreateHubRequest
	(*UpdateHubRequest)(nil),                   // 20: google.cloud.networkconnectivity.v1.UpdateHubRequest
	(*DeleteHubRequest)(nil),                   // 21: google.cloud.networkconnectivity.v1.DeleteHubRequest
	(*ListHubSpokesRequest)(nil),               // 22: google.cloud.networkconnectivity.v1.ListHubSpokesRequest
	(*ListHubSpokesResponse)(nil),              // 23: google.cloud.networkconnectivity.v1.ListHubSpokesResponse
	(*QueryHubStatusRequest)(nil),              // 24: google.cloud.networkconnectivity.v1.QueryHubStatusRequest
	(*QueryHubStatusResponse)(nil),             // 25: google.cloud.networkconnectivity.v1.QueryHubStatusResponse
	(*HubStatusEntry)(nil),                     // 26: google.cloud.networkconnectivity.v1.HubStatusEntry
	(*PscPropagationStatus)(nil),               // 27: google.cloud.networkconnectivity.v1.PscPropagationStatus
	(*ListSpokesRequest)(nil),                  // 28: google.cloud.networkconnectivity.v1.ListSpokesRequest
	(*ListSpokesResponse)(nil),                 // 29: google.cloud.networkconnectivity.v1.ListSpokesResponse
	(*GetSpokeRequest)(nil),                    // 30: google.cloud.networkconnectivity.v1.GetSpokeRequest
	(*CreateSpokeRequest)(nil),                 // 31: google.cloud.networkconnectivity.v1.CreateSpokeRequest
	(*UpdateSpokeRequest)(nil),                 // 32: google.cloud.networkconnectivity.v1.UpdateSpokeRequest
	(*DeleteSpokeRequest)(nil),                 // 33: google.cloud.networkconnectivity.v1.DeleteSpokeRequest
	(*AcceptHubSpokeRequest)(nil),              // 34: google.cloud.networkconnectivity.v1.AcceptHubSpokeRequest
	(*AcceptHubSpokeResponse)(nil),             // 35: google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse
	(*RejectHubSpokeRequest)(nil),              // 36: google.cloud.networkconnectivity.v1.RejectHubSpokeRequest
	(*RejectHubSpokeResponse)(nil),             // 37: google.cloud.networkconnectivity.v1.RejectHubSpokeResponse
	(*AcceptSpokeUpdateRequest)(nil),           // 38: google.cloud.networkconnectivity.v1.AcceptSpokeUpdateRequest
	(*AcceptSpokeUpdateResponse)(nil),          // 39: google.cloud.networkconnectivity.v1.AcceptSpokeUpdateResponse
	(*RejectSpokeUpdateRequest)(nil),           // 40: google.cloud.networkconnectivity.v1.RejectSpokeUpdateRequest
	(*RejectSpokeUpdateResponse)(nil),          // 41: google.cloud.networkconnectivity.v1.RejectSpokeUpdateResponse
	(*GetRouteTableRequest)(nil),               // 42: google.cloud.networkconnectivity.v1.GetRouteTableRequest
	(*GetRouteRequest)(nil),                    // 43: google.cloud.networkconnectivity.v1.GetRouteRequest
	(*ListRoutesRequest)(nil),                  // 44: google.cloud.networkconnectivity.v1.ListRoutesRequest
	(*ListRoutesResponse)(nil),                 // 45: google.cloud.networkconnectivity.v1.ListRoutesResponse
	(*ListRouteTablesRequest)(nil),             // 46: google.cloud.networkconnectivity.v1.ListRouteTablesRequest
	(*ListRouteTablesResponse)(nil),            // 47: google.cloud.networkconnectivity.v1.ListRouteTablesResponse
	(*ListGroupsRequest)(nil),                  // 48: google.cloud.networkconnectivity.v1.ListGroupsRequest
	(*ListGroupsResponse)(nil),                 // 49: google.cloud.networkconnectivity.v1.ListGroupsResponse
	(*LinkedVpnTunnels)(nil),                   // 50: google.cloud.networkconnectivity.v1.LinkedVpnTunnels
	(*LinkedInterconnectAttachments)(nil),      // 51: google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
	(*LinkedRouterApplianceInstances)(nil),     // 52: google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
	(*LinkedVpcNetwork)(nil),                   // 53: google.cloud.networkconnectivity.v1.LinkedVpcNetwork
	(*LinkedProducerVpcNetwork)(nil),           // 54: google.cloud.networkconnectivity.v1.LinkedProducerVpcNetwork
	(*RouterApplianceInstance)(nil),            // 55: google.cloud.networkconnectivity.v1.RouterApplianceInstance
	(*LocationMetadata)(nil),                   // 56: google.cloud.networkconnectivity.v1.LocationMetadata
	(*NextHopVpcNetwork)(nil),                  // 57: google.cloud.networkconnectivity.v1.NextHopVpcNetwork
	(*NextHopVPNTunnel)(nil),                   // 58: google.cloud.networkconnectivity.v1.NextHopVPNTunnel
	(*NextHopRouterApplianceInstance)(nil),     // 59: google.cloud.networkconnectivity.v1.NextHopRouterApplianceInstance
	(*NextHopInterconnectAttachment)(nil),      // 60: google.cloud.networkconnectivity.v1.NextHopInterconnectAttachment
	(*SpokeSummary)(nil),                       // 61: google.cloud.networkconnectivity.v1.SpokeSummary
	(*GetGroupRequest)(nil),                    // 62: google.cloud.networkconnectivity.v1.GetGroupRequest
	(*UpdateGroupRequest)(nil),                 // 63: google.cloud.networkconnectivity.v1.UpdateGroupRequest
	nil,                                        // 64: google.cloud.networkconnectivity.v1.Hub.LabelsEntry
	(*Spoke_StateReason)(nil),                  // 65: google.cloud.networkconnectivity.v1.Spoke.StateReason
	nil,                                        // 66: google.cloud.networkconnectivity.v1.Spoke.LabelsEntry
	nil,                                        // 67: google.cloud.networkconnectivity.v1.RouteTable.LabelsEntry
	nil,                                        // 68: google.cloud.networkconnectivity.v1.Route.LabelsEntry
	nil,                                        // 69: google.cloud.networkconnectivity.v1.Group.LabelsEntry
	(*SpokeSummary_SpokeTypeCount)(nil),        // 70: google.cloud.networkconnectivity.v1.SpokeSummary.SpokeTypeCount
	(*SpokeSummary_SpokeStateCount)(nil),       // 71: google.cloud.networkconnectivity.v1.SpokeSummary.SpokeStateCount
	(*SpokeSummary_SpokeStateReasonCount)(nil), // 72: google.cloud.networkconnectivity.v1.SpokeSummary.SpokeStateReasonCount
	(*timestamppb.Timestamp)(nil),              // 73: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),              // 74: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),            // 75: google.longrunning.Operation
}
var file_google_cloud_networkconnectivity_v1_hub_proto_depIdxs = []int32{
	73, // 0: google.cloud.networkconnectivity.v1.Hub.create_time:type_name -> google.protobuf.Timestamp
	73, // 1: google.cloud.networkconnectivity.v1.Hub.update_time:type_name -> google.protobuf.Timestamp
	64, // 2: google.cloud.networkconnectivity.v1.Hub.labels:type_name -> google.cloud.networkconnectivity.v1.Hub.LabelsEntry
	2,  // 3: google.cloud.networkconnectivity.v1.Hub.state:type_name -> google.cloud.networkconnectivity.v1.State
	10, // 4: google.cloud.networkconnectivity.v1.Hub.routing_vpcs:type_name -> google.cloud.networkconnectivity.v1.RoutingVPC
	61, // 5: google.cloud.networkconnectivity.v1.Hub.spoke_summary:type_name -> google.cloud.networkconnectivity.v1.SpokeSummary
	4,  // 6: google.cloud.networkconnectivity.v1.Hub.policy_mode:type_name -> google.cloud.networkconnectivity.v1.PolicyMode
	5,  // 7: google.cloud.networkconnectivity.v1.Hub.preset_topology:type_name -> google.cloud.networkconnectivity.v1.PresetTopology
	73, // 8: google.cloud.networkconnectivity.v1.Spoke.create_time:type_name -> google.protobuf.Timestamp
	73, // 9: google.cloud.networkconnectivity.v1.Spoke.update_time:type_name -> google.protobuf.Timestamp
	66, // 10: google.cloud.networkconnectivity.v1.Spoke.labels:type_name -> google.cloud.networkconnectivity.v1.Spoke.LabelsEntry
	50, // 11: google.cloud.networkconnectivity.v1.Spoke.linked_vpn_tunnels:type_name -> google.cloud.networkconnectivity.v1.LinkedVpnTunnels
	51, // 12: google.cloud.networkconnectivity.v1.Spoke.linked_interconnect_attachments:type_name -> google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
	52, // 13: google.cloud.networkconnectivity.v1.Spoke.linked_router_appliance_instances:type_name -> google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
	53, // 14: google.cloud.networkconnectivity.v1.Spoke.linked_vpc_network:type_name -> google.cloud.networkconnectivity.v1.LinkedVpcNetwork
	54, // 15: google.cloud.networkconnectivity.v1.Spoke.linked_producer_vpc_network:type_name -> google.cloud.networkconnectivity.v1.LinkedProducerVpcNetwork
	2,  // 16: google.cloud.networkconnectivity.v1.Spoke.state:type_name -> google.cloud.networkconnectivity.v1.State
	65, // 17: google.cloud.networkconnectivity.v1.Spoke.reasons:type_name -> google.cloud.networkconnectivity.v1.Spoke.StateReason
	3,  // 18: google.cloud.networkconnectivity.v1.Spoke.spoke_type:type_name -> google.cloud.networkconnectivity.v1.SpokeType
	73, // 19: google.cloud.networkconnectivity.v1.RouteTable.create_time:type_name -> google.protobuf.Timestamp
	73, // 20: google.cloud.networkconnectivity.v1.RouteTable.update_time:type_name -> google.protobuf.Timestamp
	67, // 21: google.cloud.networkconnectivity.v1.RouteTable.labels:type_name -> google.cloud.networkconnectivity.v1.RouteTable.LabelsEntry
	2,  // 22: google.cloud.networkconnectivity.v1.RouteTable.state:type_name -> google.cloud.networkconnectivity.v1.State
	73, // 23: google.cloud.networkconnectivity.v1.Route.create_time:type_name -> google.protobuf.Timestamp
	73, // 24: google.cloud.networkconnectivity.v1.Route.update_time:type_name -> google.protobuf.Timestamp
	1,  // 25: google.cloud.networkconnectivity.v1.Route.type:type_name -> google.cloud.networkconnectivity.v1.RouteType
	57, // 26: google.cloud.networkconnectivity.v1.Route.next_hop_vpc_network:type_name -> google.cloud.networkconnectivity.v1.NextHopVpcNetwork
	68, // 27: google.cloud.networkconnectivity.v1.Route.labels:type_name -> google.cloud.networkconnectivity.v1.Route.LabelsEntry
	2,  // 28: google.cloud.networkconnectivity.v1.Route.state:type_name -> google.cloud.networkconnectivity.v1.State
	58, // 29: google.cloud.networkconnectivity.v1.Route.next_hop_vpn_tunnel:type_name -> google.cloud.networkconnectivity.v1.NextHopVPNTunnel
	59, // 30: google.cloud.networkconnectivity.v1.Route.next_hop_router_appliance_instance:type_name -> google.cloud.networkconnectivity.v1.NextHopRouterApplianceInstance
	60, // 31: google.cloud.networkconnectivity.v1.Route.next_hop_interconnect_attachment:type_name -> google.cloud.networkconnectivity.v1.NextHopInterconnectAttachment
	73, // 32: google.cloud.networkconnectivity.v1.Group.create_time:type_name -> google.protobuf.Timestamp
	73, // 33: google.cloud.networkconnectivity.v1.Group.update_time:type_name -> google.protobuf.Timestamp
	69, // 34: google.cloud.networkconnectivity.v1.Group.labels:type_name -> google.cloud.networkconnectivity.v1.Group.LabelsEntry
	2,  // 35: google.cloud.networkconnectivity.v1.Group.state:type_name -> google.cloud.networkconnectivity.v1.State
	15, // 36: google.cloud.networkconnectivity.v1.Group.auto_accept:type_name -> google.cloud.networkconnectivity.v1.AutoAccept
	9,  // 37: google.cloud.networkconnectivity.v1.ListHubsResponse.hubs:type_name -> google.cloud.networkconnectivity.v1.Hub
	9,  // 38: google.cloud.networkconnectivity.v1.CreateHubRequest.hub:type_name -> google.cloud.networkconnectivity.v1.Hub
	74, // 39: google.cloud.networkconnectivity.v1.UpdateHubRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 40: google.cloud.networkconnectivity.v1.UpdateHubRequest.hub:type_name -> google.cloud.networkconnectivity.v1.Hub
	7,  // 41: google.cloud.networkconnectivity.v1.ListHubSpokesRequest.view:type_name -> google.cloud.networkconnectivity.v1.ListHubSpokesRequest.SpokeView
	11, // 42: google.cloud.networkconnectivity.v1.ListHubSpokesResponse.spokes:type_name -> google.cloud.networkconnectivity.v1.Spoke
	26, // 43: google.cloud.networkconnectivity.v1.QueryHubStatusResponse.hub_status_entries:type_name -> google.cloud.networkconnectivity.v1.HubStatusEntry
	27, // 44: google.cloud.networkconnectivity.v1.HubStatusEntry.psc_propagation_status:type_name -> google.cloud.networkconnectivity.v1.PscPropagationStatus
	8,  // 45: google.cloud.networkconnectivity.v1.PscPropagationStatus.code:type_name -> google.cloud.networkconnectivity.v1.PscPropagationStatus.Code
	11, // 46: google.cloud.networkconnectivity.v1.ListSpokesResponse.spokes:type_name -> google.cloud.networkconnectivity.v1.Spoke
	11, // 47: google.cloud.networkconnectivity.v1.CreateSpokeRequest.spoke:type_name -> google.cloud.networkconnectivity.v1.Spoke
	74, // 48: google.cloud.networkconnectivity.v1.UpdateSpokeRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 49: google.cloud.networkconnectivity.v1.UpdateSpokeRequest.spoke:type_name -> google.cloud.networkconnectivity.v1.Spoke
	11, // 50: google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse.spoke:type_name -> google.cloud.networkconnectivity.v1.Spoke
	11, // 51: google.cloud.networkconnectivity.v1.RejectHubSpokeResponse.spoke:type_name -> google.cloud.networkconnectivity.v1.Spoke
	11, // 52: google.cloud.networkconnectivity.v1.AcceptSpokeUpdateResponse.spoke:type_name -> google.cloud.networkconnectivity.v1.Spoke
	11, // 53: google.cloud.networkconnectivity.v1.RejectSpokeUpdateResponse.spoke:type_name -> google.cloud.networkconnectivity.v1.Spoke
	13, // 54: google.cloud.networkconnectivity.v1.ListRoutesResponse.routes:type_name -> google.cloud.networkconnectivity.v1.Route
	12, // 55: google.cloud.networkconnectivity.v1.ListRouteTablesResponse.route_tables:type_name -> google.cloud.networkconnectivity.v1.RouteTable
	14, // 56: google.cloud.networkconnectivity.v1.ListGroupsResponse.groups:type_name -> google.cloud.networkconnectivity.v1.Group
	55, // 57: google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances.instances:type_name -> google.cloud.networkconnectivity.v1.RouterApplianceInstance
	0,  // 58: google.cloud.networkconnectivity.v1.LocationMetadata.location_features:type_name -> google.cloud.networkconnectivity.v1.LocationFeature
	70, // 59: google.cloud.networkconnectivity.v1.SpokeSummary.spoke_type_counts:type_name -> google.cloud.networkconnectivity.v1.SpokeSummary.SpokeTypeCount
	71, // 60: google.cloud.networkconnectivity.v1.SpokeSummary.spoke_state_counts:type_name -> google.cloud.networkconnectivity.v1.SpokeSummary.SpokeStateCount
	72, // 61: google.cloud.networkconnectivity.v1.SpokeSummary.spoke_state_reason_counts:type_name -> google.cloud.networkconnectivity.v1.SpokeSummary.SpokeStateReasonCount
	74, // 62: google.cloud.networkconnectivity.v1.UpdateGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 63: google.cloud.networkconnectivity.v1.UpdateGroupRequest.group:type_name -> google.cloud.networkconnectivity.v1.Group
	6,  // 64: google.cloud.networkconnectivity.v1.Spoke.StateReason.code:type_name -> google.cloud.networkconnectivity.v1.Spoke.StateReason.Code
	3,  // 65: google.cloud.networkconnectivity.v1.SpokeSummary.SpokeTypeCount.spoke_type:type_name -> google.cloud.networkconnectivity.v1.SpokeType
	2,  // 66: google.cloud.networkconnectivity.v1.SpokeSummary.SpokeStateCount.state:type_name -> google.cloud.networkconnectivity.v1.State
	6,  // 67: google.cloud.networkconnectivity.v1.SpokeSummary.SpokeStateReasonCount.state_reason_code:type_name -> google.cloud.networkconnectivity.v1.Spoke.StateReason.Code
	16, // 68: google.cloud.networkconnectivity.v1.HubService.ListHubs:input_type -> google.cloud.networkconnectivity.v1.ListHubsRequest
	18, // 69: google.cloud.networkconnectivity.v1.HubService.GetHub:input_type -> google.cloud.networkconnectivity.v1.GetHubRequest
	19, // 70: google.cloud.networkconnectivity.v1.HubService.CreateHub:input_type -> google.cloud.networkconnectivity.v1.CreateHubRequest
	20, // 71: google.cloud.networkconnectivity.v1.HubService.UpdateHub:input_type -> google.cloud.networkconnectivity.v1.UpdateHubRequest
	21, // 72: google.cloud.networkconnectivity.v1.HubService.DeleteHub:input_type -> google.cloud.networkconnectivity.v1.DeleteHubRequest
	22, // 73: google.cloud.networkconnectivity.v1.HubService.ListHubSpokes:input_type -> google.cloud.networkconnectivity.v1.ListHubSpokesRequest
	24, // 74: google.cloud.networkconnectivity.v1.HubService.QueryHubStatus:input_type -> google.cloud.networkconnectivity.v1.QueryHubStatusRequest
	28, // 75: google.cloud.networkconnectivity.v1.HubService.ListSpokes:input_type -> google.cloud.networkconnectivity.v1.ListSpokesRequest
	30, // 76: google.cloud.networkconnectivity.v1.HubService.GetSpoke:input_type -> google.cloud.networkconnectivity.v1.GetSpokeRequest
	31, // 77: google.cloud.networkconnectivity.v1.HubService.CreateSpoke:input_type -> google.cloud.networkconnectivity.v1.CreateSpokeRequest
	32, // 78: google.cloud.networkconnectivity.v1.HubService.UpdateSpoke:input_type -> google.cloud.networkconnectivity.v1.UpdateSpokeRequest
	36, // 79: google.cloud.networkconnectivity.v1.HubService.RejectHubSpoke:input_type -> google.cloud.networkconnectivity.v1.RejectHubSpokeRequest
	34, // 80: google.cloud.networkconnectivity.v1.HubService.AcceptHubSpoke:input_type -> google.cloud.networkconnectivity.v1.AcceptHubSpokeRequest
	38, // 81: google.cloud.networkconnectivity.v1.HubService.AcceptSpokeUpdate:input_type -> google.cloud.networkconnectivity.v1.AcceptSpokeUpdateRequest
	40, // 82: google.cloud.networkconnectivity.v1.HubService.RejectSpokeUpdate:input_type -> google.cloud.networkconnectivity.v1.RejectSpokeUpdateRequest
	33, // 83: google.cloud.networkconnectivity.v1.HubService.DeleteSpoke:input_type -> google.cloud.networkconnectivity.v1.DeleteSpokeRequest
	42, // 84: google.cloud.networkconnectivity.v1.HubService.GetRouteTable:input_type -> google.cloud.networkconnectivity.v1.GetRouteTableRequest
	43, // 85: google.cloud.networkconnectivity.v1.HubService.GetRoute:input_type -> google.cloud.networkconnectivity.v1.GetRouteRequest
	44, // 86: google.cloud.networkconnectivity.v1.HubService.ListRoutes:input_type -> google.cloud.networkconnectivity.v1.ListRoutesRequest
	46, // 87: google.cloud.networkconnectivity.v1.HubService.ListRouteTables:input_type -> google.cloud.networkconnectivity.v1.ListRouteTablesRequest
	62, // 88: google.cloud.networkconnectivity.v1.HubService.GetGroup:input_type -> google.cloud.networkconnectivity.v1.GetGroupRequest
	48, // 89: google.cloud.networkconnectivity.v1.HubService.ListGroups:input_type -> google.cloud.networkconnectivity.v1.ListGroupsRequest
	63, // 90: google.cloud.networkconnectivity.v1.HubService.UpdateGroup:input_type -> google.cloud.networkconnectivity.v1.UpdateGroupRequest
	17, // 91: google.cloud.networkconnectivity.v1.HubService.ListHubs:output_type -> google.cloud.networkconnectivity.v1.ListHubsResponse
	9,  // 92: google.cloud.networkconnectivity.v1.HubService.GetHub:output_type -> google.cloud.networkconnectivity.v1.Hub
	75, // 93: google.cloud.networkconnectivity.v1.HubService.CreateHub:output_type -> google.longrunning.Operation
	75, // 94: google.cloud.networkconnectivity.v1.HubService.UpdateHub:output_type -> google.longrunning.Operation
	75, // 95: google.cloud.networkconnectivity.v1.HubService.DeleteHub:output_type -> google.longrunning.Operation
	23, // 96: google.cloud.networkconnectivity.v1.HubService.ListHubSpokes:output_type -> google.cloud.networkconnectivity.v1.ListHubSpokesResponse
	25, // 97: google.cloud.networkconnectivity.v1.HubService.QueryHubStatus:output_type -> google.cloud.networkconnectivity.v1.QueryHubStatusResponse
	29, // 98: google.cloud.networkconnectivity.v1.HubService.ListSpokes:output_type -> google.cloud.networkconnectivity.v1.ListSpokesResponse
	11, // 99: google.cloud.networkconnectivity.v1.HubService.GetSpoke:output_type -> google.cloud.networkconnectivity.v1.Spoke
	75, // 100: google.cloud.networkconnectivity.v1.HubService.CreateSpoke:output_type -> google.longrunning.Operation
	75, // 101: google.cloud.networkconnectivity.v1.HubService.UpdateSpoke:output_type -> google.longrunning.Operation
	75, // 102: google.cloud.networkconnectivity.v1.HubService.RejectHubSpoke:output_type -> google.longrunning.Operation
	75, // 103: google.cloud.networkconnectivity.v1.HubService.AcceptHubSpoke:output_type -> google.longrunning.Operation
	75, // 104: google.cloud.networkconnectivity.v1.HubService.AcceptSpokeUpdate:output_type -> google.longrunning.Operation
	75, // 105: google.cloud.networkconnectivity.v1.HubService.RejectSpokeUpdate:output_type -> google.longrunning.Operation
	75, // 106: google.cloud.networkconnectivity.v1.HubService.DeleteSpoke:output_type -> google.longrunning.Operation
	12, // 107: google.cloud.networkconnectivity.v1.HubService.GetRouteTable:output_type -> google.cloud.networkconnectivity.v1.RouteTable
	13, // 108: google.cloud.networkconnectivity.v1.HubService.GetRoute:output_type -> google.cloud.networkconnectivity.v1.Route
	45, // 109: google.cloud.networkconnectivity.v1.HubService.ListRoutes:output_type -> google.cloud.networkconnectivity.v1.ListRoutesResponse
	47, // 110: google.cloud.networkconnectivity.v1.HubService.ListRouteTables:output_type -> google.cloud.networkconnectivity.v1.ListRouteTablesResponse
	14, // 111: google.cloud.networkconnectivity.v1.HubService.GetGroup:output_type -> google.cloud.networkconnectivity.v1.Group
	49, // 112: google.cloud.networkconnectivity.v1.HubService.ListGroups:output_type -> google.cloud.networkconnectivity.v1.ListGroupsResponse
	75, // 113: google.cloud.networkconnectivity.v1.HubService.UpdateGroup:output_type -> google.longrunning.Operation
	91, // [91:114] is the sub-list for method output_type
	68, // [68:91] is the sub-list for method input_type
	68, // [68:68] is the sub-list for extension type_name
	68, // [68:68] is the sub-list for extension extendee
	0,  // [0:68] is the sub-list for field type_name
}

func init() { file_google_cloud_networkconnectivity_v1_hub_proto_init() }
func file_google_cloud_networkconnectivity_v1_hub_proto_init() {
	if File_google_cloud_networkconnectivity_v1_hub_proto != nil {
		return
	}
	file_google_cloud_networkconnectivity_v1_common_proto_init()
	file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkconnectivity_v1_hub_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   64,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_networkconnectivity_v1_hub_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkconnectivity_v1_hub_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes,
	}.Build()
	File_google_cloud_networkconnectivity_v1_hub_proto = out.File
	file_google_cloud_networkconnectivity_v1_hub_proto_rawDesc = nil
	file_google_cloud_networkconnectivity_v1_hub_proto_goTypes = nil
	file_google_cloud_networkconnectivity_v1_hub_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// HubServiceClient is the client API for HubService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HubServiceClient interface {
	// Lists the Network Connectivity Center hubs associated with a given project.
	ListHubs(ctx context.Context, in *ListHubsRequest, opts ...grpc.CallOption) (*ListHubsResponse, error)
	// Gets details about a Network Connectivity Center hub.
	GetHub(ctx context.Context, in *GetHubRequest, opts ...grpc.CallOption) (*Hub, error)
	// Creates a new Network Connectivity Center hub in the specified project.
	CreateHub(ctx context.Context, in *CreateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the description and/or labels of a Network Connectivity Center
	// hub.
	UpdateHub(ctx context.Context, in *UpdateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a Network Connectivity Center hub.
	DeleteHub(ctx context.Context, in *DeleteHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the Network Connectivity Center spokes associated with a
	// specified hub and location. The list includes both spokes that are attached
	// to the hub and spokes that have been proposed but not yet accepted.
	ListHubSpokes(ctx context.Context, in *ListHubSpokesRequest, opts ...grpc.CallOption) (*ListHubSpokesResponse, error)
	// Query the Private Service Connect propagation status of a Network
	// Connectivity Center hub.
	QueryHubStatus(ctx context.Context, in *QueryHubStatusRequest, opts ...grpc.CallOption) (*QueryHubStatusResponse, error)
	// Lists the Network Connectivity Center spokes in a specified project and
	// location.
	ListSpokes(ctx context.Context, in *ListSpokesRequest, opts ...grpc.CallOption) (*ListSpokesResponse, error)
	// Gets details about a Network Connectivity Center spoke.
	GetSpoke(ctx context.Context, in *GetSpokeRequest, opts ...grpc.CallOption) (*Spoke, error)
	// Creates a Network Connectivity Center spoke.
	CreateSpoke(ctx context.Context, in *CreateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a Network Connectivity Center spoke.
	UpdateSpoke(ctx context.Context, in *UpdateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rejects a Network Connectivity Center spoke from being attached to a hub.
	// If the spoke was previously in the `ACTIVE` state, it
	// transitions to the `INACTIVE` state and is no longer able to
	// connect to other spokes that are attached to the hub.
	RejectHubSpoke(ctx context.Context, in *RejectHubSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Accepts a proposal to attach a Network Connectivity Center spoke
	// to a hub.
	AcceptHubSpoke(ctx context.Context, in *AcceptHubSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Accepts a proposal to update a Network Connectivity Center spoke in a hub.
	AcceptSpokeUpdate(ctx context.Context, in *AcceptSpokeUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rejects a proposal to update a Network Connectivity Center spoke in a hub.
	RejectSpokeUpdate(ctx context.Context, in *RejectSpokeUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a Network Connectivity Center spoke.
	DeleteSpoke(ctx context.Context, in *DeleteSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details about a Network Connectivity Center route table.
	GetRouteTable(ctx context.Context, in *GetRouteTableRequest, opts ...grpc.CallOption) (*RouteTable, error)
	// Gets details about the specified route.
	GetRoute(ctx context.Context, in *GetRouteRequest, opts ...grpc.CallOption) (*Route, error)
	// Lists routes in a given route table.
	ListRoutes(ctx context.Context, in *ListRoutesRequest, opts ...grpc.CallOption) (*ListRoutesResponse, error)
	// Lists route tables in a given hub.
	ListRouteTables(ctx context.Context, in *ListRouteTablesRequest, opts ...grpc.CallOption) (*ListRouteTablesResponse, error)
	// Gets details about a Network Connectivity Center group.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error)
	// Lists groups in a given hub.
	ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error)
	// Updates the parameters of a Network Connectivity Center group.
	UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type hubServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHubServiceClient(cc grpc.ClientConnInterface) HubServiceClient {
	return &hubServiceClient{cc}
}

func (c *hubServiceClient) ListHubs(ctx context.Context, in *ListHubsRequest, opts ...grpc.CallOption) (*ListHubsResponse, error) {
	out := new(ListHubsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/ListHubs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetHub(ctx context.Context, in *GetHubRequest, opts ...grpc.CallOption) (*Hub, error) {
	out := new(Hub)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/GetHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) CreateHub(ctx context.Context, in *CreateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/CreateHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateHub(ctx context.Context, in *UpdateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/UpdateHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) DeleteHub(ctx context.Context, in *DeleteHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/DeleteHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListHubSpokes(ctx context.Context, in *ListHubSpokesRequest, opts ...grpc.CallOption) (*ListHubSpokesResponse, error) {
	out := new(ListHubSpokesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/ListHubSpokes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) QueryHubStatus(ctx context.Context, in *QueryHubStatusRequest, opts ...grpc.CallOption) (*QueryHubStatusResponse, error) {
	out := new(QueryHubStatusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/QueryHubStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListSpokes(ctx context.Context, in *ListSpokesRequest, opts ...grpc.CallOption) (*ListSpokesResponse, error) {
	out := new(ListSpokesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/ListSpokes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetSpoke(ctx context.Context, in *GetSpokeRequest, opts ...grpc.CallOption) (*Spoke, error) {
	out := new(Spoke)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/GetSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) CreateSpoke(ctx context.Context, in *CreateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/CreateSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateSpoke(ctx context.Context, in *UpdateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/UpdateSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) RejectHubSpoke(ctx context.Context, in *RejectHubSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/RejectHubSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) AcceptHubSpoke(ctx context.Context, in *AcceptHubSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/AcceptHubSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) AcceptSpokeUpdate(ctx context.Context, in *AcceptSpokeUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/AcceptSpokeUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) RejectSpokeUpdate(ctx context.Context, in *RejectSpokeUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/RejectSpokeUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) DeleteSpoke(ctx context.Context, in *DeleteSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/DeleteSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetRouteTable(ctx context.Context, in *GetRouteTableRequest, opts ...grpc.CallOption) (*RouteTable, error) {
	out := new(RouteTable)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/GetRouteTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetRoute(ctx context.Context, in *GetRouteRequest, opts ...grpc.CallOption) (*Route, error) {
	out := new(Route)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/GetRoute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListRoutes(ctx context.Context, in *ListRoutesRequest, opts ...grpc.CallOption) (*ListRoutesResponse, error) {
	out := new(ListRoutesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/ListRoutes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListRouteTables(ctx context.Context, in *ListRouteTablesRequest, opts ...grpc.CallOption) (*ListRouteTablesResponse, error) {
	out := new(ListRouteTablesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/ListRouteTables", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/GetGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error) {
	out := new(ListGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/ListGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/UpdateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HubServiceServer is the server API for HubService service.
type HubServiceServer interface {
	// Lists the Network Connectivity Center hubs associated with a given project.
	ListHubs(context.Context, *ListHubsRequest) (*ListHubsResponse, error)
	// Gets details about a Network Connectivity Center hub.
	GetHub(context.Context, *GetHubRequest) (*Hub, error)
	// Creates a new Network Connectivity Center hub in the specified project.
	CreateHub(context.Context, *CreateHubRequest) (*longrunningpb.Operation, error)
	// Updates the description and/or labels of a Network Connectivity Center
	// hub.
	UpdateHub(context.Context, *UpdateHubRequest) (*longrunningpb.Operation, error)
	// Deletes a Network Connectivity Center hub.
	DeleteHub(context.Context, *DeleteHubRequest) (*longrunningpb.Operation, error)
	// Lists the Network Connectivity Center spokes associated with a
	// specified hub and location. The list includes both spokes that are attached
	// to the hub and spokes that have been proposed but not yet accepted.
	ListHubSpokes(context.Context, *ListHubSpokesRequest) (*ListHubSpokesResponse, error)
	// Query the Private Service Connect propagation status of a Network
	// Connectivity Center hub.
	QueryHubStatus(context.Context, *QueryHubStatusRequest) (*QueryHubStatusResponse, error)
	// Lists the Network Connectivity Center spokes in a specified project and
	// location.
	ListSpokes(context.Context, *ListSpokesRequest) (*ListSpokesResponse, error)
	// Gets details about a Network Connectivity Center spoke.
	GetSpoke(context.Context, *GetSpokeRequest) (*Spoke, error)
	// Creates a Network Connectivity Center spoke.
	CreateSpoke(context.Context, *CreateSpokeRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a Network Connectivity Center spoke.
	UpdateSpoke(context.Context, *UpdateSpokeRequest) (*longrunningpb.Operation, error)
	// Rejects a Network Connectivity Center spoke from being attached to a hub.
	// If the spoke was previously in the `ACTIVE` state, it
	// transitions to the `INACTIVE` state and is no longer able to
	// connect to other spokes that are attached to the hub.
	RejectHubSpoke(context.Context, *RejectHubSpokeRequest) (*longrunningpb.Operation, error)
	// Accepts a proposal to attach a Network Connectivity Center spoke
	// to a hub.
	AcceptHubSpoke(context.Context, *AcceptHubSpokeRequest) (*longrunningpb.Operation, error)
	// Accepts a proposal to update a Network Connectivity Center spoke in a hub.
	AcceptSpokeUpdate(context.Context, *AcceptSpokeUpdateRequest) (*longrunningpb.Operation, error)
	// Rejects a proposal to update a Network Connectivity Center spoke in a hub.
	RejectSpokeUpdate(context.Context, *RejectSpokeUpdateRequest) (*longrunningpb.Operation, error)
	// Deletes a Network Connectivity Center spoke.
	DeleteSpoke(context.Context, *DeleteSpokeRequest) (*longrunningpb.Operation, error)
	// Gets details about a Network Connectivity Center route table.
	GetRouteTable(context.Context, *GetRouteTableRequest) (*RouteTable, error)
	// Gets details about the specified route.
	GetRoute(context.Context, *GetRouteRequest) (*Route, error)
	// Lists routes in a given route table.
	ListRoutes(context.Context, *ListRoutesRequest) (*ListRoutesResponse, error)
	// Lists route tables in a given hub.
	ListRouteTables(context.Context, *ListRouteTablesRequest) (*ListRouteTablesResponse, error)
	// Gets details about a Network Connectivity Center group.
	GetGroup(context.Context, *GetGroupRequest) (*Group, error)
	// Lists groups in a given hub.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)
	// Updates the parameters of a Network Connectivity Center group.
	UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error)
}

// UnimplementedHubServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHubServiceServer struct {
}

func (*UnimplementedHubServiceServer) ListHubs(context.Context, *ListHubsRequest) (*ListHubsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHubs not implemented")
}
func (*UnimplementedHubServiceServer) GetHub(context.Context, *GetHubRequest) (*Hub, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHub not implemented")
}
func (*UnimplementedHubServiceServer) CreateHub(context.Context, *CreateHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHub not implemented")
}
func (*UnimplementedHubServiceServer) UpdateHub(context.Context, *UpdateHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHub not implemented")
}
func (*UnimplementedHubServiceServer) DeleteHub(context.Context, *DeleteHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHub not implemented")
}
func (*UnimplementedHubServiceServer) ListHubSpokes(context.Context, *ListHubSpokesRequest) (*ListHubSpokesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHubSpokes not implemented")
}
func (*UnimplementedHubServiceServer) QueryHubStatus(context.Context, *QueryHubStatusRequest) (*QueryHubStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryHubStatus not implemented")
}
func (*UnimplementedHubServiceServer) ListSpokes(context.Context, *ListSpokesRequest) (*ListSpokesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSpokes not implemented")
}
func (*UnimplementedHubServiceServer) GetSpoke(context.Context, *GetSpokeRequest) (*Spoke, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpoke not implemented")
}
func (*UnimplementedHubServiceServer) CreateSpoke(context.Context, *CreateSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpoke not implemented")
}
func (*UnimplementedHubServiceServer) UpdateSpoke(context.Context, *UpdateSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpoke not implemented")
}
func (*UnimplementedHubServiceServer) RejectHubSpoke(context.Context, *RejectHubSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RejectHubSpoke not implemented")
}
func (*UnimplementedHubServiceServer) AcceptHubSpoke(context.Context, *AcceptHubSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcceptHubSpoke not implemented")
}
func (*UnimplementedHubServiceServer) AcceptSpokeUpdate(context.Context, *AcceptSpokeUpdateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcceptSpokeUpdate not implemented")
}
func (*UnimplementedHubServiceServer) RejectSpokeUpdate(context.Context, *RejectSpokeUpdateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RejectSpokeUpdate not implemented")
}
func (*UnimplementedHubServiceServer) DeleteSpoke(context.Context, *DeleteSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSpoke not implemented")
}
func (*UnimplementedHubServiceServer) GetRouteTable(context.Context, *GetRouteTableRequest) (*RouteTable, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRouteTable not implemented")
}
func (*UnimplementedHubServiceServer) GetRoute(context.Context, *GetRouteRequest) (*Route, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRoute not implemented")
}
func (*UnimplementedHubServiceServer) ListRoutes(context.Context, *ListRoutesRequest) (*ListRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoutes not implemented")
}
func (*UnimplementedHubServiceServer) ListRouteTables(context.Context, *ListRouteTablesRequest) (*ListRouteTablesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRouteTables not implemented")
}
func (*UnimplementedHubServiceServer) GetGroup(context.Context, *GetGroupRequest) (*Group, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroup not implemented")
}
func (*UnimplementedHubServiceServer) ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroups not implemented")
}
func (*UnimplementedHubServiceServer) UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGroup not implemented")
}

func RegisterHubServiceServer(s *grpc.Server, srv HubServiceServer) {
	s.RegisterService(&_HubService_serviceDesc, srv)
}

func _HubService_ListHubs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHubsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListHubs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/ListHubs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListHubs(ctx, req.(*ListHubsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/GetHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetHub(ctx, req.(*GetHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_CreateHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).CreateHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/CreateHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).CreateHub(ctx, req.(*CreateHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/UpdateHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateHub(ctx, req.(*UpdateHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_DeleteHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).DeleteHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/DeleteHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).DeleteHub(ctx, req.(*DeleteHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListHubSpokes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHubSpokesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListHubSpokes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/ListHubSpokes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListHubSpokes(ctx, req.(*ListHubSpokesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_QueryHubStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryHubStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).QueryHubStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/QueryHubStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).QueryHubStatus(ctx, req.(*QueryHubStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListSpokes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSpokesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListSpokes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/ListSpokes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListSpokes(ctx, req.(*ListSpokesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/GetSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetSpoke(ctx, req.(*GetSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_CreateSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).CreateSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/CreateSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).CreateSpoke(ctx, req.(*CreateSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/UpdateSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateSpoke(ctx, req.(*UpdateSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_RejectHubSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RejectHubSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).RejectHubSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/RejectHubSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).RejectHubSpoke(ctx, req.(*RejectHubSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_AcceptHubSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcceptHubSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).AcceptHubSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/AcceptHubSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).AcceptHubSpoke(ctx, req.(*AcceptHubSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_AcceptSpokeUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcceptSpokeUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).AcceptSpokeUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/AcceptSpokeUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).AcceptSpokeUpdate(ctx, req.(*AcceptSpokeUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_RejectSpokeUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RejectSpokeUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).RejectSpokeUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/RejectSpokeUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).RejectSpokeUpdate(ctx, req.(*RejectSpokeUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_DeleteSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).DeleteSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/DeleteSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).DeleteSpoke(ctx, req.(*DeleteSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetRouteTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRouteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetRouteTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/GetRouteTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetRouteTable(ctx, req.(*GetRouteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/GetRoute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetRoute(ctx, req.(*GetRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/ListRoutes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListRoutes(ctx, req.(*ListRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListRouteTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRouteTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListRouteTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/ListRouteTables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListRouteTables(ctx, req.(*ListRouteTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/ListGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListGroups(ctx, req.(*ListGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateGroup(ctx, req.(*UpdateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HubService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.HubService",
	HandlerType: (*HubServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListHubs",
			Handler:    _HubService_ListHubs_Handler,
		},
		{
			MethodName: "GetHub",
			Handler:    _HubService_GetHub_Handler,
		},
		{
			MethodName: "CreateHub",
			Handler:    _HubService_CreateHub_Handler,
		},
		{
			MethodName: "UpdateHub",
			Handler:    _HubService_UpdateHub_Handler,
		},
		{
			MethodName: "DeleteHub",
			Handler:    _HubService_DeleteHub_Handler,
		},
		{
			MethodName: "ListHubSpokes",
			Handler:    _HubService_ListHubSpokes_Handler,
		},
		{
			MethodName: "QueryHubStatus",
			Handler:    _HubService_QueryHubStatus_Handler,
		},
		{
			MethodName: "ListSpokes",
			Handler:    _HubService_ListSpokes_Handler,
		},
		{
			MethodName: "GetSpoke",
			Handler:    _HubService_GetSpoke_Handler,
		},
		{
			MethodName: "CreateSpoke",
			Handler:    _HubService_CreateSpoke_Handler,
		},
		{
			MethodName: "UpdateSpoke",
			Handler:    _HubService_UpdateSpoke_Handler,
		},
		{
			MethodName: "RejectHubSpoke",
			Handler:    _HubService_RejectHubSpoke_Handler,
		},
		{
			MethodName: "AcceptHubSpoke",
			Handler:    _HubService_AcceptHubSpoke_Handler,
		},
		{
			MethodName: "AcceptSpokeUpdate",
			Handler:    _HubService_AcceptSpokeUpdate_Handler,
		},
		{
			MethodName: "RejectSpokeUpdate",
			Handler:    _HubService_RejectSpokeUpdate_Handler,
		},
		{
			MethodName: "DeleteSpoke",
			Handler:    _HubService_DeleteSpoke_Handler,
		},
		{
			MethodName: "GetRouteTable",
			Handler:    _HubService_GetRouteTable_Handler,
		},
		{
			MethodName: "GetRoute",
			Handler:    _HubService_GetRoute_Handler,
		},
		{
			MethodName: "ListRoutes",
			Handler:    _HubService_ListRoutes_Handler,
		},
		{
			MethodName: "ListRouteTables",
			Handler:    _HubService_ListRouteTables_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _HubService_GetGroup_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _HubService_ListGroups_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _HubService_UpdateGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/hub.proto",
}
