// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/recommendationengine/v1beta1/prediction_apikey_registry_service.proto

package recommendationenginepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PredictionApiKeyRegistry_CreatePredictionApiKeyRegistration_FullMethodName = "/google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry/CreatePredictionApiKeyRegistration"
	PredictionApiKeyRegistry_ListPredictionApiKeyRegistrations_FullMethodName  = "/google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry/ListPredictionApiKeyRegistrations"
	PredictionApiKeyRegistry_DeletePredictionApiKeyRegistration_FullMethodName = "/google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry/DeletePredictionApiKeyRegistration"
)

// PredictionApiKeyRegistryClient is the client API for PredictionApiKeyRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PredictionApiKeyRegistryClient interface {
	// Register an API key for use with predict method.
	CreatePredictionApiKeyRegistration(ctx context.Context, in *CreatePredictionApiKeyRegistrationRequest, opts ...grpc.CallOption) (*PredictionApiKeyRegistration, error)
	// List the registered apiKeys for use with predict method.
	ListPredictionApiKeyRegistrations(ctx context.Context, in *ListPredictionApiKeyRegistrationsRequest, opts ...grpc.CallOption) (*ListPredictionApiKeyRegistrationsResponse, error)
	// Unregister an apiKey from using for predict method.
	DeletePredictionApiKeyRegistration(ctx context.Context, in *DeletePredictionApiKeyRegistrationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type predictionApiKeyRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewPredictionApiKeyRegistryClient(cc grpc.ClientConnInterface) PredictionApiKeyRegistryClient {
	return &predictionApiKeyRegistryClient{cc}
}

func (c *predictionApiKeyRegistryClient) CreatePredictionApiKeyRegistration(ctx context.Context, in *CreatePredictionApiKeyRegistrationRequest, opts ...grpc.CallOption) (*PredictionApiKeyRegistration, error) {
	out := new(PredictionApiKeyRegistration)
	err := c.cc.Invoke(ctx, PredictionApiKeyRegistry_CreatePredictionApiKeyRegistration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionApiKeyRegistryClient) ListPredictionApiKeyRegistrations(ctx context.Context, in *ListPredictionApiKeyRegistrationsRequest, opts ...grpc.CallOption) (*ListPredictionApiKeyRegistrationsResponse, error) {
	out := new(ListPredictionApiKeyRegistrationsResponse)
	err := c.cc.Invoke(ctx, PredictionApiKeyRegistry_ListPredictionApiKeyRegistrations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionApiKeyRegistryClient) DeletePredictionApiKeyRegistration(ctx context.Context, in *DeletePredictionApiKeyRegistrationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, PredictionApiKeyRegistry_DeletePredictionApiKeyRegistration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PredictionApiKeyRegistryServer is the server API for PredictionApiKeyRegistry service.
// All implementations should embed UnimplementedPredictionApiKeyRegistryServer
// for forward compatibility
type PredictionApiKeyRegistryServer interface {
	// Register an API key for use with predict method.
	CreatePredictionApiKeyRegistration(context.Context, *CreatePredictionApiKeyRegistrationRequest) (*PredictionApiKeyRegistration, error)
	// List the registered apiKeys for use with predict method.
	ListPredictionApiKeyRegistrations(context.Context, *ListPredictionApiKeyRegistrationsRequest) (*ListPredictionApiKeyRegistrationsResponse, error)
	// Unregister an apiKey from using for predict method.
	DeletePredictionApiKeyRegistration(context.Context, *DeletePredictionApiKeyRegistrationRequest) (*emptypb.Empty, error)
}

// UnimplementedPredictionApiKeyRegistryServer should be embedded to have forward compatible implementations.
type UnimplementedPredictionApiKeyRegistryServer struct {
}

func (UnimplementedPredictionApiKeyRegistryServer) CreatePredictionApiKeyRegistration(context.Context, *CreatePredictionApiKeyRegistrationRequest) (*PredictionApiKeyRegistration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePredictionApiKeyRegistration not implemented")
}
func (UnimplementedPredictionApiKeyRegistryServer) ListPredictionApiKeyRegistrations(context.Context, *ListPredictionApiKeyRegistrationsRequest) (*ListPredictionApiKeyRegistrationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPredictionApiKeyRegistrations not implemented")
}
func (UnimplementedPredictionApiKeyRegistryServer) DeletePredictionApiKeyRegistration(context.Context, *DeletePredictionApiKeyRegistrationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePredictionApiKeyRegistration not implemented")
}

// UnsafePredictionApiKeyRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PredictionApiKeyRegistryServer will
// result in compilation errors.
type UnsafePredictionApiKeyRegistryServer interface {
	mustEmbedUnimplementedPredictionApiKeyRegistryServer()
}

func RegisterPredictionApiKeyRegistryServer(s grpc.ServiceRegistrar, srv PredictionApiKeyRegistryServer) {
	s.RegisterService(&PredictionApiKeyRegistry_ServiceDesc, srv)
}

func _PredictionApiKeyRegistry_CreatePredictionApiKeyRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePredictionApiKeyRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionApiKeyRegistryServer).CreatePredictionApiKeyRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionApiKeyRegistry_CreatePredictionApiKeyRegistration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionApiKeyRegistryServer).CreatePredictionApiKeyRegistration(ctx, req.(*CreatePredictionApiKeyRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionApiKeyRegistry_ListPredictionApiKeyRegistrations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPredictionApiKeyRegistrationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionApiKeyRegistryServer).ListPredictionApiKeyRegistrations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionApiKeyRegistry_ListPredictionApiKeyRegistrations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionApiKeyRegistryServer).ListPredictionApiKeyRegistrations(ctx, req.(*ListPredictionApiKeyRegistrationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionApiKeyRegistry_DeletePredictionApiKeyRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePredictionApiKeyRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionApiKeyRegistryServer).DeletePredictionApiKeyRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionApiKeyRegistry_DeletePredictionApiKeyRegistration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionApiKeyRegistryServer).DeletePredictionApiKeyRegistration(ctx, req.(*DeletePredictionApiKeyRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PredictionApiKeyRegistry_ServiceDesc is the grpc.ServiceDesc for PredictionApiKeyRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PredictionApiKeyRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry",
	HandlerType: (*PredictionApiKeyRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePredictionApiKeyRegistration",
			Handler:    _PredictionApiKeyRegistry_CreatePredictionApiKeyRegistration_Handler,
		},
		{
			MethodName: "ListPredictionApiKeyRegistrations",
			Handler:    _PredictionApiKeyRegistry_ListPredictionApiKeyRegistrations_Handler,
		},
		{
			MethodName: "DeletePredictionApiKeyRegistration",
			Handler:    _PredictionApiKeyRegistry_DeletePredictionApiKeyRegistration_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommendationengine/v1beta1/prediction_apikey_registry_service.proto",
}
