// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v5.29.3
// source: api.proto

package v3

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// System identifies a package management system.
type System int32

const (
	System_SYSTEM_UNSPECIFIED System = 0
	System_GO                 System = 1
	System_RUBYGEMS           System = 2
	System_NPM                System = 3
	System_CARGO              System = 4
	System_MAVEN              System = 6
	System_PYPI               System = 7
	System_NUGET              System = 8
)

// Enum value maps for System.
var (
	System_name = map[int32]string{
		0: "SYSTEM_UNSPECIFIED",
		1: "GO",
		2: "RUBYGEMS",
		3: "NPM",
		4: "CARGO",
		6: "MAVEN",
		7: "PYPI",
		8: "NUGET",
	}
	System_value = map[string]int32{
		"SYSTEM_UNSPECIFIED": 0,
		"GO":                 1,
		"RUBYGEMS":           2,
		"NPM":                3,
		"CARGO":              4,
		"MAVEN":              6,
		"PYPI":               7,
		"NUGET":              8,
	}
)

func (x System) Enum() *System {
	p := new(System)
	*p = x
	return p
}

func (x System) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (System) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[0].Descriptor()
}

func (System) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[0]
}

func (x System) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use System.Descriptor instead.
func (System) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{0}
}

// HashType identifies a function used to produce a hash.
type HashType int32

const (
	HashType_HASH_TYPE_UNSPECIFIED HashType = 0
	HashType_MD5                   HashType = 1
	HashType_SHA1                  HashType = 2
	HashType_SHA256                HashType = 3
	HashType_SHA512                HashType = 4
)

// Enum value maps for HashType.
var (
	HashType_name = map[int32]string{
		0: "HASH_TYPE_UNSPECIFIED",
		1: "MD5",
		2: "SHA1",
		3: "SHA256",
		4: "SHA512",
	}
	HashType_value = map[string]int32{
		"HASH_TYPE_UNSPECIFIED": 0,
		"MD5":                   1,
		"SHA1":                  2,
		"SHA256":                3,
		"SHA512":                4,
	}
)

func (x HashType) Enum() *HashType {
	p := new(HashType)
	*p = x
	return p
}

func (x HashType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HashType) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[1].Descriptor()
}

func (HashType) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[1]
}

func (x HashType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HashType.Descriptor instead.
func (HashType) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{1}
}

// DependencyRelation describes the relation of a node within a dependency
// graph.
type DependencyRelation int32

const (
	DependencyRelation_DEPENDENCY_RELATION_UNSPECIFIED DependencyRelation = 0
	DependencyRelation_SELF                            DependencyRelation = 1
	DependencyRelation_DIRECT                          DependencyRelation = 2
	DependencyRelation_INDIRECT                        DependencyRelation = 3
)

// Enum value maps for DependencyRelation.
var (
	DependencyRelation_name = map[int32]string{
		0: "DEPENDENCY_RELATION_UNSPECIFIED",
		1: "SELF",
		2: "DIRECT",
		3: "INDIRECT",
	}
	DependencyRelation_value = map[string]int32{
		"DEPENDENCY_RELATION_UNSPECIFIED": 0,
		"SELF":                            1,
		"DIRECT":                          2,
		"INDIRECT":                        3,
	}
)

func (x DependencyRelation) Enum() *DependencyRelation {
	p := new(DependencyRelation)
	*p = x
	return p
}

func (x DependencyRelation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DependencyRelation) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[2].Descriptor()
}

func (DependencyRelation) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[2]
}

func (x DependencyRelation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DependencyRelation.Descriptor instead.
func (DependencyRelation) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{2}
}

// ProjectRelationType specifies a relationship between a project and a package version.
type ProjectRelationType int32

const (
	ProjectRelationType_UNKNOWN_PROJECT_RELATION_TYPE ProjectRelationType = 0
	// This project is this package version's source code repository.
	ProjectRelationType_SOURCE_REPO ProjectRelationType = 1
	// This project is the package version's issue tracker.
	ProjectRelationType_ISSUE_TRACKER ProjectRelationType = 2
)

// Enum value maps for ProjectRelationType.
var (
	ProjectRelationType_name = map[int32]string{
		0: "UNKNOWN_PROJECT_RELATION_TYPE",
		1: "SOURCE_REPO",
		2: "ISSUE_TRACKER",
	}
	ProjectRelationType_value = map[string]int32{
		"UNKNOWN_PROJECT_RELATION_TYPE": 0,
		"SOURCE_REPO":                   1,
		"ISSUE_TRACKER":                 2,
	}
)

func (x ProjectRelationType) Enum() *ProjectRelationType {
	p := new(ProjectRelationType)
	*p = x
	return p
}

func (x ProjectRelationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProjectRelationType) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[3].Descriptor()
}

func (ProjectRelationType) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[3]
}

func (x ProjectRelationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProjectRelationType.Descriptor instead.
func (ProjectRelationType) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{3}
}

// How the mapping between project and package version was discovered.
type ProjectRelationProvenance int32

const (
	ProjectRelationProvenance_UNKNOWN_PROJECT_RELATION_PROVENANCE ProjectRelationProvenance = 0
	// There is a SLSA attestation that links this package version to this project.
	ProjectRelationProvenance_SLSA_ATTESTATION ProjectRelationProvenance = 1
	// This project contains the package version (Go specific).
	ProjectRelationProvenance_GO_ORIGIN ProjectRelationProvenance = 2
	// There is a [PyPI Publish
	// attestation](https://docs.pypi.org/attestations/publish/v1/) that links
	// this package version to this project.
	ProjectRelationProvenance_PYPI_PUBLISH_ATTESTATION ProjectRelationProvenance = 3
	// The package version's metadata contains an unverified link to this project.
	ProjectRelationProvenance_UNVERIFIED_METADATA ProjectRelationProvenance = 10
)

// Enum value maps for ProjectRelationProvenance.
var (
	ProjectRelationProvenance_name = map[int32]string{
		0:  "UNKNOWN_PROJECT_RELATION_PROVENANCE",
		1:  "SLSA_ATTESTATION",
		2:  "GO_ORIGIN",
		3:  "PYPI_PUBLISH_ATTESTATION",
		10: "UNVERIFIED_METADATA",
	}
	ProjectRelationProvenance_value = map[string]int32{
		"UNKNOWN_PROJECT_RELATION_PROVENANCE": 0,
		"SLSA_ATTESTATION":                    1,
		"GO_ORIGIN":                           2,
		"PYPI_PUBLISH_ATTESTATION":            3,
		"UNVERIFIED_METADATA":                 10,
	}
)

func (x ProjectRelationProvenance) Enum() *ProjectRelationProvenance {
	p := new(ProjectRelationProvenance)
	*p = x
	return p
}

func (x ProjectRelationProvenance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProjectRelationProvenance) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[4].Descriptor()
}

func (ProjectRelationProvenance) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[4]
}

func (x ProjectRelationProvenance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProjectRelationProvenance.Descriptor instead.
func (ProjectRelationProvenance) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{4}
}

// PackageKey identifies a package by name.
type PackageKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The package management system containing the package.
	System System `protobuf:"varint,1,opt,name=system,proto3,enum=deps_dev.v3.System" json:"system,omitempty"`
	// The name of the package.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *PackageKey) Reset() {
	*x = PackageKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageKey) ProtoMessage() {}

func (x *PackageKey) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageKey.ProtoReflect.Descriptor instead.
func (*PackageKey) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{0}
}

func (x *PackageKey) GetSystem() System {
	if x != nil {
		return x.System
	}
	return System_SYSTEM_UNSPECIFIED
}

func (x *PackageKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// VersionKey identifies a package version by name.
type VersionKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The package management system containing the package.
	System System `protobuf:"varint,1,opt,name=system,proto3,enum=deps_dev.v3.System" json:"system,omitempty"`
	// The name of the package.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the package.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *VersionKey) Reset() {
	*x = VersionKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionKey) ProtoMessage() {}

func (x *VersionKey) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionKey.ProtoReflect.Descriptor instead.
func (*VersionKey) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{1}
}

func (x *VersionKey) GetSystem() System {
	if x != nil {
		return x.System
	}
	return System_SYSTEM_UNSPECIFIED
}

func (x *VersionKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VersionKey) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// ProjectKey identifies a project.
type ProjectKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A project identifier of the form `github.com/user/repo`,
	// `gitlab.com/user/repo`, or `bitbucket.org/user/repo`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ProjectKey) Reset() {
	*x = ProjectKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectKey) ProtoMessage() {}

func (x *ProjectKey) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectKey.ProtoReflect.Descriptor instead.
func (*ProjectKey) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{2}
}

func (x *ProjectKey) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// AdvisoryKey identifies a security advisory.
type AdvisoryKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OSV identifier for the security advisory.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *AdvisoryKey) Reset() {
	*x = AdvisoryKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvisoryKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvisoryKey) ProtoMessage() {}

func (x *AdvisoryKey) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvisoryKey.ProtoReflect.Descriptor instead.
func (*AdvisoryKey) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{3}
}

func (x *AdvisoryKey) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Hash represents the output of a hash function. These messages are used to
// identify package version artifacts by content hash.
type Hash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The function used to produce this hash.
	Type HashType `protobuf:"varint,1,opt,name=type,proto3,enum=deps_dev.v3.HashType" json:"type,omitempty"`
	// A hash value.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Hash) Reset() {
	*x = Hash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Hash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hash) ProtoMessage() {}

func (x *Hash) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hash.ProtoReflect.Descriptor instead.
func (*Hash) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{4}
}

func (x *Hash) GetType() HashType {
	if x != nil {
		return x.Type
	}
	return HashType_HASH_TYPE_UNSPECIFIED
}

func (x *Hash) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// Link represents a link declared by or derived from package version metadata,
// to an external web resource such as a homepage or source code repository.
type Link struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A label describing the resource that the link points to.
	Label string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	// The URL of the link.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *Link) Reset() {
	*x = Link{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Link) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Link) ProtoMessage() {}

func (x *Link) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Link.ProtoReflect.Descriptor instead.
func (*Link) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{5}
}

func (x *Link) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *Link) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// SLSAProvenance contains provenance information extracted from a SLSA
// provenance statement.
type SLSAProvenance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source code repository used to build the version.
	SourceRepository string `protobuf:"bytes,1,opt,name=source_repository,json=sourceRepository,proto3" json:"source_repository,omitempty"`
	// The commit of the source code repository the version was built from.
	Commit string `protobuf:"bytes,2,opt,name=commit,proto3" json:"commit,omitempty"`
	// The URL of the provenance statement if there is one.
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// The Sigstore bundle containing this attestation was verified using the
	// [sigstore-go](https://github.com/sigstore/sigstore-go) library.
	Verified bool `protobuf:"varint,4,opt,name=verified,proto3" json:"verified,omitempty"`
}

func (x *SLSAProvenance) Reset() {
	*x = SLSAProvenance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SLSAProvenance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SLSAProvenance) ProtoMessage() {}

func (x *SLSAProvenance) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SLSAProvenance.ProtoReflect.Descriptor instead.
func (*SLSAProvenance) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{6}
}

func (x *SLSAProvenance) GetSourceRepository() string {
	if x != nil {
		return x.SourceRepository
	}
	return ""
}

func (x *SLSAProvenance) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

func (x *SLSAProvenance) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *SLSAProvenance) GetVerified() bool {
	if x != nil {
		return x.Verified
	}
	return false
}

// Attestation represents a generic attestation. Fields are populated based
// on 'type'.
type Attestation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of attestation.
	// One of https://slsa.dev/provenance/v0.2, https://slsa.dev/provenance/v1,
	// https://docs.pypi.org/attestations/publish/v1.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The URL of the attestation if there is one.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// The attestation has been cryptographically verified by deps.dev.
	// For attestations distributed in a Sigstore bundle, this field indicates
	// the bundle was verified using the
	// [sigstore-go](https://github.com/sigstore/sigstore-go) library.
	Verified bool `protobuf:"varint,3,opt,name=verified,proto3" json:"verified,omitempty"`
	// Only set if type is https://slsa.dev/provenance/v0.2,
	// https://slsa.dev/provenance/v1,
	// https://docs.pypi.org/attestations/publish/v1.
	// The source code repository used to build the version.
	SourceRepository string `protobuf:"bytes,4,opt,name=source_repository,json=sourceRepository,proto3" json:"source_repository,omitempty"`
	// The commit of the source code repository the version was built from.
	Commit string `protobuf:"bytes,5,opt,name=commit,proto3" json:"commit,omitempty"`
}

func (x *Attestation) Reset() {
	*x = Attestation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Attestation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attestation) ProtoMessage() {}

func (x *Attestation) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attestation.ProtoReflect.Descriptor instead.
func (*Attestation) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{7}
}

func (x *Attestation) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Attestation) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Attestation) GetVerified() bool {
	if x != nil {
		return x.Verified
	}
	return false
}

func (x *Attestation) GetSourceRepository() string {
	if x != nil {
		return x.SourceRepository
	}
	return ""
}

func (x *Attestation) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

// GetPackageRequest identifies a package for which to return information.
type GetPackageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PackageKey *PackageKey `protobuf:"bytes,1,opt,name=package_key,json=packageKey,proto3" json:"package_key,omitempty"`
}

func (x *GetPackageRequest) Reset() {
	*x = GetPackageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPackageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPackageRequest) ProtoMessage() {}

func (x *GetPackageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPackageRequest.ProtoReflect.Descriptor instead.
func (*GetPackageRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{8}
}

func (x *GetPackageRequest) GetPackageKey() *PackageKey {
	if x != nil {
		return x.PackageKey
	}
	return nil
}

// Package holds information about a package, including a list of its available
// versions, with the default version marked if known.
type Package struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package. Note that it may differ from the name in the
	// request, due to canonicalization.
	PackageKey *PackageKey `protobuf:"bytes,1,opt,name=package_key,json=packageKey,proto3" json:"package_key,omitempty"`
	// The available versions of the package.
	Versions []*Package_Version `protobuf:"bytes,2,rep,name=versions,proto3" json:"versions,omitempty"`
}

func (x *Package) Reset() {
	*x = Package{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package) ProtoMessage() {}

func (x *Package) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package.ProtoReflect.Descriptor instead.
func (*Package) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{9}
}

func (x *Package) GetPackageKey() *PackageKey {
	if x != nil {
		return x.PackageKey
	}
	return nil
}

func (x *Package) GetVersions() []*Package_Version {
	if x != nil {
		return x.Versions
	}
	return nil
}

// GetVersionRequest identifies a package version for which to return information.
type GetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VersionKey *VersionKey `protobuf:"bytes,1,opt,name=version_key,json=versionKey,proto3" json:"version_key,omitempty"`
}

func (x *GetVersionRequest) Reset() {
	*x = GetVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVersionRequest) ProtoMessage() {}

func (x *GetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVersionRequest.ProtoReflect.Descriptor instead.
func (*GetVersionRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{10}
}

func (x *GetVersionRequest) GetVersionKey() *VersionKey {
	if x != nil {
		return x.VersionKey
	}
	return nil
}

// Version holds information about a package version.
type Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package version. Note that the package and version name
	// may differ from names specified in requests, if applicable, due to
	// canonicalization.
	VersionKey *VersionKey `protobuf:"bytes,1,opt,name=version_key,json=versionKey,proto3" json:"version_key,omitempty"`
	// The time when this package version was published, if available, as
	// reported by the package management authority.
	PublishedAt *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=published_at,json=publishedAt,proto3" json:"published_at,omitempty"`
	// If true, this is the default version of the package: the version that is
	// installed when no version is specified. The precise meaning of this is
	// system-specific, but it is commonly the version with the greatest version
	// number, ignoring pre-release versions.
	IsDefault bool `protobuf:"varint,2,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// The licenses governing the use of this package version.
	//
	// We identify licenses as
	// [SPDX 2.1](https://spdx.dev/spdx-specification-21-web-version/)
	// expressions. When there is no associated SPDX identifier, we identify a
	// license as "non-standard". When we are unable to obtain license
	// information, this field is empty. When more than one license is listed,
	// their relationship is unspecified.
	//
	// For Cargo, Maven, npm, NuGet, PyPI, and RubyGems, license information is
	// read from the package metadata. For Go, license information is determined
	// using the [licensecheck](https://github.com/google/licensecheck) package.
	//
	// License information is not intended to be legal advice, and you should
	// independently verify the license or terms of any software for your own
	// needs.
	Licenses []string `protobuf:"bytes,3,rep,name=licenses,proto3" json:"licenses,omitempty"`
	// Security advisories known to affect this package version directly. Further
	// information can be requested using the Advisory method.
	//
	// Note that this field does not include advisories that affect dependencies
	// of this package version.
	AdvisoryKeys []*AdvisoryKey `protobuf:"bytes,4,rep,name=advisory_keys,json=advisoryKeys,proto3" json:"advisory_keys,omitempty"`
	// Links declared by or derived from package version metadata, to external
	// web resources such as a homepage or source code repository. Note that
	// these links are not verified for correctness.
	Links []*Link `protobuf:"bytes,5,rep,name=links,proto3" json:"links,omitempty"`
	// SLSA provenance information for this package version. Extracted from a
	// SLSA provenance attestation. This is only populated for npm package
	// versions. See the 'attestations' field for more attestations (including
	// SLSA provenance) for all systems.
	SlsaProvenances []*SLSAProvenance `protobuf:"bytes,7,rep,name=slsa_provenances,json=slsaProvenances,proto3" json:"slsa_provenances,omitempty"`
	// Attestations for this package version.
	Attestations []*Attestation `protobuf:"bytes,14,rep,name=attestations,proto3" json:"attestations,omitempty"`
	// URLs for the package management registries this package version is
	// available from.
	// Only set for systems that use a central repository for package
	// distribution: Cargo, Maven, npm, NuGet, PyPI and RubyGems.
	Registries []string `protobuf:"bytes,8,rep,name=registries,proto3" json:"registries,omitempty"`
	// Projects that are related to this package version.
	RelatedProjects []*Version_Project `protobuf:"bytes,10,rep,name=related_projects,json=relatedProjects,proto3" json:"related_projects,omitempty"`
}

func (x *Version) Reset() {
	*x = Version{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Version) ProtoMessage() {}

func (x *Version) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Version.ProtoReflect.Descriptor instead.
func (*Version) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{11}
}

func (x *Version) GetVersionKey() *VersionKey {
	if x != nil {
		return x.VersionKey
	}
	return nil
}

func (x *Version) GetPublishedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishedAt
	}
	return nil
}

func (x *Version) GetIsDefault() bool {
	if x != nil {
		return x.IsDefault
	}
	return false
}

func (x *Version) GetLicenses() []string {
	if x != nil {
		return x.Licenses
	}
	return nil
}

func (x *Version) GetAdvisoryKeys() []*AdvisoryKey {
	if x != nil {
		return x.AdvisoryKeys
	}
	return nil
}

func (x *Version) GetLinks() []*Link {
	if x != nil {
		return x.Links
	}
	return nil
}

func (x *Version) GetSlsaProvenances() []*SLSAProvenance {
	if x != nil {
		return x.SlsaProvenances
	}
	return nil
}

func (x *Version) GetAttestations() []*Attestation {
	if x != nil {
		return x.Attestations
	}
	return nil
}

func (x *Version) GetRegistries() []string {
	if x != nil {
		return x.Registries
	}
	return nil
}

func (x *Version) GetRelatedProjects() []*Version_Project {
	if x != nil {
		return x.RelatedProjects
	}
	return nil
}

// GetRequirementsRequest identifies a version for which to return
// requirements.
type GetRequirementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VersionKey *VersionKey `protobuf:"bytes,1,opt,name=version_key,json=versionKey,proto3" json:"version_key,omitempty"`
}

func (x *GetRequirementsRequest) Reset() {
	*x = GetRequirementsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRequirementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRequirementsRequest) ProtoMessage() {}

func (x *GetRequirementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRequirementsRequest.ProtoReflect.Descriptor instead.
func (*GetRequirementsRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{12}
}

func (x *GetRequirementsRequest) GetVersionKey() *VersionKey {
	if x != nil {
		return x.VersionKey
	}
	return nil
}

// Requirements contains a system-specific representation of the requirements
// specified by a package version. Only one of its fields will be set.
type Requirements struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The NuGet-specific representation of the version's requirements.
	//
	// Note that the term "dependency" is used here to mean "a single unresolved
	// requirement" to be consistent with how the term is used in the NuGet
	// ecosystem. This is different to how it is used elsewhere in the deps.dev
	// API.
	Nuget *Requirements_NuGet `protobuf:"bytes,1,opt,name=nuget,proto3" json:"nuget,omitempty"`
	// The npm-specific representation of the version's requirements.
	//
	// Note that the term "dependency" is used here to mean "a single unresolved
	// requirement" to be consistent with how the term is used in the npm
	// ecosystem. This is different to how it is used elsewhere in the deps.dev
	// API.
	Npm *Requirements_NPM `protobuf:"bytes,2,opt,name=npm,proto3" json:"npm,omitempty"`
	// The Maven-specific representation of the version's requirements.
	//
	// Note that the term "dependency" is used here to mean "a single unresolved
	// requirement" to be consistent with how the term is used in the Maven
	// ecosystem. This is different to how it is used elsewhere in the deps.dev
	// API.
	//
	// This data is as it is declared in a version POM file. The data in parent
	// POMs are not merged.
	// Any string field may contain references to properties, and the properties
	// are not interpolated.
	Maven *Requirements_Maven `protobuf:"bytes,3,opt,name=maven,proto3" json:"maven,omitempty"`
	// The RubyGems-specific representation of the version's requirements.
	//
	// Note that the term "dependency" is used here to mean "a single unresolved
	// requirement" to be consistent with how the term is used in the npm
	// ecosystem. This is different to how it is used elsewhere in the deps.dev
	// API.
	Rubygems *Requirements_RubyGems `protobuf:"bytes,4,opt,name=rubygems,proto3" json:"rubygems,omitempty"`
}

func (x *Requirements) Reset() {
	*x = Requirements{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements) ProtoMessage() {}

func (x *Requirements) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements.ProtoReflect.Descriptor instead.
func (*Requirements) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13}
}

func (x *Requirements) GetNuget() *Requirements_NuGet {
	if x != nil {
		return x.Nuget
	}
	return nil
}

func (x *Requirements) GetNpm() *Requirements_NPM {
	if x != nil {
		return x.Npm
	}
	return nil
}

func (x *Requirements) GetMaven() *Requirements_Maven {
	if x != nil {
		return x.Maven
	}
	return nil
}

func (x *Requirements) GetRubygems() *Requirements_RubyGems {
	if x != nil {
		return x.Rubygems
	}
	return nil
}

// GetDependenciesRequest identifies a package version for which to return
// dependencies.
type GetDependenciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VersionKey *VersionKey `protobuf:"bytes,1,opt,name=version_key,json=versionKey,proto3" json:"version_key,omitempty"`
}

func (x *GetDependenciesRequest) Reset() {
	*x = GetDependenciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDependenciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDependenciesRequest) ProtoMessage() {}

func (x *GetDependenciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDependenciesRequest.ProtoReflect.Descriptor instead.
func (*GetDependenciesRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{14}
}

func (x *GetDependenciesRequest) GetVersionKey() *VersionKey {
	if x != nil {
		return x.VersionKey
	}
	return nil
}

// Dependencies holds a resolved dependency graph for a package version.
//
// The dependency graph should be similar to one produced by installing the
// package version on a generic 64-bit Linux system, with no other dependencies
// present. The precise meaning of this varies from system to system.
type Dependencies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The nodes of the dependency graph. The first node is the root of the graph.
	Nodes []*Dependencies_Node `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// The edges of the dependency graph.
	Edges []*Dependencies_Edge `protobuf:"bytes,2,rep,name=edges,proto3" json:"edges,omitempty"`
	// Any error associated with the dependency graph that is not specific to a
	// node. An error here may imply the graph as a whole is incorrect.
	// This error message has no defined format and is intended for human
	// consumption.
	Error string `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Dependencies) Reset() {
	*x = Dependencies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dependencies) ProtoMessage() {}

func (x *Dependencies) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dependencies.ProtoReflect.Descriptor instead.
func (*Dependencies) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{15}
}

func (x *Dependencies) GetNodes() []*Dependencies_Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

func (x *Dependencies) GetEdges() []*Dependencies_Edge {
	if x != nil {
		return x.Edges
	}
	return nil
}

func (x *Dependencies) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// GetProjectRequest identifies a project for which to return information.
type GetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProjectKey *ProjectKey `protobuf:"bytes,1,opt,name=project_key,json=projectKey,proto3" json:"project_key,omitempty"`
}

func (x *GetProjectRequest) Reset() {
	*x = GetProjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProjectRequest) ProtoMessage() {}

func (x *GetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProjectRequest.ProtoReflect.Descriptor instead.
func (*GetProjectRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{16}
}

func (x *GetProjectRequest) GetProjectKey() *ProjectKey {
	if x != nil {
		return x.ProjectKey
	}
	return nil
}

// Project holds information about a project hosted by GitHub, GitLab, or
// Bitbucket.
type Project struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier for the project. Note that this may differ from the
	// identifier in the request, due to canonicalization.
	ProjectKey *ProjectKey `protobuf:"bytes,1,opt,name=project_key,json=projectKey,proto3" json:"project_key,omitempty"`
	// The number of open issues reported by the project host.
	// Only available for GitHub and GitLab.
	OpenIssuesCount int32 `protobuf:"varint,2,opt,name=open_issues_count,json=openIssuesCount,proto3" json:"open_issues_count,omitempty"`
	// The number of stars reported by the project host.
	// Only available for GitHub and GitLab.
	StarsCount int32 `protobuf:"varint,3,opt,name=stars_count,json=starsCount,proto3" json:"stars_count,omitempty"`
	// The number of forks reported by the project host.
	// Only available for GitHub and GitLab.
	ForksCount int32 `protobuf:"varint,4,opt,name=forks_count,json=forksCount,proto3" json:"forks_count,omitempty"`
	// The license reported by the project host.
	License string `protobuf:"bytes,5,opt,name=license,proto3" json:"license,omitempty"`
	// The description reported by the project host.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// The homepage reported by the project host.
	Homepage string `protobuf:"bytes,7,opt,name=homepage,proto3" json:"homepage,omitempty"`
	// An [OpenSSF Scorecard](https://github.com/ossf/scorecard) for the project,
	// if one is available.
	Scorecard *Project_Scorecard `protobuf:"bytes,8,opt,name=scorecard,proto3" json:"scorecard,omitempty"`
	// Details of this project's testing by the
	// [OSS-Fuzz service](https://google.github.io/oss-fuzz/).
	// Only set if the project is tested by OSS-Fuzz.
	OssFuzz *Project_OSSFuzzDetails `protobuf:"bytes,9,opt,name=oss_fuzz,json=ossFuzz,proto3" json:"oss_fuzz,omitempty"`
}

func (x *Project) Reset() {
	*x = Project{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Project) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Project) ProtoMessage() {}

func (x *Project) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Project.ProtoReflect.Descriptor instead.
func (*Project) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{17}
}

func (x *Project) GetProjectKey() *ProjectKey {
	if x != nil {
		return x.ProjectKey
	}
	return nil
}

func (x *Project) GetOpenIssuesCount() int32 {
	if x != nil {
		return x.OpenIssuesCount
	}
	return 0
}

func (x *Project) GetStarsCount() int32 {
	if x != nil {
		return x.StarsCount
	}
	return 0
}

func (x *Project) GetForksCount() int32 {
	if x != nil {
		return x.ForksCount
	}
	return 0
}

func (x *Project) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

func (x *Project) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Project) GetHomepage() string {
	if x != nil {
		return x.Homepage
	}
	return ""
}

func (x *Project) GetScorecard() *Project_Scorecard {
	if x != nil {
		return x.Scorecard
	}
	return nil
}

func (x *Project) GetOssFuzz() *Project_OSSFuzzDetails {
	if x != nil {
		return x.OssFuzz
	}
	return nil
}

type GetProjectPackageVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProjectKey *ProjectKey `protobuf:"bytes,1,opt,name=project_key,json=projectKey,proto3" json:"project_key,omitempty"`
}

func (x *GetProjectPackageVersionsRequest) Reset() {
	*x = GetProjectPackageVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProjectPackageVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProjectPackageVersionsRequest) ProtoMessage() {}

func (x *GetProjectPackageVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProjectPackageVersionsRequest.ProtoReflect.Descriptor instead.
func (*GetProjectPackageVersionsRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{18}
}

func (x *GetProjectPackageVersionsRequest) GetProjectKey() *ProjectKey {
	if x != nil {
		return x.ProjectKey
	}
	return nil
}

type ProjectPackageVersions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The versions that were built from the source code contained in this
	// project.
	Versions []*ProjectPackageVersions_Version `protobuf:"bytes,1,rep,name=versions,proto3" json:"versions,omitempty"`
}

func (x *ProjectPackageVersions) Reset() {
	*x = ProjectPackageVersions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectPackageVersions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectPackageVersions) ProtoMessage() {}

func (x *ProjectPackageVersions) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectPackageVersions.ProtoReflect.Descriptor instead.
func (*ProjectPackageVersions) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{19}
}

func (x *ProjectPackageVersions) GetVersions() []*ProjectPackageVersions_Version {
	if x != nil {
		return x.Versions
	}
	return nil
}

// GetAdvisoryRequest identifies a security advisory for which to return
// information.
type GetAdvisoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AdvisoryKey *AdvisoryKey `protobuf:"bytes,1,opt,name=advisory_key,json=advisoryKey,proto3" json:"advisory_key,omitempty"`
}

func (x *GetAdvisoryRequest) Reset() {
	*x = GetAdvisoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAdvisoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAdvisoryRequest) ProtoMessage() {}

func (x *GetAdvisoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAdvisoryRequest.ProtoReflect.Descriptor instead.
func (*GetAdvisoryRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{20}
}

func (x *GetAdvisoryRequest) GetAdvisoryKey() *AdvisoryKey {
	if x != nil {
		return x.AdvisoryKey
	}
	return nil
}

// Advisory holds information about a security advisory hosted by OSV.
type Advisory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier for the security advisory. Note that this may differ from
	// the identifier in the request, due to canonicalization.
	AdvisoryKey *AdvisoryKey `protobuf:"bytes,1,opt,name=advisory_key,json=advisoryKey,proto3" json:"advisory_key,omitempty"`
	// The URL of the security advisory.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// A brief human-readable description.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// Other identifiers used for the advisory, including CVEs.
	Aliases []string `protobuf:"bytes,4,rep,name=aliases,proto3" json:"aliases,omitempty"`
	// The severity of the advisory as a CVSS v3 score in the range [0,10].
	// A higher score represents greater severity.
	Cvss3Score float32 `protobuf:"fixed32,5,opt,name=cvss3_score,json=cvss3Score,proto3" json:"cvss3_score,omitempty"`
	// The severity of the advisory as a CVSS v3 vector string.
	Cvss3Vector string `protobuf:"bytes,6,opt,name=cvss3_vector,json=cvss3Vector,proto3" json:"cvss3_vector,omitempty"`
}

func (x *Advisory) Reset() {
	*x = Advisory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Advisory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Advisory) ProtoMessage() {}

func (x *Advisory) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Advisory.ProtoReflect.Descriptor instead.
func (*Advisory) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{21}
}

func (x *Advisory) GetAdvisoryKey() *AdvisoryKey {
	if x != nil {
		return x.AdvisoryKey
	}
	return nil
}

func (x *Advisory) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Advisory) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Advisory) GetAliases() []string {
	if x != nil {
		return x.Aliases
	}
	return nil
}

func (x *Advisory) GetCvss3Score() float32 {
	if x != nil {
		return x.Cvss3Score
	}
	return 0
}

func (x *Advisory) GetCvss3Vector() string {
	if x != nil {
		return x.Cvss3Vector
	}
	return ""
}

// QueryRequest identifies package versions for which to return information.
// At least one of its fields must be set, and both fields may be set to narrow
// the results.
type QueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A content hash for an artifact associated with a package version, such as a
	// JAR file. Currently supported for npm, Cargo, Maven, and NuGet. Note that
	// hashes and package versions have a many-to-many relationship.
	Hash *Hash `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	// The name of the package version.
	VersionKey *VersionKey `protobuf:"bytes,2,opt,name=version_key,json=versionKey,proto3" json:"version_key,omitempty"`
}

func (x *QueryRequest) Reset() {
	*x = QueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRequest) ProtoMessage() {}

func (x *QueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRequest.ProtoReflect.Descriptor instead.
func (*QueryRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{22}
}

func (x *QueryRequest) GetHash() *Hash {
	if x != nil {
		return x.Hash
	}
	return nil
}

func (x *QueryRequest) GetVersionKey() *VersionKey {
	if x != nil {
		return x.VersionKey
	}
	return nil
}

// QueryResult holds information about package versions matching the query.
type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results matching the query. At most 1000 results are returned.
	Results []*QueryResult_Result `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{23}
}

func (x *QueryResult) GetResults() []*QueryResult_Result {
	if x != nil {
		return x.Results
	}
	return nil
}

type Package_Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the version. Note that the package name may differ from the
	// name in the request, due to canonicalization.
	VersionKey *VersionKey `protobuf:"bytes,1,opt,name=version_key,json=versionKey,proto3" json:"version_key,omitempty"`
	// The time when this package version was published, if available, as
	// reported by the package management authority.
	PublishedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=published_at,json=publishedAt,proto3" json:"published_at,omitempty"`
	// If true, this is the default version of the package: the version that is
	// installed when no version is specified. The precise meaning of this is
	// system-specific, but it is commonly the version with the greatest
	// version number, ignoring pre-release versions.
	IsDefault bool `protobuf:"varint,2,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
}

func (x *Package_Version) Reset() {
	*x = Package_Version{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Package_Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package_Version) ProtoMessage() {}

func (x *Package_Version) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package_Version.ProtoReflect.Descriptor instead.
func (*Package_Version) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{9, 0}
}

func (x *Package_Version) GetVersionKey() *VersionKey {
	if x != nil {
		return x.VersionKey
	}
	return nil
}

func (x *Package_Version) GetPublishedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishedAt
	}
	return nil
}

func (x *Package_Version) GetIsDefault() bool {
	if x != nil {
		return x.IsDefault
	}
	return false
}

type Version_Project struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier for the project.
	ProjectKey *ProjectKey `protobuf:"bytes,1,opt,name=project_key,json=projectKey,proto3" json:"project_key,omitempty"`
	// How the mapping between project and package version was discovered.
	RelationProvenance ProjectRelationProvenance `protobuf:"varint,2,opt,name=relation_provenance,json=relationProvenance,proto3,enum=deps_dev.v3.ProjectRelationProvenance" json:"relation_provenance,omitempty"`
	// What the relationship between the project and the package version is.
	RelationType ProjectRelationType `protobuf:"varint,3,opt,name=relation_type,json=relationType,proto3,enum=deps_dev.v3.ProjectRelationType" json:"relation_type,omitempty"`
}

func (x *Version_Project) Reset() {
	*x = Version_Project{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Version_Project) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Version_Project) ProtoMessage() {}

func (x *Version_Project) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Version_Project.ProtoReflect.Descriptor instead.
func (*Version_Project) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{11, 0}
}

func (x *Version_Project) GetProjectKey() *ProjectKey {
	if x != nil {
		return x.ProjectKey
	}
	return nil
}

func (x *Version_Project) GetRelationProvenance() ProjectRelationProvenance {
	if x != nil {
		return x.RelationProvenance
	}
	return ProjectRelationProvenance_UNKNOWN_PROJECT_RELATION_PROVENANCE
}

func (x *Version_Project) GetRelationType() ProjectRelationType {
	if x != nil {
		return x.RelationType
	}
	return ProjectRelationType_UNKNOWN_PROJECT_RELATION_TYPE
}

type Requirements_NuGet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requirements grouped by target framework.
	DependencyGroups []*Requirements_NuGet_DependencyGroup `protobuf:"bytes,1,rep,name=dependency_groups,json=dependencyGroups,proto3" json:"dependency_groups,omitempty"`
}

func (x *Requirements_NuGet) Reset() {
	*x = Requirements_NuGet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_NuGet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_NuGet) ProtoMessage() {}

func (x *Requirements_NuGet) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_NuGet.ProtoReflect.Descriptor instead.
func (*Requirements_NuGet) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 0}
}

func (x *Requirements_NuGet) GetDependencyGroups() []*Requirements_NuGet_DependencyGroup {
	if x != nil {
		return x.DependencyGroups
	}
	return nil
}

type Requirements_NPM struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dependency-related fields declared in the requested package version's
	// package.json.
	Dependencies *Requirements_NPM_Dependencies `protobuf:"bytes,1,opt,name=dependencies,proto3" json:"dependencies,omitempty"`
	// Contents of any additional package.json files found inside the
	// "node_modules" folder of the version's tarball, including nested
	// "node_modules".
	Bundled []*Requirements_NPM_Bundle `protobuf:"bytes,2,rep,name=bundled,proto3" json:"bundled,omitempty"`
}

func (x *Requirements_NPM) Reset() {
	*x = Requirements_NPM{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_NPM) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_NPM) ProtoMessage() {}

func (x *Requirements_NPM) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_NPM.ProtoReflect.Descriptor instead.
func (*Requirements_NPM) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 1}
}

func (x *Requirements_NPM) GetDependencies() *Requirements_NPM_Dependencies {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *Requirements_NPM) GetBundled() []*Requirements_NPM_Bundle {
	if x != nil {
		return x.Bundled
	}
	return nil
}

type Requirements_Maven struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The direct parent of a package version.
	Parent *VersionKey `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The list of dependencies.
	Dependencies []*Requirements_Maven_Dependency `protobuf:"bytes,2,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// The list of dependency management.
	// The format is the same as dependencies.
	DependencyManagement []*Requirements_Maven_Dependency `protobuf:"bytes,3,rep,name=dependency_management,json=dependencyManagement,proto3" json:"dependency_management,omitempty"`
	// The list of properties, used to resolve placeholders.
	Properties []*Requirements_Maven_Property `protobuf:"bytes,4,rep,name=properties,proto3" json:"properties,omitempty"`
	// The list of repositories.
	Repositories []*Requirements_Maven_Repository `protobuf:"bytes,5,rep,name=repositories,proto3" json:"repositories,omitempty"`
	// The list of profiles.
	Profiles []*Requirements_Maven_Profile `protobuf:"bytes,6,rep,name=profiles,proto3" json:"profiles,omitempty"`
}

func (x *Requirements_Maven) Reset() {
	*x = Requirements_Maven{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven) ProtoMessage() {}

func (x *Requirements_Maven) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven.ProtoReflect.Descriptor instead.
func (*Requirements_Maven) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2}
}

func (x *Requirements_Maven) GetParent() *VersionKey {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *Requirements_Maven) GetDependencies() []*Requirements_Maven_Dependency {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *Requirements_Maven) GetDependencyManagement() []*Requirements_Maven_Dependency {
	if x != nil {
		return x.DependencyManagement
	}
	return nil
}

func (x *Requirements_Maven) GetProperties() []*Requirements_Maven_Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Requirements_Maven) GetRepositories() []*Requirements_Maven_Repository {
	if x != nil {
		return x.Repositories
	}
	return nil
}

func (x *Requirements_Maven) GetProfiles() []*Requirements_Maven_Profile {
	if x != nil {
		return x.Profiles
	}
	return nil
}

type Requirements_RubyGems struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of runtime dependencies.
	RuntimeDependencies []*Requirements_RubyGems_Dependency `protobuf:"bytes,1,rep,name=runtime_dependencies,json=runtimeDependencies,proto3" json:"runtime_dependencies,omitempty"`
	// The list of development dependencies.
	DevDependencies []*Requirements_RubyGems_Dependency `protobuf:"bytes,2,rep,name=dev_dependencies,json=devDependencies,proto3" json:"dev_dependencies,omitempty"`
}

func (x *Requirements_RubyGems) Reset() {
	*x = Requirements_RubyGems{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_RubyGems) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_RubyGems) ProtoMessage() {}

func (x *Requirements_RubyGems) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_RubyGems.ProtoReflect.Descriptor instead.
func (*Requirements_RubyGems) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 3}
}

func (x *Requirements_RubyGems) GetRuntimeDependencies() []*Requirements_RubyGems_Dependency {
	if x != nil {
		return x.RuntimeDependencies
	}
	return nil
}

func (x *Requirements_RubyGems) GetDevDependencies() []*Requirements_RubyGems_Dependency {
	if x != nil {
		return x.DevDependencies
	}
	return nil
}

type Requirements_NuGet_DependencyGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target framework that this dependency group is for.
	TargetFramework string `protobuf:"bytes,1,opt,name=target_framework,json=targetFramework,proto3" json:"target_framework,omitempty"`
	// The requirements belonging to this dependency group.
	Dependencies []*Requirements_NuGet_DependencyGroup_Dependency `protobuf:"bytes,2,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
}

func (x *Requirements_NuGet_DependencyGroup) Reset() {
	*x = Requirements_NuGet_DependencyGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_NuGet_DependencyGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_NuGet_DependencyGroup) ProtoMessage() {}

func (x *Requirements_NuGet_DependencyGroup) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_NuGet_DependencyGroup.ProtoReflect.Descriptor instead.
func (*Requirements_NuGet_DependencyGroup) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 0, 0}
}

func (x *Requirements_NuGet_DependencyGroup) GetTargetFramework() string {
	if x != nil {
		return x.TargetFramework
	}
	return ""
}

func (x *Requirements_NuGet_DependencyGroup) GetDependencies() []*Requirements_NuGet_DependencyGroup_Dependency {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

type Requirements_NuGet_DependencyGroup_Dependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The requirement on the package.
	Requirement string `protobuf:"bytes,2,opt,name=requirement,proto3" json:"requirement,omitempty"`
}

func (x *Requirements_NuGet_DependencyGroup_Dependency) Reset() {
	*x = Requirements_NuGet_DependencyGroup_Dependency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_NuGet_DependencyGroup_Dependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_NuGet_DependencyGroup_Dependency) ProtoMessage() {}

func (x *Requirements_NuGet_DependencyGroup_Dependency) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_NuGet_DependencyGroup_Dependency.ProtoReflect.Descriptor instead.
func (*Requirements_NuGet_DependencyGroup_Dependency) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 0, 0, 0}
}

func (x *Requirements_NuGet_DependencyGroup_Dependency) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Requirements_NuGet_DependencyGroup_Dependency) GetRequirement() string {
	if x != nil {
		return x.Requirement
	}
	return ""
}

type Requirements_NPM_Dependencies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The "dependencies" field of a package.json, represented as a list of
	// name, requirement pairs.
	Dependencies []*Requirements_NPM_Dependencies_Dependency `protobuf:"bytes,1,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// The "devDependencies" field of a package.json. The format is the
	// same as "dependencies".
	DevDependencies []*Requirements_NPM_Dependencies_Dependency `protobuf:"bytes,2,rep,name=dev_dependencies,json=devDependencies,proto3" json:"dev_dependencies,omitempty"`
	// The "optionalDependencies" field of a package.json. The format is
	// the same as "dependencies".
	OptionalDependencies []*Requirements_NPM_Dependencies_Dependency `protobuf:"bytes,3,rep,name=optional_dependencies,json=optionalDependencies,proto3" json:"optional_dependencies,omitempty"`
	// The "peerDependencies" field of a package.json. The format is the
	// same as "dependencies".
	PeerDependencies []*Requirements_NPM_Dependencies_Dependency `protobuf:"bytes,4,rep,name=peer_dependencies,json=peerDependencies,proto3" json:"peer_dependencies,omitempty"`
	// The "bundleDependencies" field of a package.json: a list of package
	// names. In the package.json this may also just be the boolean value
	// "true", in which case this field will contain the names of all the
	// dependencies from the "dependencies" field.
	BundleDependencies []string `protobuf:"bytes,5,rep,name=bundle_dependencies,json=bundleDependencies,proto3" json:"bundle_dependencies,omitempty"`
}

func (x *Requirements_NPM_Dependencies) Reset() {
	*x = Requirements_NPM_Dependencies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_NPM_Dependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_NPM_Dependencies) ProtoMessage() {}

func (x *Requirements_NPM_Dependencies) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_NPM_Dependencies.ProtoReflect.Descriptor instead.
func (*Requirements_NPM_Dependencies) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 1, 0}
}

func (x *Requirements_NPM_Dependencies) GetDependencies() []*Requirements_NPM_Dependencies_Dependency {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *Requirements_NPM_Dependencies) GetDevDependencies() []*Requirements_NPM_Dependencies_Dependency {
	if x != nil {
		return x.DevDependencies
	}
	return nil
}

func (x *Requirements_NPM_Dependencies) GetOptionalDependencies() []*Requirements_NPM_Dependencies_Dependency {
	if x != nil {
		return x.OptionalDependencies
	}
	return nil
}

func (x *Requirements_NPM_Dependencies) GetPeerDependencies() []*Requirements_NPM_Dependencies_Dependency {
	if x != nil {
		return x.PeerDependencies
	}
	return nil
}

func (x *Requirements_NPM_Dependencies) GetBundleDependencies() []string {
	if x != nil {
		return x.BundleDependencies
	}
	return nil
}

type Requirements_NPM_Bundle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path inside the tarball where this dependency was found.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The name of the bundled package, as declared inside the bundled
	// package.json.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of this package, as declared inside the bundled
	// package.json.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// The dependency-related fields from the bundled package.json.
	Dependencies *Requirements_NPM_Dependencies `protobuf:"bytes,4,opt,name=dependencies,proto3" json:"dependencies,omitempty"`
}

func (x *Requirements_NPM_Bundle) Reset() {
	*x = Requirements_NPM_Bundle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_NPM_Bundle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_NPM_Bundle) ProtoMessage() {}

func (x *Requirements_NPM_Bundle) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_NPM_Bundle.ProtoReflect.Descriptor instead.
func (*Requirements_NPM_Bundle) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 1, 1}
}

func (x *Requirements_NPM_Bundle) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Requirements_NPM_Bundle) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Requirements_NPM_Bundle) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Requirements_NPM_Bundle) GetDependencies() *Requirements_NPM_Dependencies {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

type Requirements_NPM_Dependencies_Dependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package, the key in the original object.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The requirement, the corresponding value from the original object.
	Requirement string `protobuf:"bytes,2,opt,name=requirement,proto3" json:"requirement,omitempty"`
}

func (x *Requirements_NPM_Dependencies_Dependency) Reset() {
	*x = Requirements_NPM_Dependencies_Dependency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_NPM_Dependencies_Dependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_NPM_Dependencies_Dependency) ProtoMessage() {}

func (x *Requirements_NPM_Dependencies_Dependency) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_NPM_Dependencies_Dependency.ProtoReflect.Descriptor instead.
func (*Requirements_NPM_Dependencies_Dependency) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 1, 0, 0}
}

func (x *Requirements_NPM_Dependencies_Dependency) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Requirements_NPM_Dependencies_Dependency) GetRequirement() string {
	if x != nil {
		return x.Requirement
	}
	return ""
}

type Requirements_Maven_Dependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version requirement of the dependency.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// The classifier of the dependency, which distinguishes artifacts that
	// differ in content.
	Classifier string `protobuf:"bytes,3,opt,name=classifier,proto3" json:"classifier,omitempty"`
	// The type of the dependency, defaults to jar.
	Type string `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	// The scope of the dependency, specifies how to limit the transitivity
	// of a dependency.
	Scope string `protobuf:"bytes,5,opt,name=scope,proto3" json:"scope,omitempty"`
	// Whether the dependency is optional or not.
	Optional string `protobuf:"bytes,6,opt,name=optional,proto3" json:"optional,omitempty"`
	// The dependencies to be excluded, in the form of a list of package
	// names.
	// Exclusions may contain wildcards in both groupID and artifactID.
	Exclusions []string `protobuf:"bytes,7,rep,name=exclusions,proto3" json:"exclusions,omitempty"`
}

func (x *Requirements_Maven_Dependency) Reset() {
	*x = Requirements_Maven_Dependency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Dependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Dependency) ProtoMessage() {}

func (x *Requirements_Maven_Dependency) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Dependency.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Dependency) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 0}
}

func (x *Requirements_Maven_Dependency) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Requirements_Maven_Dependency) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Requirements_Maven_Dependency) GetClassifier() string {
	if x != nil {
		return x.Classifier
	}
	return ""
}

func (x *Requirements_Maven_Dependency) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Requirements_Maven_Dependency) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *Requirements_Maven_Dependency) GetOptional() string {
	if x != nil {
		return x.Optional
	}
	return ""
}

func (x *Requirements_Maven_Dependency) GetExclusions() []string {
	if x != nil {
		return x.Exclusions
	}
	return nil
}

type Requirements_Maven_Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the property.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the property.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Requirements_Maven_Property) Reset() {
	*x = Requirements_Maven_Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Property) ProtoMessage() {}

func (x *Requirements_Maven_Property) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Property.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Property) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 1}
}

func (x *Requirements_Maven_Property) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Requirements_Maven_Property) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type Requirements_Maven_Repository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The URL of the repository.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Whether the description of the repository follows a common layout.
	Layout string `protobuf:"bytes,3,opt,name=layout,proto3" json:"layout,omitempty"`
	// Whether the repository is enabled for release downloads.
	ReleasesEnabled string `protobuf:"bytes,4,opt,name=releases_enabled,json=releasesEnabled,proto3" json:"releases_enabled,omitempty"`
	// Whether the repository is enabled for snapshot downloads.
	SnapshotsEnabled string `protobuf:"bytes,5,opt,name=snapshots_enabled,json=snapshotsEnabled,proto3" json:"snapshots_enabled,omitempty"`
}

func (x *Requirements_Maven_Repository) Reset() {
	*x = Requirements_Maven_Repository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Repository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Repository) ProtoMessage() {}

func (x *Requirements_Maven_Repository) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Repository.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Repository) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 2}
}

func (x *Requirements_Maven_Repository) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Requirements_Maven_Repository) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Requirements_Maven_Repository) GetLayout() string {
	if x != nil {
		return x.Layout
	}
	return ""
}

func (x *Requirements_Maven_Repository) GetReleasesEnabled() string {
	if x != nil {
		return x.ReleasesEnabled
	}
	return ""
}

func (x *Requirements_Maven_Repository) GetSnapshotsEnabled() string {
	if x != nil {
		return x.SnapshotsEnabled
	}
	return ""
}

type Requirements_Maven_Profile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the profile.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The activation requirement of the profile.
	Activation *Requirements_Maven_Profile_Activation `protobuf:"bytes,2,opt,name=activation,proto3" json:"activation,omitempty"`
	// The dependencies specified in the profile.
	Dependencies []*Requirements_Maven_Dependency `protobuf:"bytes,3,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// The dependency management specified in the profile.
	DependencyManagement []*Requirements_Maven_Dependency `protobuf:"bytes,4,rep,name=dependency_management,json=dependencyManagement,proto3" json:"dependency_management,omitempty"`
	// The properties specified in the profile.
	Properties []*Requirements_Maven_Property `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty"`
	// The repositories specified in the profile.
	Repositories []*Requirements_Maven_Repository `protobuf:"bytes,6,rep,name=repositories,proto3" json:"repositories,omitempty"`
}

func (x *Requirements_Maven_Profile) Reset() {
	*x = Requirements_Maven_Profile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Profile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Profile) ProtoMessage() {}

func (x *Requirements_Maven_Profile) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Profile.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Profile) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 3}
}

func (x *Requirements_Maven_Profile) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Requirements_Maven_Profile) GetActivation() *Requirements_Maven_Profile_Activation {
	if x != nil {
		return x.Activation
	}
	return nil
}

func (x *Requirements_Maven_Profile) GetDependencies() []*Requirements_Maven_Dependency {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *Requirements_Maven_Profile) GetDependencyManagement() []*Requirements_Maven_Dependency {
	if x != nil {
		return x.DependencyManagement
	}
	return nil
}

func (x *Requirements_Maven_Profile) GetProperties() []*Requirements_Maven_Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Requirements_Maven_Profile) GetRepositories() []*Requirements_Maven_Repository {
	if x != nil {
		return x.Repositories
	}
	return nil
}

type Requirements_Maven_Profile_Activation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the profile is active by default.
	ActiveByDefault string `protobuf:"bytes,1,opt,name=active_by_default,json=activeByDefault,proto3" json:"active_by_default,omitempty"`
	// The JDK requirement of the activation.
	Jdk *Requirements_Maven_Profile_Activation_JDK `protobuf:"bytes,2,opt,name=jdk,proto3" json:"jdk,omitempty"`
	// The operating system requirement of the activation.
	Os *Requirements_Maven_Profile_Activation_OS `protobuf:"bytes,3,opt,name=os,proto3" json:"os,omitempty"`
	// The property requirement of the activation.
	Property *Requirements_Maven_Profile_Activation_Property `protobuf:"bytes,4,opt,name=property,proto3" json:"property,omitempty"`
	// The file requirement of the activation.
	File *Requirements_Maven_Profile_Activation_File `protobuf:"bytes,5,opt,name=file,proto3" json:"file,omitempty"`
}

func (x *Requirements_Maven_Profile_Activation) Reset() {
	*x = Requirements_Maven_Profile_Activation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Profile_Activation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Profile_Activation) ProtoMessage() {}

func (x *Requirements_Maven_Profile_Activation) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Profile_Activation.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Profile_Activation) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 3, 0}
}

func (x *Requirements_Maven_Profile_Activation) GetActiveByDefault() string {
	if x != nil {
		return x.ActiveByDefault
	}
	return ""
}

func (x *Requirements_Maven_Profile_Activation) GetJdk() *Requirements_Maven_Profile_Activation_JDK {
	if x != nil {
		return x.Jdk
	}
	return nil
}

func (x *Requirements_Maven_Profile_Activation) GetOs() *Requirements_Maven_Profile_Activation_OS {
	if x != nil {
		return x.Os
	}
	return nil
}

func (x *Requirements_Maven_Profile_Activation) GetProperty() *Requirements_Maven_Profile_Activation_Property {
	if x != nil {
		return x.Property
	}
	return nil
}

func (x *Requirements_Maven_Profile_Activation) GetFile() *Requirements_Maven_Profile_Activation_File {
	if x != nil {
		return x.File
	}
	return nil
}

type Requirements_Maven_Profile_Activation_JDK struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The JDK requirement to activate the profile.
	Jdk string `protobuf:"bytes,1,opt,name=jdk,proto3" json:"jdk,omitempty"`
}

func (x *Requirements_Maven_Profile_Activation_JDK) Reset() {
	*x = Requirements_Maven_Profile_Activation_JDK{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Profile_Activation_JDK) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Profile_Activation_JDK) ProtoMessage() {}

func (x *Requirements_Maven_Profile_Activation_JDK) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Profile_Activation_JDK.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Profile_Activation_JDK) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 3, 0, 0}
}

func (x *Requirements_Maven_Profile_Activation_JDK) GetJdk() string {
	if x != nil {
		return x.Jdk
	}
	return ""
}

type Requirements_Maven_Profile_Activation_OS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the operating system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The family of the operating system.
	Family string `protobuf:"bytes,2,opt,name=family,proto3" json:"family,omitempty"`
	// The CPU architecture of the operating system,
	Arch string `protobuf:"bytes,3,opt,name=arch,proto3" json:"arch,omitempty"`
	// The version of the operating system.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Requirements_Maven_Profile_Activation_OS) Reset() {
	*x = Requirements_Maven_Profile_Activation_OS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Profile_Activation_OS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Profile_Activation_OS) ProtoMessage() {}

func (x *Requirements_Maven_Profile_Activation_OS) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Profile_Activation_OS.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Profile_Activation_OS) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 3, 0, 1}
}

func (x *Requirements_Maven_Profile_Activation_OS) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Requirements_Maven_Profile_Activation_OS) GetFamily() string {
	if x != nil {
		return x.Family
	}
	return ""
}

func (x *Requirements_Maven_Profile_Activation_OS) GetArch() string {
	if x != nil {
		return x.Arch
	}
	return ""
}

func (x *Requirements_Maven_Profile_Activation_OS) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type Requirements_Maven_Profile_Activation_Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The property requirement to activate the profile.
	// This can be a system property or CLI user property.
	Property *Requirements_Maven_Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *Requirements_Maven_Profile_Activation_Property) Reset() {
	*x = Requirements_Maven_Profile_Activation_Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Profile_Activation_Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Profile_Activation_Property) ProtoMessage() {}

func (x *Requirements_Maven_Profile_Activation_Property) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Profile_Activation_Property.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Profile_Activation_Property) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 3, 0, 2}
}

func (x *Requirements_Maven_Profile_Activation_Property) GetProperty() *Requirements_Maven_Property {
	if x != nil {
		return x.Property
	}
	return nil
}

type Requirements_Maven_Profile_Activation_File struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the file that its existence activates the profile.
	Exists string `protobuf:"bytes,1,opt,name=exists,proto3" json:"exists,omitempty"`
	// The name of the file, activate the profile if the file is missing.
	Missing string `protobuf:"bytes,2,opt,name=missing,proto3" json:"missing,omitempty"`
}

func (x *Requirements_Maven_Profile_Activation_File) Reset() {
	*x = Requirements_Maven_Profile_Activation_File{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_Maven_Profile_Activation_File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_Maven_Profile_Activation_File) ProtoMessage() {}

func (x *Requirements_Maven_Profile_Activation_File) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_Maven_Profile_Activation_File.ProtoReflect.Descriptor instead.
func (*Requirements_Maven_Profile_Activation_File) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 2, 3, 0, 3}
}

func (x *Requirements_Maven_Profile_Activation_File) GetExists() string {
	if x != nil {
		return x.Exists
	}
	return ""
}

func (x *Requirements_Maven_Profile_Activation_File) GetMissing() string {
	if x != nil {
		return x.Missing
	}
	return ""
}

type Requirements_RubyGems_Dependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The requirement on the package.
	Requirement string `protobuf:"bytes,2,opt,name=requirement,proto3" json:"requirement,omitempty"`
}

func (x *Requirements_RubyGems_Dependency) Reset() {
	*x = Requirements_RubyGems_Dependency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Requirements_RubyGems_Dependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requirements_RubyGems_Dependency) ProtoMessage() {}

func (x *Requirements_RubyGems_Dependency) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requirements_RubyGems_Dependency.ProtoReflect.Descriptor instead.
func (*Requirements_RubyGems_Dependency) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 3, 0}
}

func (x *Requirements_RubyGems_Dependency) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Requirements_RubyGems_Dependency) GetRequirement() string {
	if x != nil {
		return x.Requirement
	}
	return ""
}

// Node represents a node in a resolved dependency graph.
type Dependencies_Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The package version represented by this node. Note that the package and
	// version name may differ from the names in the request, if provided, due
	// to canonicalization.
	//
	// In some systems, a graph may contain multiple nodes for the same package
	// version.
	VersionKey *VersionKey `protobuf:"bytes,1,opt,name=version_key,json=versionKey,proto3" json:"version_key,omitempty"`
	// If true, this is a bundled dependency.
	//
	// For bundled dependencies, the package name in the version key encodes
	// how the dependency is bundled. As an example, a bundled dependency with
	// a name like "a>1.2.3>b>c" is part of the dependency graph of package "a"
	// at version "1.2.3", and has the local name "c". It may or may not be the
	// same as a package with the global name "c".
	Bundled bool `protobuf:"varint,2,opt,name=bundled,proto3" json:"bundled,omitempty"`
	// Whether this node represents a direct or indirect dependency within this
	// dependency graph. Note that it's possible for a dependency to be both
	// direct and indirect; if so, it is marked as direct.
	Relation DependencyRelation `protobuf:"varint,4,opt,name=relation,proto3,enum=deps_dev.v3.DependencyRelation" json:"relation,omitempty"`
	// Errors associated with this node of the graph, such as an unresolved
	// dependency requirement. An error on a node may imply the graph as a
	// whole is incorrect. These error messages have no defined format and are
	// intended for human consumption.
	Errors []string `protobuf:"bytes,3,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *Dependencies_Node) Reset() {
	*x = Dependencies_Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dependencies_Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dependencies_Node) ProtoMessage() {}

func (x *Dependencies_Node) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dependencies_Node.ProtoReflect.Descriptor instead.
func (*Dependencies_Node) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{15, 0}
}

func (x *Dependencies_Node) GetVersionKey() *VersionKey {
	if x != nil {
		return x.VersionKey
	}
	return nil
}

func (x *Dependencies_Node) GetBundled() bool {
	if x != nil {
		return x.Bundled
	}
	return false
}

func (x *Dependencies_Node) GetRelation() DependencyRelation {
	if x != nil {
		return x.Relation
	}
	return DependencyRelation_DEPENDENCY_RELATION_UNSPECIFIED
}

func (x *Dependencies_Node) GetErrors() []string {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Edge represents a directed edge in a resolved dependency graph: a
// dependency relation between two nodes.
type Dependencies_Edge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The node declaring the dependency, specified as an index into the list of
	// nodes.
	FromNode uint32 `protobuf:"varint,1,opt,name=from_node,json=fromNode,proto3" json:"from_node,omitempty"`
	// The node resolving the dependency, specified as an index into the list of
	// nodes.
	ToNode uint32 `protobuf:"varint,2,opt,name=to_node,json=toNode,proto3" json:"to_node,omitempty"`
	// The requirement resolved by this edge, as declared by the "from" node.
	// The meaning of this field is system-specific. As an example, in npm, the
	// requirement "^1.0.0" may be resolved by the version "1.2.3".
	Requirement string `protobuf:"bytes,3,opt,name=requirement,proto3" json:"requirement,omitempty"`
}

func (x *Dependencies_Edge) Reset() {
	*x = Dependencies_Edge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dependencies_Edge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dependencies_Edge) ProtoMessage() {}

func (x *Dependencies_Edge) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dependencies_Edge.ProtoReflect.Descriptor instead.
func (*Dependencies_Edge) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{15, 1}
}

func (x *Dependencies_Edge) GetFromNode() uint32 {
	if x != nil {
		return x.FromNode
	}
	return 0
}

func (x *Dependencies_Edge) GetToNode() uint32 {
	if x != nil {
		return x.ToNode
	}
	return 0
}

func (x *Dependencies_Edge) GetRequirement() string {
	if x != nil {
		return x.Requirement
	}
	return ""
}

type Project_Scorecard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The date at which the scorecard was produced.
	// The time portion of this field is midnight UTC.
	Date *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// The source code repository and commit the scorecard was produced from.
	Repository *Project_Scorecard_Repository `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// The version and commit of the Scorecard program used to produce the
	// scorecard.
	Scorecard *Project_Scorecard_ScorecardDetails `protobuf:"bytes,3,opt,name=scorecard,proto3" json:"scorecard,omitempty"`
	// The results of the
	// [Scorecard Checks](https://github.com/ossf/scorecard#scorecard-checks)
	// performed on the project.
	Checks []*Project_Scorecard_Check `protobuf:"bytes,4,rep,name=checks,proto3" json:"checks,omitempty"`
	// A weighted average score in the range [0,10]. A higher score is better.
	OverallScore float32 `protobuf:"fixed32,5,opt,name=overall_score,json=overallScore,proto3" json:"overall_score,omitempty"`
	// Additional metadata associated with the scorecard.
	Metadata []string `protobuf:"bytes,6,rep,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *Project_Scorecard) Reset() {
	*x = Project_Scorecard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Project_Scorecard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Project_Scorecard) ProtoMessage() {}

func (x *Project_Scorecard) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Project_Scorecard.ProtoReflect.Descriptor instead.
func (*Project_Scorecard) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{17, 0}
}

func (x *Project_Scorecard) GetDate() *timestamppb.Timestamp {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *Project_Scorecard) GetRepository() *Project_Scorecard_Repository {
	if x != nil {
		return x.Repository
	}
	return nil
}

func (x *Project_Scorecard) GetScorecard() *Project_Scorecard_ScorecardDetails {
	if x != nil {
		return x.Scorecard
	}
	return nil
}

func (x *Project_Scorecard) GetChecks() []*Project_Scorecard_Check {
	if x != nil {
		return x.Checks
	}
	return nil
}

func (x *Project_Scorecard) GetOverallScore() float32 {
	if x != nil {
		return x.OverallScore
	}
	return 0
}

func (x *Project_Scorecard) GetMetadata() []string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type Project_OSSFuzzDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of lines of code in the project.
	LineCount int32 `protobuf:"varint,1,opt,name=line_count,json=lineCount,proto3" json:"line_count,omitempty"`
	// The number of lines of code covered by fuzzing.
	LineCoverCount int32 `protobuf:"varint,2,opt,name=line_cover_count,json=lineCoverCount,proto3" json:"line_cover_count,omitempty"`
	// The date the fuzz test that produced the coverage information was run
	// against this project.
	// The time portion of this field is midnight UTC.
	Date *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=date,proto3" json:"date,omitempty"`
	// The URL containing the configuration for the project in the
	// OSS-Fuzz repository.
	ConfigUrl string `protobuf:"bytes,4,opt,name=config_url,json=configUrl,proto3" json:"config_url,omitempty"`
}

func (x *Project_OSSFuzzDetails) Reset() {
	*x = Project_OSSFuzzDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Project_OSSFuzzDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Project_OSSFuzzDetails) ProtoMessage() {}

func (x *Project_OSSFuzzDetails) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Project_OSSFuzzDetails.ProtoReflect.Descriptor instead.
func (*Project_OSSFuzzDetails) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{17, 1}
}

func (x *Project_OSSFuzzDetails) GetLineCount() int32 {
	if x != nil {
		return x.LineCount
	}
	return 0
}

func (x *Project_OSSFuzzDetails) GetLineCoverCount() int32 {
	if x != nil {
		return x.LineCoverCount
	}
	return 0
}

func (x *Project_OSSFuzzDetails) GetDate() *timestamppb.Timestamp {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *Project_OSSFuzzDetails) GetConfigUrl() string {
	if x != nil {
		return x.ConfigUrl
	}
	return ""
}

type Project_Scorecard_Repository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source code repository the scorecard was produced from.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The source code commit the scorecard was produced from.
	Commit string `protobuf:"bytes,2,opt,name=commit,proto3" json:"commit,omitempty"`
}

func (x *Project_Scorecard_Repository) Reset() {
	*x = Project_Scorecard_Repository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Project_Scorecard_Repository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Project_Scorecard_Repository) ProtoMessage() {}

func (x *Project_Scorecard_Repository) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Project_Scorecard_Repository.ProtoReflect.Descriptor instead.
func (*Project_Scorecard_Repository) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{17, 0, 0}
}

func (x *Project_Scorecard_Repository) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Project_Scorecard_Repository) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

type Project_Scorecard_ScorecardDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of the Scorecard program used to produce the scorecard.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The commit of the Scorecard program used to produce the scorecard.
	Commit string `protobuf:"bytes,2,opt,name=commit,proto3" json:"commit,omitempty"`
}

func (x *Project_Scorecard_ScorecardDetails) Reset() {
	*x = Project_Scorecard_ScorecardDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Project_Scorecard_ScorecardDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Project_Scorecard_ScorecardDetails) ProtoMessage() {}

func (x *Project_Scorecard_ScorecardDetails) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Project_Scorecard_ScorecardDetails.ProtoReflect.Descriptor instead.
func (*Project_Scorecard_ScorecardDetails) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{17, 0, 1}
}

func (x *Project_Scorecard_ScorecardDetails) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Project_Scorecard_ScorecardDetails) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

type Project_Scorecard_Check struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the check.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human-readable documentation for the check.
	Documentation *Project_Scorecard_Check_Documentation `protobuf:"bytes,2,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// A score in the range [0,10]. A higher score is better.
	// A negative score indicates that the check did not run successfully.
	Score int32 `protobuf:"varint,3,opt,name=score,proto3" json:"score,omitempty"`
	// The reason for the score.
	Reason string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	// Further details regarding the check.
	Details []string `protobuf:"bytes,5,rep,name=details,proto3" json:"details,omitempty"`
}

func (x *Project_Scorecard_Check) Reset() {
	*x = Project_Scorecard_Check{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Project_Scorecard_Check) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Project_Scorecard_Check) ProtoMessage() {}

func (x *Project_Scorecard_Check) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Project_Scorecard_Check.ProtoReflect.Descriptor instead.
func (*Project_Scorecard_Check) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{17, 0, 2}
}

func (x *Project_Scorecard_Check) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Project_Scorecard_Check) GetDocumentation() *Project_Scorecard_Check_Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *Project_Scorecard_Check) GetScore() int32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *Project_Scorecard_Check) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *Project_Scorecard_Check) GetDetails() []string {
	if x != nil {
		return x.Details
	}
	return nil
}

type Project_Scorecard_Check_Documentation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short description of the check.
	ShortDescription string `protobuf:"bytes,1,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// A link to more details about the check.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *Project_Scorecard_Check_Documentation) Reset() {
	*x = Project_Scorecard_Check_Documentation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Project_Scorecard_Check_Documentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Project_Scorecard_Check_Documentation) ProtoMessage() {}

func (x *Project_Scorecard_Check_Documentation) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Project_Scorecard_Check_Documentation.ProtoReflect.Descriptor instead.
func (*Project_Scorecard_Check_Documentation) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{17, 0, 2, 0}
}

func (x *Project_Scorecard_Check_Documentation) GetShortDescription() string {
	if x != nil {
		return x.ShortDescription
	}
	return ""
}

func (x *Project_Scorecard_Check_Documentation) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type ProjectPackageVersions_Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier for the version.
	VersionKey *VersionKey `protobuf:"bytes,1,opt,name=version_key,json=versionKey,proto3" json:"version_key,omitempty"`
	// The SLSA provenance statements that link the version to the project. This
	// is only populated for npm package versions. See the 'attestations' field
	// for more attestations (including SLSA provenance) for all systems.
	SlsaProvenances []*SLSAProvenance `protobuf:"bytes,2,rep,name=slsa_provenances,json=slsaProvenances,proto3" json:"slsa_provenances,omitempty"`
	// Attestations that link the version to the project.
	Attestations []*Attestation `protobuf:"bytes,5,rep,name=attestations,proto3" json:"attestations,omitempty"`
	// What the relationship between the project and the package version is.
	RelationType ProjectRelationType `protobuf:"varint,3,opt,name=relation_type,json=relationType,proto3,enum=deps_dev.v3.ProjectRelationType" json:"relation_type,omitempty"`
	// How the mapping between project and package version was discovered.
	RelationProvenance ProjectRelationProvenance `protobuf:"varint,4,opt,name=relation_provenance,json=relationProvenance,proto3,enum=deps_dev.v3.ProjectRelationProvenance" json:"relation_provenance,omitempty"`
}

func (x *ProjectPackageVersions_Version) Reset() {
	*x = ProjectPackageVersions_Version{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectPackageVersions_Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectPackageVersions_Version) ProtoMessage() {}

func (x *ProjectPackageVersions_Version) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectPackageVersions_Version.ProtoReflect.Descriptor instead.
func (*ProjectPackageVersions_Version) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{19, 0}
}

func (x *ProjectPackageVersions_Version) GetVersionKey() *VersionKey {
	if x != nil {
		return x.VersionKey
	}
	return nil
}

func (x *ProjectPackageVersions_Version) GetSlsaProvenances() []*SLSAProvenance {
	if x != nil {
		return x.SlsaProvenances
	}
	return nil
}

func (x *ProjectPackageVersions_Version) GetAttestations() []*Attestation {
	if x != nil {
		return x.Attestations
	}
	return nil
}

func (x *ProjectPackageVersions_Version) GetRelationType() ProjectRelationType {
	if x != nil {
		return x.RelationType
	}
	return ProjectRelationType_UNKNOWN_PROJECT_RELATION_TYPE
}

func (x *ProjectPackageVersions_Version) GetRelationProvenance() ProjectRelationProvenance {
	if x != nil {
		return x.RelationProvenance
	}
	return ProjectRelationProvenance_UNKNOWN_PROJECT_RELATION_PROVENANCE
}

type QueryResult_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version *Version `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *QueryResult_Result) Reset() {
	*x = QueryResult_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult_Result) ProtoMessage() {}

func (x *QueryResult_Result) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult_Result.ProtoReflect.Descriptor instead.
func (*QueryResult_Result) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{23, 0}
}

func (x *QueryResult_Result) GetVersion() *Version {
	if x != nil {
		return x.Version
	}
	return nil
}

var File_api_proto protoreflect.FileDescriptor

var file_api_proto_rawDesc = []byte{
	0x0a, 0x09, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x64, 0x65, 0x70,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4d, 0x0a, 0x0a, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x2b, 0x0a, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76,
	0x2e, 0x76, 0x33, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x06, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x67, 0x0a, 0x0a, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x12, 0x2b, 0x0a, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e,
	0x76, 0x33, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x1c, 0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x1d, 0x0a,
	0x0b, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x47, 0x0a, 0x04,
	0x48, 0x61, 0x73, 0x68, 0x12, 0x29, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x15, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x48, 0x61, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x2e, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x14, 0x0a,
	0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0x83, 0x01, 0x0a, 0x0e, 0x53, 0x4c, 0x53, 0x41, 0x50, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12,
	0x1a, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x22, 0x94, 0x01, 0x0a, 0x0b,
	0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x12, 0x2b, 0x0a,
	0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x22, 0x4d, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64,
	0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4b, 0x65,
	0x79, 0x22, 0xa1, 0x02, 0x0a, 0x07, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x38, 0x0a,
	0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x38, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x65, 0x70, 0x73,
	0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x2e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x1a, 0xa1, 0x01, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a,
	0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x22, 0x4d, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0b, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x22, 0xfa, 0x05, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x38, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76,
	0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0a,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x0c, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69,
	0x73, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0d, 0x61, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79,
	0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x65,
	0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f,
	0x72, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x61, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x4b,
	0x65, 0x79, 0x73, 0x12, 0x27, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x46, 0x0a, 0x10,
	0x73, 0x6c, 0x73, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x4c, 0x53, 0x41, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x0f, 0x73, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x65, 0x70,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x47, 0x0a, 0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64,
	0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x0f, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a, 0xe3, 0x01, 0x0a, 0x07,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64,
	0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65,
	0x79, 0x12, 0x57, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26,
	0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x76,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x45, 0x0a, 0x0d, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x20, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x52, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0b, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0xa4, 0x1c, 0x0a, 0x0c, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x35, 0x0a, 0x05, 0x6e, 0x75, 0x67, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2e, 0x4e, 0x75, 0x47, 0x65, 0x74, 0x52, 0x05, 0x6e, 0x75, 0x67, 0x65, 0x74, 0x12, 0x2f, 0x0a,
	0x03, 0x6e, 0x70, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x70,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x50, 0x4d, 0x52, 0x03, 0x6e, 0x70, 0x6d, 0x12, 0x35,
	0x0a, 0x05, 0x6d, 0x61, 0x76, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x52, 0x05,
	0x6d, 0x61, 0x76, 0x65, 0x6e, 0x12, 0x3e, 0x0a, 0x08, 0x72, 0x75, 0x62, 0x79, 0x67, 0x65, 0x6d,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64,
	0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2e, 0x52, 0x75, 0x62, 0x79, 0x47, 0x65, 0x6d, 0x73, 0x52, 0x08, 0x72, 0x75, 0x62,
	0x79, 0x67, 0x65, 0x6d, 0x73, 0x1a, 0xc8, 0x02, 0x0a, 0x05, 0x4e, 0x75, 0x47, 0x65, 0x74, 0x12,
	0x5c, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x64, 0x65, 0x70,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x75, 0x47, 0x65, 0x74, 0x2e, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x10, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x1a, 0xe0, 0x01,
	0x0a, 0x0f, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5e, 0x0a, 0x0c,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x75,
	0x47, 0x65, 0x74, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0c,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x42, 0x0a, 0x0a,
	0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x1a, 0xc5, 0x06, 0x0a, 0x03, 0x4e, 0x50, 0x4d, 0x12, 0x4e, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x50, 0x4d, 0x2e, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x07, 0x62, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x70, 0x73,
	0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x50, 0x4d, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x52,
	0x07, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x64, 0x1a, 0x90, 0x04, 0x0a, 0x0c, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x0c, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x50, 0x4d, 0x2e, 0x44,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x69, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x10, 0x64, 0x65, 0x76, 0x5f, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x50, 0x4d, 0x2e, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0f, 0x64, 0x65, 0x76, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x6a, 0x0a, 0x15, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2e, 0x4e, 0x50, 0x4d, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x14, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x12, 0x62, 0x0a, 0x11, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x50, 0x4d, 0x2e, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x79, 0x52, 0x10, 0x70, 0x65, 0x65, 0x72, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x12, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x42, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x9a, 0x01, 0x0a, 0x06,
	0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4e, 0x50, 0x4d, 0x2e, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x94, 0x0f, 0x0a, 0x05, 0x4d, 0x61, 0x76,
	0x65, 0x6e, 0x12, 0x2f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x64, 0x65, 0x70, 0x73,
	0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x15, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x79, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61,
	0x76, 0x65, 0x6e, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x14,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f,
	0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4e,
	0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e,
	0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x43,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65,
	0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x1a, 0xc0, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x34, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x9e, 0x01, 0x0a,
	0x0a, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x16, 0x0a,
	0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x2b, 0x0a, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0xaf, 0x08,
	0x0a, 0x07, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x52, 0x0a, 0x0a, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a,
	0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d,
	0x61, 0x76, 0x65, 0x6e, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52,
	0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x5f, 0x0a,
	0x15, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x64,
	0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x14, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x48,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61,
	0x76, 0x65, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xf4, 0x04, 0x0a, 0x0a, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x62, 0x79, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x42, 0x79, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x12, 0x48, 0x0a, 0x03, 0x6a, 0x64, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65,
	0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4a, 0x44, 0x4b, 0x52, 0x03, 0x6a, 0x64, 0x6b, 0x12, 0x45, 0x0a,
	0x02, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x64, 0x65, 0x70, 0x73,
	0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x53,
	0x52, 0x02, 0x6f, 0x73, 0x12, 0x57, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x4b, 0x0a,
	0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x64, 0x65,
	0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x2e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x1a, 0x17, 0x0a, 0x03, 0x4a, 0x44,
	0x4b, 0x12, 0x10, 0x0a, 0x03, 0x6a, 0x64, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6a, 0x64, 0x6b, 0x1a, 0x5e, 0x0a, 0x02, 0x4f, 0x53, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x63, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x63, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x1a, 0x50, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12,
	0x44, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x76,
	0x65, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x1a, 0x38, 0x0a, 0x04, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x65, 0x78, 0x69, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65,
	0x78, 0x69, 0x73, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x1a,
	0x8a, 0x02, 0x0a, 0x08, 0x52, 0x75, 0x62, 0x79, 0x47, 0x65, 0x6d, 0x73, 0x12, 0x60, 0x0a, 0x14,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x64, 0x65, 0x70,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x52, 0x75, 0x62, 0x79, 0x47, 0x65, 0x6d, 0x73, 0x2e, 0x44,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x13, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x58,
	0x0a, 0x10, 0x64, 0x65, 0x76, 0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f,
	0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2e, 0x52, 0x75, 0x62, 0x79, 0x47, 0x65, 0x6d, 0x73, 0x2e, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0f, 0x64, 0x65, 0x76, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x42, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x52, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65,
	0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x22, 0xa2, 0x03, 0x0a, 0x0c, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x12, 0x34, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x05, 0x65, 0x64, 0x67, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x52, 0x05, 0x65, 0x64, 0x67, 0x65, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x1a, 0xaf, 0x01, 0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x38, 0x0a, 0x0b,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x64,
	0x12, 0x3b, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x1a, 0x5e, 0x0a, 0x04, 0x45, 0x64, 0x67, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x08, 0x66, 0x72, 0x6f, 0x6d, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x6f,
	0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x74, 0x6f, 0x4e,
	0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x4d, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x4b, 0x65, 0x79, 0x22, 0x99, 0x0a, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x38, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76,
	0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x70,
	0x65, 0x6e, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6f, 0x70, 0x65, 0x6e, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x6f, 0x72, 0x6b, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x66, 0x6f,
	0x72, 0x6b, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x6d, 0x65, 0x70, 0x61, 0x67, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x6d, 0x65, 0x70, 0x61, 0x67, 0x65,
	0x12, 0x3c, 0x0a, 0x09, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x72, 0x64, 0x52, 0x09, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x12, 0x3e,
	0x0a, 0x08, 0x6f, 0x73, 0x73, 0x5f, 0x66, 0x75, 0x7a, 0x7a, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x4f, 0x53, 0x53, 0x46, 0x75, 0x7a, 0x7a, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x6f, 0x73, 0x73, 0x46, 0x75, 0x7a, 0x7a, 0x1a, 0xe4,
	0x05, 0x0a, 0x09, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x12, 0x2e, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x0a,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x4d, 0x0a, 0x09, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x64, 0x65, 0x70,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x09, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x12, 0x3c, 0x0a, 0x06, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x06, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x6f, 0x76, 0x65,
	0x72, 0x61, 0x6c, 0x6c, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x38, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x1a,
	0x44, 0x0a, 0x10, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x1a, 0x8d, 0x02, 0x0a, 0x05, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x64, 0x65, 0x70,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a,
	0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x4e, 0x0a, 0x0d, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x6c, 0x1a, 0xa8, 0x01, 0x0a, 0x0e, 0x4f, 0x53, 0x53, 0x46, 0x75, 0x7a,
	0x7a, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6c, 0x69,
	0x6e, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0e, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x2e, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x55, 0x72, 0x6c,
	0x22, 0x5c, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73,
	0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4b,
	0x65, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x22, 0xcd,
	0x03, 0x0a, 0x16, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x08, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x64, 0x65,
	0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xe9, 0x02, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38,
	0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76,
	0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x46, 0x0a, 0x10, 0x73, 0x6c, 0x73, 0x61,
	0x5f, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x53, 0x4c, 0x53, 0x41, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x0f, 0x73, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x3c, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45,
	0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76,
	0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x57, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x26, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33,
	0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x12, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x51,
	0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0c, 0x61, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x65, 0x70,
	0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72,
	0x79, 0x4b, 0x65, 0x79, 0x52, 0x0b, 0x61, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x4b, 0x65,
	0x79, 0x22, 0xcd, 0x01, 0x0a, 0x08, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x12, 0x3b,
	0x0a, 0x0c, 0x61, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x0b,
	0x61, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x76, 0x73, 0x73, 0x33, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0a, 0x63, 0x76, 0x73, 0x73, 0x33, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x76, 0x73, 0x73, 0x33, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x76, 0x73, 0x73, 0x33, 0x56, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x22, 0x6f, 0x0a, 0x0c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x25, 0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x61,
	0x73, 0x68, 0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x12, 0x38, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x22, 0x82, 0x01, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x39, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76,
	0x33, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x38, 0x0a,
	0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2e, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f,
	0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0x6a, 0x0a, 0x06, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x47, 0x4f, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x55, 0x42, 0x59, 0x47, 0x45, 0x4d, 0x53, 0x10, 0x02, 0x12,
	0x07, 0x0a, 0x03, 0x4e, 0x50, 0x4d, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x41, 0x52, 0x47,
	0x4f, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x41, 0x56, 0x45, 0x4e, 0x10, 0x06, 0x12, 0x08,
	0x0a, 0x04, 0x50, 0x59, 0x50, 0x49, 0x10, 0x07, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x55, 0x47, 0x45,
	0x54, 0x10, 0x08, 0x2a, 0x50, 0x0a, 0x08, 0x48, 0x61, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x19, 0x0a, 0x15, 0x48, 0x41, 0x53, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x44,
	0x35, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x48, 0x41, 0x31, 0x10, 0x02, 0x12, 0x0a, 0x0a,
	0x06, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41,
	0x35, 0x31, 0x32, 0x10, 0x04, 0x2a, 0x5d, 0x0a, 0x12, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x1f, 0x44,
	0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x53, 0x45, 0x4c, 0x46, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x49,
	0x52, 0x45, 0x43, 0x54, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x44, 0x49, 0x52, 0x45,
	0x43, 0x54, 0x10, 0x03, 0x2a, 0x5c, 0x0a, 0x13, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x52,
	0x45, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x10, 0x01, 0x12,
	0x11, 0x0a, 0x0d, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x45, 0x52,
	0x10, 0x02, 0x2a, 0xa0, 0x01, 0x0a, 0x19, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x27, 0x0a, 0x23, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x4a,
	0x45, 0x43, 0x54, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x4f,
	0x56, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x4c, 0x53,
	0x41, 0x5f, 0x41, 0x54, 0x54, 0x45, 0x53, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x47, 0x4f, 0x5f, 0x4f, 0x52, 0x49, 0x47, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x1c,
	0x0a, 0x18, 0x50, 0x59, 0x50, 0x49, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x5f, 0x41,
	0x54, 0x54, 0x45, 0x53, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13,
	0x55, 0x4e, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44,
	0x41, 0x54, 0x41, 0x10, 0x0a, 0x32, 0xa1, 0x09, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x12, 0x1e, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x14, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12,
	0x3c, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x7b, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x7d, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0xa7, 0x01,
	0x0a, 0x0a, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x2e, 0x64,
	0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x14, 0x2e, 0x64,
	0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x12, 0x5b, 0x2f, 0x76, 0x33, 0x2f,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x7d, 0x2f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0xc3, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x23, 0x2e, 0x64, 0x65,
	0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x19, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x70, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x6a, 0x12, 0x68, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73,
	0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x7d, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d,
	0x3a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xc3, 0x01,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x12, 0x23, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x22, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x12, 0x68, 0x2f, 0x76, 0x33, 0x2f, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6b, 0x65, 0x79, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x7d, 0x2f, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65,
	0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x69, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x1e, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x14, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x25, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x12,
	0x1d, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x69, 0x64, 0x7d, 0x12, 0xa6,
	0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d, 0x2e, 0x64,
	0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x64, 0x65,
	0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x2e, 0x69, 0x64, 0x7d, 0x3a, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6f, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x41, 0x64,
	0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x12, 0x1f, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64,
	0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x22, 0x28,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x33, 0x2f, 0x61, 0x64, 0x76, 0x69,
	0x73, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79,
	0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x69, 0x64, 0x7d, 0x12, 0x4f, 0x0a, 0x05, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x19, 0x2e, 0x64, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e, 0x64,
	0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x2e, 0x76, 0x33, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x11, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0b, 0x12, 0x09,
	0x2f, 0x76, 0x33, 0x2f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x42, 0x11, 0x5a, 0x0f, 0x64, 0x65, 0x70,
	0x73, 0x2e, 0x64, 0x65, 0x76, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x33, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_api_proto_rawDescOnce sync.Once
	file_api_proto_rawDescData = file_api_proto_rawDesc
)

func file_api_proto_rawDescGZIP() []byte {
	file_api_proto_rawDescOnce.Do(func() {
		file_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_api_proto_rawDescData)
	})
	return file_api_proto_rawDescData
}

var file_api_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_api_proto_msgTypes = make([]protoimpl.MessageInfo, 55)
var file_api_proto_goTypes = []interface{}{
	(System)(0),                                            // 0: deps_dev.v3.System
	(HashType)(0),                                          // 1: deps_dev.v3.HashType
	(DependencyRelation)(0),                                // 2: deps_dev.v3.DependencyRelation
	(ProjectRelationType)(0),                               // 3: deps_dev.v3.ProjectRelationType
	(ProjectRelationProvenance)(0),                         // 4: deps_dev.v3.ProjectRelationProvenance
	(*PackageKey)(nil),                                     // 5: deps_dev.v3.PackageKey
	(*VersionKey)(nil),                                     // 6: deps_dev.v3.VersionKey
	(*ProjectKey)(nil),                                     // 7: deps_dev.v3.ProjectKey
	(*AdvisoryKey)(nil),                                    // 8: deps_dev.v3.AdvisoryKey
	(*Hash)(nil),                                           // 9: deps_dev.v3.Hash
	(*Link)(nil),                                           // 10: deps_dev.v3.Link
	(*SLSAProvenance)(nil),                                 // 11: deps_dev.v3.SLSAProvenance
	(*Attestation)(nil),                                    // 12: deps_dev.v3.Attestation
	(*GetPackageRequest)(nil),                              // 13: deps_dev.v3.GetPackageRequest
	(*Package)(nil),                                        // 14: deps_dev.v3.Package
	(*GetVersionRequest)(nil),                              // 15: deps_dev.v3.GetVersionRequest
	(*Version)(nil),                                        // 16: deps_dev.v3.Version
	(*GetRequirementsRequest)(nil),                         // 17: deps_dev.v3.GetRequirementsRequest
	(*Requirements)(nil),                                   // 18: deps_dev.v3.Requirements
	(*GetDependenciesRequest)(nil),                         // 19: deps_dev.v3.GetDependenciesRequest
	(*Dependencies)(nil),                                   // 20: deps_dev.v3.Dependencies
	(*GetProjectRequest)(nil),                              // 21: deps_dev.v3.GetProjectRequest
	(*Project)(nil),                                        // 22: deps_dev.v3.Project
	(*GetProjectPackageVersionsRequest)(nil),               // 23: deps_dev.v3.GetProjectPackageVersionsRequest
	(*ProjectPackageVersions)(nil),                         // 24: deps_dev.v3.ProjectPackageVersions
	(*GetAdvisoryRequest)(nil),                             // 25: deps_dev.v3.GetAdvisoryRequest
	(*Advisory)(nil),                                       // 26: deps_dev.v3.Advisory
	(*QueryRequest)(nil),                                   // 27: deps_dev.v3.QueryRequest
	(*QueryResult)(nil),                                    // 28: deps_dev.v3.QueryResult
	(*Package_Version)(nil),                                // 29: deps_dev.v3.Package.Version
	(*Version_Project)(nil),                                // 30: deps_dev.v3.Version.Project
	(*Requirements_NuGet)(nil),                             // 31: deps_dev.v3.Requirements.NuGet
	(*Requirements_NPM)(nil),                               // 32: deps_dev.v3.Requirements.NPM
	(*Requirements_Maven)(nil),                             // 33: deps_dev.v3.Requirements.Maven
	(*Requirements_RubyGems)(nil),                          // 34: deps_dev.v3.Requirements.RubyGems
	(*Requirements_NuGet_DependencyGroup)(nil),             // 35: deps_dev.v3.Requirements.NuGet.DependencyGroup
	(*Requirements_NuGet_DependencyGroup_Dependency)(nil),  // 36: deps_dev.v3.Requirements.NuGet.DependencyGroup.Dependency
	(*Requirements_NPM_Dependencies)(nil),                  // 37: deps_dev.v3.Requirements.NPM.Dependencies
	(*Requirements_NPM_Bundle)(nil),                        // 38: deps_dev.v3.Requirements.NPM.Bundle
	(*Requirements_NPM_Dependencies_Dependency)(nil),       // 39: deps_dev.v3.Requirements.NPM.Dependencies.Dependency
	(*Requirements_Maven_Dependency)(nil),                  // 40: deps_dev.v3.Requirements.Maven.Dependency
	(*Requirements_Maven_Property)(nil),                    // 41: deps_dev.v3.Requirements.Maven.Property
	(*Requirements_Maven_Repository)(nil),                  // 42: deps_dev.v3.Requirements.Maven.Repository
	(*Requirements_Maven_Profile)(nil),                     // 43: deps_dev.v3.Requirements.Maven.Profile
	(*Requirements_Maven_Profile_Activation)(nil),          // 44: deps_dev.v3.Requirements.Maven.Profile.Activation
	(*Requirements_Maven_Profile_Activation_JDK)(nil),      // 45: deps_dev.v3.Requirements.Maven.Profile.Activation.JDK
	(*Requirements_Maven_Profile_Activation_OS)(nil),       // 46: deps_dev.v3.Requirements.Maven.Profile.Activation.OS
	(*Requirements_Maven_Profile_Activation_Property)(nil), // 47: deps_dev.v3.Requirements.Maven.Profile.Activation.Property
	(*Requirements_Maven_Profile_Activation_File)(nil),     // 48: deps_dev.v3.Requirements.Maven.Profile.Activation.File
	(*Requirements_RubyGems_Dependency)(nil),               // 49: deps_dev.v3.Requirements.RubyGems.Dependency
	(*Dependencies_Node)(nil),                              // 50: deps_dev.v3.Dependencies.Node
	(*Dependencies_Edge)(nil),                              // 51: deps_dev.v3.Dependencies.Edge
	(*Project_Scorecard)(nil),                              // 52: deps_dev.v3.Project.Scorecard
	(*Project_OSSFuzzDetails)(nil),                         // 53: deps_dev.v3.Project.OSSFuzzDetails
	(*Project_Scorecard_Repository)(nil),                   // 54: deps_dev.v3.Project.Scorecard.Repository
	(*Project_Scorecard_ScorecardDetails)(nil),             // 55: deps_dev.v3.Project.Scorecard.ScorecardDetails
	(*Project_Scorecard_Check)(nil),                        // 56: deps_dev.v3.Project.Scorecard.Check
	(*Project_Scorecard_Check_Documentation)(nil),          // 57: deps_dev.v3.Project.Scorecard.Check.Documentation
	(*ProjectPackageVersions_Version)(nil),                 // 58: deps_dev.v3.ProjectPackageVersions.Version
	(*QueryResult_Result)(nil),                             // 59: deps_dev.v3.QueryResult.Result
	(*timestamppb.Timestamp)(nil),                          // 60: google.protobuf.Timestamp
}
var file_api_proto_depIdxs = []int32{
	0,  // 0: deps_dev.v3.PackageKey.system:type_name -> deps_dev.v3.System
	0,  // 1: deps_dev.v3.VersionKey.system:type_name -> deps_dev.v3.System
	1,  // 2: deps_dev.v3.Hash.type:type_name -> deps_dev.v3.HashType
	5,  // 3: deps_dev.v3.GetPackageRequest.package_key:type_name -> deps_dev.v3.PackageKey
	5,  // 4: deps_dev.v3.Package.package_key:type_name -> deps_dev.v3.PackageKey
	29, // 5: deps_dev.v3.Package.versions:type_name -> deps_dev.v3.Package.Version
	6,  // 6: deps_dev.v3.GetVersionRequest.version_key:type_name -> deps_dev.v3.VersionKey
	6,  // 7: deps_dev.v3.Version.version_key:type_name -> deps_dev.v3.VersionKey
	60, // 8: deps_dev.v3.Version.published_at:type_name -> google.protobuf.Timestamp
	8,  // 9: deps_dev.v3.Version.advisory_keys:type_name -> deps_dev.v3.AdvisoryKey
	10, // 10: deps_dev.v3.Version.links:type_name -> deps_dev.v3.Link
	11, // 11: deps_dev.v3.Version.slsa_provenances:type_name -> deps_dev.v3.SLSAProvenance
	12, // 12: deps_dev.v3.Version.attestations:type_name -> deps_dev.v3.Attestation
	30, // 13: deps_dev.v3.Version.related_projects:type_name -> deps_dev.v3.Version.Project
	6,  // 14: deps_dev.v3.GetRequirementsRequest.version_key:type_name -> deps_dev.v3.VersionKey
	31, // 15: deps_dev.v3.Requirements.nuget:type_name -> deps_dev.v3.Requirements.NuGet
	32, // 16: deps_dev.v3.Requirements.npm:type_name -> deps_dev.v3.Requirements.NPM
	33, // 17: deps_dev.v3.Requirements.maven:type_name -> deps_dev.v3.Requirements.Maven
	34, // 18: deps_dev.v3.Requirements.rubygems:type_name -> deps_dev.v3.Requirements.RubyGems
	6,  // 19: deps_dev.v3.GetDependenciesRequest.version_key:type_name -> deps_dev.v3.VersionKey
	50, // 20: deps_dev.v3.Dependencies.nodes:type_name -> deps_dev.v3.Dependencies.Node
	51, // 21: deps_dev.v3.Dependencies.edges:type_name -> deps_dev.v3.Dependencies.Edge
	7,  // 22: deps_dev.v3.GetProjectRequest.project_key:type_name -> deps_dev.v3.ProjectKey
	7,  // 23: deps_dev.v3.Project.project_key:type_name -> deps_dev.v3.ProjectKey
	52, // 24: deps_dev.v3.Project.scorecard:type_name -> deps_dev.v3.Project.Scorecard
	53, // 25: deps_dev.v3.Project.oss_fuzz:type_name -> deps_dev.v3.Project.OSSFuzzDetails
	7,  // 26: deps_dev.v3.GetProjectPackageVersionsRequest.project_key:type_name -> deps_dev.v3.ProjectKey
	58, // 27: deps_dev.v3.ProjectPackageVersions.versions:type_name -> deps_dev.v3.ProjectPackageVersions.Version
	8,  // 28: deps_dev.v3.GetAdvisoryRequest.advisory_key:type_name -> deps_dev.v3.AdvisoryKey
	8,  // 29: deps_dev.v3.Advisory.advisory_key:type_name -> deps_dev.v3.AdvisoryKey
	9,  // 30: deps_dev.v3.QueryRequest.hash:type_name -> deps_dev.v3.Hash
	6,  // 31: deps_dev.v3.QueryRequest.version_key:type_name -> deps_dev.v3.VersionKey
	59, // 32: deps_dev.v3.QueryResult.results:type_name -> deps_dev.v3.QueryResult.Result
	6,  // 33: deps_dev.v3.Package.Version.version_key:type_name -> deps_dev.v3.VersionKey
	60, // 34: deps_dev.v3.Package.Version.published_at:type_name -> google.protobuf.Timestamp
	7,  // 35: deps_dev.v3.Version.Project.project_key:type_name -> deps_dev.v3.ProjectKey
	4,  // 36: deps_dev.v3.Version.Project.relation_provenance:type_name -> deps_dev.v3.ProjectRelationProvenance
	3,  // 37: deps_dev.v3.Version.Project.relation_type:type_name -> deps_dev.v3.ProjectRelationType
	35, // 38: deps_dev.v3.Requirements.NuGet.dependency_groups:type_name -> deps_dev.v3.Requirements.NuGet.DependencyGroup
	37, // 39: deps_dev.v3.Requirements.NPM.dependencies:type_name -> deps_dev.v3.Requirements.NPM.Dependencies
	38, // 40: deps_dev.v3.Requirements.NPM.bundled:type_name -> deps_dev.v3.Requirements.NPM.Bundle
	6,  // 41: deps_dev.v3.Requirements.Maven.parent:type_name -> deps_dev.v3.VersionKey
	40, // 42: deps_dev.v3.Requirements.Maven.dependencies:type_name -> deps_dev.v3.Requirements.Maven.Dependency
	40, // 43: deps_dev.v3.Requirements.Maven.dependency_management:type_name -> deps_dev.v3.Requirements.Maven.Dependency
	41, // 44: deps_dev.v3.Requirements.Maven.properties:type_name -> deps_dev.v3.Requirements.Maven.Property
	42, // 45: deps_dev.v3.Requirements.Maven.repositories:type_name -> deps_dev.v3.Requirements.Maven.Repository
	43, // 46: deps_dev.v3.Requirements.Maven.profiles:type_name -> deps_dev.v3.Requirements.Maven.Profile
	49, // 47: deps_dev.v3.Requirements.RubyGems.runtime_dependencies:type_name -> deps_dev.v3.Requirements.RubyGems.Dependency
	49, // 48: deps_dev.v3.Requirements.RubyGems.dev_dependencies:type_name -> deps_dev.v3.Requirements.RubyGems.Dependency
	36, // 49: deps_dev.v3.Requirements.NuGet.DependencyGroup.dependencies:type_name -> deps_dev.v3.Requirements.NuGet.DependencyGroup.Dependency
	39, // 50: deps_dev.v3.Requirements.NPM.Dependencies.dependencies:type_name -> deps_dev.v3.Requirements.NPM.Dependencies.Dependency
	39, // 51: deps_dev.v3.Requirements.NPM.Dependencies.dev_dependencies:type_name -> deps_dev.v3.Requirements.NPM.Dependencies.Dependency
	39, // 52: deps_dev.v3.Requirements.NPM.Dependencies.optional_dependencies:type_name -> deps_dev.v3.Requirements.NPM.Dependencies.Dependency
	39, // 53: deps_dev.v3.Requirements.NPM.Dependencies.peer_dependencies:type_name -> deps_dev.v3.Requirements.NPM.Dependencies.Dependency
	37, // 54: deps_dev.v3.Requirements.NPM.Bundle.dependencies:type_name -> deps_dev.v3.Requirements.NPM.Dependencies
	44, // 55: deps_dev.v3.Requirements.Maven.Profile.activation:type_name -> deps_dev.v3.Requirements.Maven.Profile.Activation
	40, // 56: deps_dev.v3.Requirements.Maven.Profile.dependencies:type_name -> deps_dev.v3.Requirements.Maven.Dependency
	40, // 57: deps_dev.v3.Requirements.Maven.Profile.dependency_management:type_name -> deps_dev.v3.Requirements.Maven.Dependency
	41, // 58: deps_dev.v3.Requirements.Maven.Profile.properties:type_name -> deps_dev.v3.Requirements.Maven.Property
	42, // 59: deps_dev.v3.Requirements.Maven.Profile.repositories:type_name -> deps_dev.v3.Requirements.Maven.Repository
	45, // 60: deps_dev.v3.Requirements.Maven.Profile.Activation.jdk:type_name -> deps_dev.v3.Requirements.Maven.Profile.Activation.JDK
	46, // 61: deps_dev.v3.Requirements.Maven.Profile.Activation.os:type_name -> deps_dev.v3.Requirements.Maven.Profile.Activation.OS
	47, // 62: deps_dev.v3.Requirements.Maven.Profile.Activation.property:type_name -> deps_dev.v3.Requirements.Maven.Profile.Activation.Property
	48, // 63: deps_dev.v3.Requirements.Maven.Profile.Activation.file:type_name -> deps_dev.v3.Requirements.Maven.Profile.Activation.File
	41, // 64: deps_dev.v3.Requirements.Maven.Profile.Activation.Property.property:type_name -> deps_dev.v3.Requirements.Maven.Property
	6,  // 65: deps_dev.v3.Dependencies.Node.version_key:type_name -> deps_dev.v3.VersionKey
	2,  // 66: deps_dev.v3.Dependencies.Node.relation:type_name -> deps_dev.v3.DependencyRelation
	60, // 67: deps_dev.v3.Project.Scorecard.date:type_name -> google.protobuf.Timestamp
	54, // 68: deps_dev.v3.Project.Scorecard.repository:type_name -> deps_dev.v3.Project.Scorecard.Repository
	55, // 69: deps_dev.v3.Project.Scorecard.scorecard:type_name -> deps_dev.v3.Project.Scorecard.ScorecardDetails
	56, // 70: deps_dev.v3.Project.Scorecard.checks:type_name -> deps_dev.v3.Project.Scorecard.Check
	60, // 71: deps_dev.v3.Project.OSSFuzzDetails.date:type_name -> google.protobuf.Timestamp
	57, // 72: deps_dev.v3.Project.Scorecard.Check.documentation:type_name -> deps_dev.v3.Project.Scorecard.Check.Documentation
	6,  // 73: deps_dev.v3.ProjectPackageVersions.Version.version_key:type_name -> deps_dev.v3.VersionKey
	11, // 74: deps_dev.v3.ProjectPackageVersions.Version.slsa_provenances:type_name -> deps_dev.v3.SLSAProvenance
	12, // 75: deps_dev.v3.ProjectPackageVersions.Version.attestations:type_name -> deps_dev.v3.Attestation
	3,  // 76: deps_dev.v3.ProjectPackageVersions.Version.relation_type:type_name -> deps_dev.v3.ProjectRelationType
	4,  // 77: deps_dev.v3.ProjectPackageVersions.Version.relation_provenance:type_name -> deps_dev.v3.ProjectRelationProvenance
	16, // 78: deps_dev.v3.QueryResult.Result.version:type_name -> deps_dev.v3.Version
	13, // 79: deps_dev.v3.Insights.GetPackage:input_type -> deps_dev.v3.GetPackageRequest
	15, // 80: deps_dev.v3.Insights.GetVersion:input_type -> deps_dev.v3.GetVersionRequest
	17, // 81: deps_dev.v3.Insights.GetRequirements:input_type -> deps_dev.v3.GetRequirementsRequest
	19, // 82: deps_dev.v3.Insights.GetDependencies:input_type -> deps_dev.v3.GetDependenciesRequest
	21, // 83: deps_dev.v3.Insights.GetProject:input_type -> deps_dev.v3.GetProjectRequest
	23, // 84: deps_dev.v3.Insights.GetProjectPackageVersions:input_type -> deps_dev.v3.GetProjectPackageVersionsRequest
	25, // 85: deps_dev.v3.Insights.GetAdvisory:input_type -> deps_dev.v3.GetAdvisoryRequest
	27, // 86: deps_dev.v3.Insights.Query:input_type -> deps_dev.v3.QueryRequest
	14, // 87: deps_dev.v3.Insights.GetPackage:output_type -> deps_dev.v3.Package
	16, // 88: deps_dev.v3.Insights.GetVersion:output_type -> deps_dev.v3.Version
	18, // 89: deps_dev.v3.Insights.GetRequirements:output_type -> deps_dev.v3.Requirements
	20, // 90: deps_dev.v3.Insights.GetDependencies:output_type -> deps_dev.v3.Dependencies
	22, // 91: deps_dev.v3.Insights.GetProject:output_type -> deps_dev.v3.Project
	24, // 92: deps_dev.v3.Insights.GetProjectPackageVersions:output_type -> deps_dev.v3.ProjectPackageVersions
	26, // 93: deps_dev.v3.Insights.GetAdvisory:output_type -> deps_dev.v3.Advisory
	28, // 94: deps_dev.v3.Insights.Query:output_type -> deps_dev.v3.QueryResult
	87, // [87:95] is the sub-list for method output_type
	79, // [79:87] is the sub-list for method input_type
	79, // [79:79] is the sub-list for extension type_name
	79, // [79:79] is the sub-list for extension extendee
	0,  // [0:79] is the sub-list for field type_name
}

func init() { file_api_proto_init() }
func file_api_proto_init() {
	if File_api_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdvisoryKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Hash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Link); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SLSAProvenance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Attestation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPackageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Package); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Version); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRequirementsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDependenciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dependencies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Project); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProjectPackageVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectPackageVersions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAdvisoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Advisory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Package_Version); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Version_Project); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_NuGet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_NPM); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_RubyGems); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_NuGet_DependencyGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_NuGet_DependencyGroup_Dependency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_NPM_Dependencies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_NPM_Bundle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_NPM_Dependencies_Dependency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Dependency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Repository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Profile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Profile_Activation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Profile_Activation_JDK); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Profile_Activation_OS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Profile_Activation_Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_Maven_Profile_Activation_File); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Requirements_RubyGems_Dependency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dependencies_Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dependencies_Edge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Project_Scorecard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Project_OSSFuzzDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Project_Scorecard_Repository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Project_Scorecard_ScorecardDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Project_Scorecard_Check); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Project_Scorecard_Check_Documentation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectPackageVersions_Version); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResult_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_api_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   55,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_api_proto_goTypes,
		DependencyIndexes: file_api_proto_depIdxs,
		EnumInfos:         file_api_proto_enumTypes,
		MessageInfos:      file_api_proto_msgTypes,
	}.Build()
	File_api_proto = out.File
	file_api_proto_rawDesc = nil
	file_api_proto_goTypes = nil
	file_api_proto_depIdxs = nil
}
