package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConsortium invokes the baas.CreateConsortium API synchronously
// api document: https://help.aliyun.com/api/baas/createconsortium.html
func (client *Client) CreateConsortium(request *CreateConsortiumRequest) (response *CreateConsortiumResponse, err error) {
	response = CreateCreateConsortiumResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConsortiumWithChan invokes the baas.CreateConsortium API asynchronously
// api document: https://help.aliyun.com/api/baas/createconsortium.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateConsortiumWithChan(request *CreateConsortiumRequest) (<-chan *CreateConsortiumResponse, <-chan error) {
	responseChan := make(chan *CreateConsortiumResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConsortium(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConsortiumWithCallback invokes the baas.CreateConsortium API asynchronously
// api document: https://help.aliyun.com/api/baas/createconsortium.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateConsortiumWithCallback(request *CreateConsortiumRequest, callback func(response *CreateConsortiumResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConsortiumResponse
		var err error
		defer close(result)
		response, err = client.CreateConsortium(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConsortiumRequest is the request struct for api CreateConsortium
type CreateConsortiumRequest struct {
	*requests.RpcRequest
	OrderersCount requests.Integer                `position:"Body" name:"OrderersCount"`
	Domain        string                          `position:"Body" name:"Domain"`
	SpecName      string                          `position:"Body" name:"SpecName"`
	Organization  *[]CreateConsortiumOrganization `position:"Body" name:"Organization"  type:"Repeated"`
	Name          string                          `position:"Body" name:"Name"`
	OrdererType   string                          `position:"Body" name:"OrdererType"`
	ZoneId        string                          `position:"Body" name:"ZoneId"`
	Description   string                          `position:"Body" name:"Description"`
	Location      string                          `position:"Body" name:"Location"`
	PeersCount    requests.Integer                `position:"Body" name:"PeersCount"`
	ChannelPolicy string                          `position:"Body" name:"ChannelPolicy"`
}

// CreateConsortiumOrganization is a repeated param struct in CreateConsortiumRequest
type CreateConsortiumOrganization struct {
	Id string `name:"Id"`
}

// CreateConsortiumResponse is the response struct for api CreateConsortium
type CreateConsortiumResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorCode int                      `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInCreateConsortium `json:"Result" xml:"Result"`
}

// CreateCreateConsortiumRequest creates a request to invoke CreateConsortium API
func CreateCreateConsortiumRequest() (request *CreateConsortiumRequest) {
	request = &CreateConsortiumRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "CreateConsortium", "", "")
	return
}

// CreateCreateConsortiumResponse creates a response to parse from CreateConsortium response
func CreateCreateConsortiumResponse() (response *CreateConsortiumResponse) {
	response = &CreateConsortiumResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
