package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBlockchainCreateTask invokes the baas.DescribeBlockchainCreateTask API synchronously
// api document: https://help.aliyun.com/api/baas/describeblockchaincreatetask.html
func (client *Client) DescribeBlockchainCreateTask(request *DescribeBlockchainCreateTaskRequest) (response *DescribeBlockchainCreateTaskResponse, err error) {
	response = CreateDescribeBlockchainCreateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBlockchainCreateTaskWithChan invokes the baas.DescribeBlockchainCreateTask API asynchronously
// api document: https://help.aliyun.com/api/baas/describeblockchaincreatetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBlockchainCreateTaskWithChan(request *DescribeBlockchainCreateTaskRequest) (<-chan *DescribeBlockchainCreateTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeBlockchainCreateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBlockchainCreateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBlockchainCreateTaskWithCallback invokes the baas.DescribeBlockchainCreateTask API asynchronously
// api document: https://help.aliyun.com/api/baas/describeblockchaincreatetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBlockchainCreateTaskWithCallback(request *DescribeBlockchainCreateTaskRequest, callback func(response *DescribeBlockchainCreateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBlockchainCreateTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeBlockchainCreateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBlockchainCreateTaskRequest is the request struct for api DescribeBlockchainCreateTask
type DescribeBlockchainCreateTaskRequest struct {
	*requests.RpcRequest
	Current  requests.Integer `position:"Body" name:"Current"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
}

// DescribeBlockchainCreateTaskResponse is the response struct for api DescribeBlockchainCreateTask
type DescribeBlockchainCreateTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeBlockchainCreateTaskRequest creates a request to invoke DescribeBlockchainCreateTask API
func CreateDescribeBlockchainCreateTaskRequest() (request *DescribeBlockchainCreateTaskRequest) {
	request = &DescribeBlockchainCreateTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeBlockchainCreateTask", "", "")
	return
}

// CreateDescribeBlockchainCreateTaskResponse creates a response to parse from DescribeBlockchainCreateTask response
func CreateDescribeBlockchainCreateTaskResponse() (response *DescribeBlockchainCreateTaskResponse) {
	response = &DescribeBlockchainCreateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
