package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiums invokes the baas.DescribeConsortiums API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiums.html
func (client *Client) DescribeConsortiums(request *DescribeConsortiumsRequest) (response *DescribeConsortiumsResponse, err error) {
	response = CreateDescribeConsortiumsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumsWithChan invokes the baas.DescribeConsortiums API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiums.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumsWithChan(request *DescribeConsortiumsRequest) (<-chan *DescribeConsortiumsResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiums(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumsWithCallback invokes the baas.DescribeConsortiums API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiums.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumsWithCallback(request *DescribeConsortiumsRequest, callback func(response *DescribeConsortiumsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumsResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiums(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumsRequest is the request struct for api DescribeConsortiums
type DescribeConsortiumsRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Query" name:"ConsortiumId"`
}

// DescribeConsortiumsResponse is the response struct for api DescribeConsortiums
type DescribeConsortiumsResponse struct {
	*responses.BaseResponse
	RequestId string                            `json:"RequestId" xml:"RequestId"`
	Success   bool                              `json:"Success" xml:"Success"`
	ErrorCode int                               `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItemInDescribeConsortiums `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumsRequest creates a request to invoke DescribeConsortiums API
func CreateDescribeConsortiumsRequest() (request *DescribeConsortiumsRequest) {
	request = &DescribeConsortiumsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiums", "", "")
	return
}

// CreateDescribeConsortiumsResponse creates a response to parse from DescribeConsortiums response
func CreateDescribeConsortiumsResponse() (response *DescribeConsortiumsResponse) {
	response = &DescribeConsortiumsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
