package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMyBlockchains invokes the baas.GetMyBlockchains API synchronously
// api document: https://help.aliyun.com/api/baas/getmyblockchains.html
func (client *Client) GetMyBlockchains(request *GetMyBlockchainsRequest) (response *GetMyBlockchainsResponse, err error) {
	response = CreateGetMyBlockchainsResponse()
	err = client.DoAction(request, response)
	return
}

// GetMyBlockchainsWithChan invokes the baas.GetMyBlockchains API asynchronously
// api document: https://help.aliyun.com/api/baas/getmyblockchains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMyBlockchainsWithChan(request *GetMyBlockchainsRequest) (<-chan *GetMyBlockchainsResponse, <-chan error) {
	responseChan := make(chan *GetMyBlockchainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMyBlockchains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMyBlockchainsWithCallback invokes the baas.GetMyBlockchains API asynchronously
// api document: https://help.aliyun.com/api/baas/getmyblockchains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMyBlockchainsWithCallback(request *GetMyBlockchainsRequest, callback func(response *GetMyBlockchainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMyBlockchainsResponse
		var err error
		defer close(result)
		response, err = client.GetMyBlockchains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMyBlockchainsRequest is the request struct for api GetMyBlockchains
type GetMyBlockchainsRequest struct {
	*requests.RpcRequest
}

// GetMyBlockchainsResponse is the response struct for api GetMyBlockchains
type GetMyBlockchainsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateGetMyBlockchainsRequest creates a request to invoke GetMyBlockchains API
func CreateGetMyBlockchainsRequest() (request *GetMyBlockchainsRequest) {
	request = &GetMyBlockchainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "GetMyBlockchains", "", "")
	return
}

// CreateGetMyBlockchainsResponse creates a response to parse from GetMyBlockchains response
func CreateGetMyBlockchainsResponse() (response *GetMyBlockchainsResponse) {
	response = &GetMyBlockchainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
