package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetPageCompressConfig invokes the cdn.SetPageCompressConfig API synchronously
// api document: https://help.aliyun.com/api/cdn/setpagecompressconfig.html
func (client *Client) SetPageCompressConfig(request *SetPageCompressConfigRequest) (response *SetPageCompressConfigResponse, err error) {
	response = CreateSetPageCompressConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetPageCompressConfigWithChan invokes the cdn.SetPageCompressConfig API asynchronously
// api document: https://help.aliyun.com/api/cdn/setpagecompressconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetPageCompressConfigWithChan(request *SetPageCompressConfigRequest) (<-chan *SetPageCompressConfigResponse, <-chan error) {
	responseChan := make(chan *SetPageCompressConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetPageCompressConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetPageCompressConfigWithCallback invokes the cdn.SetPageCompressConfig API asynchronously
// api document: https://help.aliyun.com/api/cdn/setpagecompressconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetPageCompressConfigWithCallback(request *SetPageCompressConfigRequest, callback func(response *SetPageCompressConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetPageCompressConfigResponse
		var err error
		defer close(result)
		response, err = client.SetPageCompressConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetPageCompressConfigRequest is the request struct for api SetPageCompressConfig
type SetPageCompressConfigRequest struct {
	*requests.RpcRequest
	Enable     string           `position:"Query" name:"Enable"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	ConfigId   requests.Integer `position:"Query" name:"ConfigId"`
}

// SetPageCompressConfigResponse is the response struct for api SetPageCompressConfig
type SetPageCompressConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetPageCompressConfigRequest creates a request to invoke SetPageCompressConfig API
func CreateSetPageCompressConfigRequest() (request *SetPageCompressConfigRequest) {
	request = &SetPageCompressConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "SetPageCompressConfig", "", "")
	return
}

// CreateSetPageCompressConfigResponse creates a response to parse from SetPageCompressConfig response
func CreateSetPageCompressConfigResponse() (response *SetPageCompressConfigResponse) {
	response = &SetPageCompressConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
