package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMonitoringTemplate invokes the cms.DeleteMonitoringTemplate API synchronously
// api document: https://help.aliyun.com/api/cms/deletemonitoringtemplate.html
func (client *Client) DeleteMonitoringTemplate(request *DeleteMonitoringTemplateRequest) (response *DeleteMonitoringTemplateResponse, err error) {
	response = CreateDeleteMonitoringTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMonitoringTemplateWithChan invokes the cms.DeleteMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/deletemonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMonitoringTemplateWithChan(request *DeleteMonitoringTemplateRequest) (<-chan *DeleteMonitoringTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteMonitoringTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMonitoringTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMonitoringTemplateWithCallback invokes the cms.DeleteMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/deletemonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMonitoringTemplateWithCallback(request *DeleteMonitoringTemplateRequest, callback func(response *DeleteMonitoringTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMonitoringTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteMonitoringTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMonitoringTemplateRequest is the request struct for api DeleteMonitoringTemplate
type DeleteMonitoringTemplateRequest struct {
	*requests.RpcRequest
	Id string `position:"Query" name:"Id"`
}

// DeleteMonitoringTemplateResponse is the response struct for api DeleteMonitoringTemplate
type DeleteMonitoringTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string                             `json:"RequestId" xml:"RequestId"`
	Success      bool                               `json:"Success" xml:"Success"`
	ErrorCode    int                                `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                             `json:"ErrorMessage" xml:"ErrorMessage"`
	Resource     ResourceInDeleteMonitoringTemplate `json:"Resource" xml:"Resource"`
}

// CreateDeleteMonitoringTemplateRequest creates a request to invoke DeleteMonitoringTemplate API
func CreateDeleteMonitoringTemplateRequest() (request *DeleteMonitoringTemplateRequest) {
	request = &DeleteMonitoringTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "DeleteMonitoringTemplate", "cms", "openAPI")
	return
}

// CreateDeleteMonitoringTemplateResponse creates a response to parse from DeleteMonitoringTemplate response
func CreateDeleteMonitoringTemplateResponse() (response *DeleteMonitoringTemplateResponse) {
	response = &DeleteMonitoringTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
