package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableEventRule invokes the cms.EnableEventRule API synchronously
// api document: https://help.aliyun.com/api/cms/enableeventrule.html
func (client *Client) EnableEventRule(request *EnableEventRuleRequest) (response *EnableEventRuleResponse, err error) {
	response = CreateEnableEventRuleResponse()
	err = client.DoAction(request, response)
	return
}

// EnableEventRuleWithChan invokes the cms.EnableEventRule API asynchronously
// api document: https://help.aliyun.com/api/cms/enableeventrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableEventRuleWithChan(request *EnableEventRuleRequest) (<-chan *EnableEventRuleResponse, <-chan error) {
	responseChan := make(chan *EnableEventRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableEventRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableEventRuleWithCallback invokes the cms.EnableEventRule API asynchronously
// api document: https://help.aliyun.com/api/cms/enableeventrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableEventRuleWithCallback(request *EnableEventRuleRequest, callback func(response *EnableEventRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableEventRuleResponse
		var err error
		defer close(result)
		response, err = client.EnableEventRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableEventRuleRequest is the request struct for api EnableEventRule
type EnableEventRuleRequest struct {
	*requests.RpcRequest
	RuleNames *[]string `position:"Query" name:"RuleNames"  type:"Repeated"`
	RuleName  string    `position:"Query" name:"RuleName"`
}

// EnableEventRuleResponse is the response struct for api EnableEventRule
type EnableEventRuleResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableEventRuleRequest creates a request to invoke EnableEventRule API
func CreateEnableEventRuleRequest() (request *EnableEventRuleRequest) {
	request = &EnableEventRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "EnableEventRule", "cms", "openAPI")
	return
}

// CreateEnableEventRuleResponse creates a response to parse from EnableEventRule response
func CreateEnableEventRuleResponse() (response *EnableEventRuleResponse) {
	response = &EnableEventRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
