package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEventRules invokes the cms.ListEventRules API synchronously
// api document: https://help.aliyun.com/api/cms/listeventrules.html
func (client *Client) ListEventRules(request *ListEventRulesRequest) (response *ListEventRulesResponse, err error) {
	response = CreateListEventRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListEventRulesWithChan invokes the cms.ListEventRules API asynchronously
// api document: https://help.aliyun.com/api/cms/listeventrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEventRulesWithChan(request *ListEventRulesRequest) (<-chan *ListEventRulesResponse, <-chan error) {
	responseChan := make(chan *ListEventRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEventRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEventRulesWithCallback invokes the cms.ListEventRules API asynchronously
// api document: https://help.aliyun.com/api/cms/listeventrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEventRulesWithCallback(request *ListEventRulesRequest, callback func(response *ListEventRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEventRulesResponse
		var err error
		defer close(result)
		response, err = client.ListEventRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEventRulesRequest is the request struct for api ListEventRules
type ListEventRulesRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	PageSize   string `position:"Query" name:"PageSize"`
	NamePrefix string `position:"Query" name:"NamePrefix"`
	Page       string `position:"Query" name:"Page"`
}

// ListEventRulesResponse is the response struct for api ListEventRules
type ListEventRulesResponse struct {
	*responses.BaseResponse
	Success     bool                       `json:"Success" xml:"Success"`
	Code        string                     `json:"Code" xml:"Code"`
	Message     string                     `json:"Message" xml:"Message"`
	RequestId   string                     `json:"RequestId" xml:"RequestId"`
	Total       int                        `json:"Total" xml:"Total"`
	CurrentPage int                        `json:"CurrentPage" xml:"CurrentPage"`
	NextToken   string                     `json:"NextToken" xml:"NextToken"`
	Datapoints  DatapointsInListEventRules `json:"Datapoints" xml:"Datapoints"`
}

// CreateListEventRulesRequest creates a request to invoke ListEventRules API
func CreateListEventRulesRequest() (request *ListEventRulesRequest) {
	request = &ListEventRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "ListEventRules", "cms", "openAPI")
	return
}

// CreateListEventRulesResponse creates a response to parse from ListEventRules response
func CreateListEventRulesResponse() (response *ListEventRulesResponse) {
	response = &ListEventRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
