package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryStaticsErrorRate invokes the cms.QueryStaticsErrorRate API synchronously
// api document: https://help.aliyun.com/api/cms/querystaticserrorrate.html
func (client *Client) QueryStaticsErrorRate(request *QueryStaticsErrorRateRequest) (response *QueryStaticsErrorRateResponse, err error) {
	response = CreateQueryStaticsErrorRateResponse()
	err = client.DoAction(request, response)
	return
}

// QueryStaticsErrorRateWithChan invokes the cms.QueryStaticsErrorRate API asynchronously
// api document: https://help.aliyun.com/api/cms/querystaticserrorrate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryStaticsErrorRateWithChan(request *QueryStaticsErrorRateRequest) (<-chan *QueryStaticsErrorRateResponse, <-chan error) {
	responseChan := make(chan *QueryStaticsErrorRateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryStaticsErrorRate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryStaticsErrorRateWithCallback invokes the cms.QueryStaticsErrorRate API asynchronously
// api document: https://help.aliyun.com/api/cms/querystaticserrorrate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryStaticsErrorRateWithCallback(request *QueryStaticsErrorRateRequest, callback func(response *QueryStaticsErrorRateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryStaticsErrorRateResponse
		var err error
		defer close(result)
		response, err = client.QueryStaticsErrorRate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryStaticsErrorRateRequest is the request struct for api QueryStaticsErrorRate
type QueryStaticsErrorRateRequest struct {
	*requests.RpcRequest
	TimeRange string `position:"Query" name:"TimeRange"`
	TaskId    string `position:"Query" name:"TaskId"`
}

// QueryStaticsErrorRateResponse is the response struct for api QueryStaticsErrorRate
type QueryStaticsErrorRateResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateQueryStaticsErrorRateRequest creates a request to invoke QueryStaticsErrorRate API
func CreateQueryStaticsErrorRateRequest() (request *QueryStaticsErrorRateRequest) {
	request = &QueryStaticsErrorRateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryStaticsErrorRate", "cms", "openAPI")
	return
}

// CreateQueryStaticsErrorRateResponse creates a response to parse from QueryStaticsErrorRate response
func CreateQueryStaticsErrorRateResponse() (response *QueryStaticsErrorRateResponse) {
	response = &QueryStaticsErrorRateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
