package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDrdsDBIpWhiteList invokes the drds.DescribeDrdsDBIpWhiteList API synchronously
// api document: https://help.aliyun.com/api/drds/describedrdsdbipwhitelist.html
func (client *Client) DescribeDrdsDBIpWhiteList(request *DescribeDrdsDBIpWhiteListRequest) (response *DescribeDrdsDBIpWhiteListResponse, err error) {
	response = CreateDescribeDrdsDBIpWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDrdsDBIpWhiteListWithChan invokes the drds.DescribeDrdsDBIpWhiteList API asynchronously
// api document: https://help.aliyun.com/api/drds/describedrdsdbipwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDrdsDBIpWhiteListWithChan(request *DescribeDrdsDBIpWhiteListRequest) (<-chan *DescribeDrdsDBIpWhiteListResponse, <-chan error) {
	responseChan := make(chan *DescribeDrdsDBIpWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDrdsDBIpWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDrdsDBIpWhiteListWithCallback invokes the drds.DescribeDrdsDBIpWhiteList API asynchronously
// api document: https://help.aliyun.com/api/drds/describedrdsdbipwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDrdsDBIpWhiteListWithCallback(request *DescribeDrdsDBIpWhiteListRequest, callback func(response *DescribeDrdsDBIpWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDrdsDBIpWhiteListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDrdsDBIpWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDrdsDBIpWhiteListRequest is the request struct for api DescribeDrdsDBIpWhiteList
type DescribeDrdsDBIpWhiteListRequest struct {
	*requests.RpcRequest
	DbName         string `position:"Query" name:"DbName"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	GroupName      string `position:"Query" name:"GroupName"`
}

// DescribeDrdsDBIpWhiteListResponse is the response struct for api DescribeDrdsDBIpWhiteList
type DescribeDrdsDBIpWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeDrdsDBIpWhiteListRequest creates a request to invoke DescribeDrdsDBIpWhiteList API
func CreateDescribeDrdsDBIpWhiteListRequest() (request *DescribeDrdsDBIpWhiteListRequest) {
	request = &DescribeDrdsDBIpWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "DescribeDrdsDBIpWhiteList", "", "")
	return
}

// CreateDescribeDrdsDBIpWhiteListResponse creates a response to parse from DescribeDrdsDBIpWhiteList response
func CreateDescribeDrdsDBIpWhiteListResponse() (response *DescribeDrdsDBIpWhiteListResponse) {
	response = &DescribeDrdsDBIpWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
