package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateJobFile invokes the ehpc.CreateJobFile API synchronously
// api document: https://help.aliyun.com/api/ehpc/createjobfile.html
func (client *Client) CreateJobFile(request *CreateJobFileRequest) (response *CreateJobFileResponse, err error) {
	response = CreateCreateJobFileResponse()
	err = client.DoAction(request, response)
	return
}

// CreateJobFileWithChan invokes the ehpc.CreateJobFile API asynchronously
// api document: https://help.aliyun.com/api/ehpc/createjobfile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateJobFileWithChan(request *CreateJobFileRequest) (<-chan *CreateJobFileResponse, <-chan error) {
	responseChan := make(chan *CreateJobFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateJobFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateJobFileWithCallback invokes the ehpc.CreateJobFile API asynchronously
// api document: https://help.aliyun.com/api/ehpc/createjobfile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateJobFileWithCallback(request *CreateJobFileRequest, callback func(response *CreateJobFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateJobFileResponse
		var err error
		defer close(result)
		response, err = client.CreateJobFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateJobFileRequest is the request struct for api CreateJobFile
type CreateJobFileRequest struct {
	*requests.RpcRequest
	TargetFile        string `position:"Query" name:"TargetFile"`
	RunasUserPassword string `position:"Query" name:"RunasUserPassword"`
	RunasUser         string `position:"Query" name:"RunasUser"`
	ClusterId         string `position:"Query" name:"ClusterId"`
	Content           string `position:"Query" name:"Content"`
}

// CreateJobFileResponse is the response struct for api CreateJobFile
type CreateJobFileResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TemplateId string `json:"TemplateId" xml:"TemplateId"`
}

// CreateCreateJobFileRequest creates a request to invoke CreateJobFile API
func CreateCreateJobFileRequest() (request *CreateJobFileRequest) {
	request = &CreateJobFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "CreateJobFile", "ehs", "openAPI")
	return
}

// CreateCreateJobFileResponse creates a response to parse from CreateJobFile response
func CreateCreateJobFileResponse() (response *CreateJobFileResponse) {
	response = &CreateJobFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
