package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddClusterService invokes the emr.AddClusterService API synchronously
// api document: https://help.aliyun.com/api/emr/addclusterservice.html
func (client *Client) AddClusterService(request *AddClusterServiceRequest) (response *AddClusterServiceResponse, err error) {
	response = CreateAddClusterServiceResponse()
	err = client.DoAction(request, response)
	return
}

// AddClusterServiceWithChan invokes the emr.AddClusterService API asynchronously
// api document: https://help.aliyun.com/api/emr/addclusterservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddClusterServiceWithChan(request *AddClusterServiceRequest) (<-chan *AddClusterServiceResponse, <-chan error) {
	responseChan := make(chan *AddClusterServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddClusterService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddClusterServiceWithCallback invokes the emr.AddClusterService API asynchronously
// api document: https://help.aliyun.com/api/emr/addclusterservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddClusterServiceWithCallback(request *AddClusterServiceRequest, callback func(response *AddClusterServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddClusterServiceResponse
		var err error
		defer close(result)
		response, err = client.AddClusterService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddClusterServiceRequest is the request struct for api AddClusterService
type AddClusterServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer            `position:"Query" name:"ResourceOwnerId"`
	Service         *[]AddClusterServiceService `position:"Query" name:"Service"  type:"Repeated"`
	Comment         string                      `position:"Query" name:"Comment"`
	ClusterId       string                      `position:"Query" name:"ClusterId"`
}

// AddClusterServiceService is a repeated param struct in AddClusterServiceRequest
type AddClusterServiceService struct {
	ServiceName string `name:"ServiceName"`
}

// AddClusterServiceResponse is the response struct for api AddClusterService
type AddClusterServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddClusterServiceRequest creates a request to invoke AddClusterService API
func CreateAddClusterServiceRequest() (request *AddClusterServiceRequest) {
	request = &AddClusterServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "AddClusterService", "emr", "openAPI")
	return
}

// CreateAddClusterServiceResponse creates a response to parse from AddClusterService response
func CreateAddClusterServiceResponse() (response *AddClusterServiceResponse) {
	response = &AddClusterServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
