package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAlertDingDingGroup invokes the emr.CreateAlertDingDingGroup API synchronously
// api document: https://help.aliyun.com/api/emr/createalertdingdinggroup.html
func (client *Client) CreateAlertDingDingGroup(request *CreateAlertDingDingGroupRequest) (response *CreateAlertDingDingGroupResponse, err error) {
	response = CreateCreateAlertDingDingGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAlertDingDingGroupWithChan invokes the emr.CreateAlertDingDingGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/createalertdingdinggroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAlertDingDingGroupWithChan(request *CreateAlertDingDingGroupRequest) (<-chan *CreateAlertDingDingGroupResponse, <-chan error) {
	responseChan := make(chan *CreateAlertDingDingGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAlertDingDingGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAlertDingDingGroupWithCallback invokes the emr.CreateAlertDingDingGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/createalertdingdinggroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAlertDingDingGroupWithCallback(request *CreateAlertDingDingGroupRequest, callback func(response *CreateAlertDingDingGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAlertDingDingGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateAlertDingDingGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAlertDingDingGroupRequest is the request struct for api CreateAlertDingDingGroup
type CreateAlertDingDingGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Name            string           `position:"Query" name:"Name"`
	Description     string           `position:"Query" name:"Description"`
	WebHookUrl      string           `position:"Query" name:"WebHookUrl"`
}

// CreateAlertDingDingGroupResponse is the response struct for api CreateAlertDingDingGroup
type CreateAlertDingDingGroupResponse struct {
	*responses.BaseResponse
	Id int `json:"Id" xml:"Id"`
}

// CreateCreateAlertDingDingGroupRequest creates a request to invoke CreateAlertDingDingGroup API
func CreateCreateAlertDingDingGroupRequest() (request *CreateAlertDingDingGroupRequest) {
	request = &CreateAlertDingDingGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateAlertDingDingGroup", "emr", "openAPI")
	return
}

// CreateCreateAlertDingDingGroupResponse creates a response to parse from CreateAlertDingDingGroup response
func CreateCreateAlertDingDingGroupResponse() (response *CreateAlertDingDingGroupResponse) {
	response = &CreateAlertDingDingGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
