package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAlertContacts invokes the emr.DeleteAlertContacts API synchronously
// api document: https://help.aliyun.com/api/emr/deletealertcontacts.html
func (client *Client) DeleteAlertContacts(request *DeleteAlertContactsRequest) (response *DeleteAlertContactsResponse, err error) {
	response = CreateDeleteAlertContactsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAlertContactsWithChan invokes the emr.DeleteAlertContacts API asynchronously
// api document: https://help.aliyun.com/api/emr/deletealertcontacts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAlertContactsWithChan(request *DeleteAlertContactsRequest) (<-chan *DeleteAlertContactsResponse, <-chan error) {
	responseChan := make(chan *DeleteAlertContactsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAlertContacts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAlertContactsWithCallback invokes the emr.DeleteAlertContacts API asynchronously
// api document: https://help.aliyun.com/api/emr/deletealertcontacts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAlertContactsWithCallback(request *DeleteAlertContactsRequest, callback func(response *DeleteAlertContactsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAlertContactsResponse
		var err error
		defer close(result)
		response, err = client.DeleteAlertContacts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAlertContactsRequest is the request struct for api DeleteAlertContacts
type DeleteAlertContactsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Ids             string           `position:"Query" name:"Ids"`
}

// DeleteAlertContactsResponse is the response struct for api DeleteAlertContacts
type DeleteAlertContactsResponse struct {
	*responses.BaseResponse
	Done bool `json:"Done" xml:"Done"`
}

// CreateDeleteAlertContactsRequest creates a request to invoke DeleteAlertContacts API
func CreateDeleteAlertContactsRequest() (request *DeleteAlertContactsRequest) {
	request = &DeleteAlertContactsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteAlertContacts", "emr", "openAPI")
	return
}

// CreateDeleteAlertContactsResponse creates a response to parse from DeleteAlertContacts response
func CreateDeleteAlertContactsResponse() (response *DeleteAlertContactsResponse) {
	response = &DeleteAlertContactsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
