package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterOperationHostTaskLog invokes the emr.DescribeClusterOperationHostTaskLog API synchronously
// api document: https://help.aliyun.com/api/emr/describeclusteroperationhosttasklog.html
func (client *Client) DescribeClusterOperationHostTaskLog(request *DescribeClusterOperationHostTaskLogRequest) (response *DescribeClusterOperationHostTaskLogResponse, err error) {
	response = CreateDescribeClusterOperationHostTaskLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterOperationHostTaskLogWithChan invokes the emr.DescribeClusterOperationHostTaskLog API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusteroperationhosttasklog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterOperationHostTaskLogWithChan(request *DescribeClusterOperationHostTaskLogRequest) (<-chan *DescribeClusterOperationHostTaskLogResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterOperationHostTaskLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterOperationHostTaskLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterOperationHostTaskLogWithCallback invokes the emr.DescribeClusterOperationHostTaskLog API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusteroperationhosttasklog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterOperationHostTaskLogWithCallback(request *DescribeClusterOperationHostTaskLogRequest, callback func(response *DescribeClusterOperationHostTaskLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterOperationHostTaskLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterOperationHostTaskLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterOperationHostTaskLogRequest is the request struct for api DescribeClusterOperationHostTaskLog
type DescribeClusterOperationHostTaskLogRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OperationId     string           `position:"Query" name:"OperationId"`
	HostId          string           `position:"Query" name:"HostId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	TaskId          string           `position:"Query" name:"TaskId"`
	Status          string           `position:"Query" name:"Status"`
}

// DescribeClusterOperationHostTaskLogResponse is the response struct for api DescribeClusterOperationHostTaskLog
type DescribeClusterOperationHostTaskLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Stdout    string `json:"Stdout" xml:"Stdout"`
	Stderr    string `json:"Stderr" xml:"Stderr"`
}

// CreateDescribeClusterOperationHostTaskLogRequest creates a request to invoke DescribeClusterOperationHostTaskLog API
func CreateDescribeClusterOperationHostTaskLogRequest() (request *DescribeClusterOperationHostTaskLogRequest) {
	request = &DescribeClusterOperationHostTaskLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeClusterOperationHostTaskLog", "emr", "openAPI")
	return
}

// CreateDescribeClusterOperationHostTaskLogResponse creates a response to parse from DescribeClusterOperationHostTaskLog response
func CreateDescribeClusterOperationHostTaskLogResponse() (response *DescribeClusterOperationHostTaskLogResponse) {
	response = &DescribeClusterOperationHostTaskLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
