package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobMigrateResult invokes the emr.GetJobMigrateResult API synchronously
// api document: https://help.aliyun.com/api/emr/getjobmigrateresult.html
func (client *Client) GetJobMigrateResult(request *GetJobMigrateResultRequest) (response *GetJobMigrateResultResponse, err error) {
	response = CreateGetJobMigrateResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobMigrateResultWithChan invokes the emr.GetJobMigrateResult API asynchronously
// api document: https://help.aliyun.com/api/emr/getjobmigrateresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobMigrateResultWithChan(request *GetJobMigrateResultRequest) (<-chan *GetJobMigrateResultResponse, <-chan error) {
	responseChan := make(chan *GetJobMigrateResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobMigrateResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobMigrateResultWithCallback invokes the emr.GetJobMigrateResult API asynchronously
// api document: https://help.aliyun.com/api/emr/getjobmigrateresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobMigrateResultWithCallback(request *GetJobMigrateResultRequest, callback func(response *GetJobMigrateResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobMigrateResultResponse
		var err error
		defer close(result)
		response, err = client.GetJobMigrateResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobMigrateResultRequest is the request struct for api GetJobMigrateResult
type GetJobMigrateResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// GetJobMigrateResultResponse is the response struct for api GetJobMigrateResult
type GetJobMigrateResultResponse struct {
	*responses.BaseResponse
	Result string `json:"Result" xml:"Result"`
}

// CreateGetJobMigrateResultRequest creates a request to invoke GetJobMigrateResult API
func CreateGetJobMigrateResultRequest() (request *GetJobMigrateResultRequest) {
	request = &GetJobMigrateResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetJobMigrateResult", "emr", "openAPI")
	return
}

// CreateGetJobMigrateResultResponse creates a response to parse from GetJobMigrateResult response
func CreateGetJobMigrateResultResponse() (response *GetJobMigrateResultResponse) {
	response = &GetJobMigrateResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
