package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExecutePlanMigrateInfo invokes the emr.ListExecutePlanMigrateInfo API synchronously
// api document: https://help.aliyun.com/api/emr/listexecuteplanmigrateinfo.html
func (client *Client) ListExecutePlanMigrateInfo(request *ListExecutePlanMigrateInfoRequest) (response *ListExecutePlanMigrateInfoResponse, err error) {
	response = CreateListExecutePlanMigrateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ListExecutePlanMigrateInfoWithChan invokes the emr.ListExecutePlanMigrateInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/listexecuteplanmigrateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExecutePlanMigrateInfoWithChan(request *ListExecutePlanMigrateInfoRequest) (<-chan *ListExecutePlanMigrateInfoResponse, <-chan error) {
	responseChan := make(chan *ListExecutePlanMigrateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExecutePlanMigrateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExecutePlanMigrateInfoWithCallback invokes the emr.ListExecutePlanMigrateInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/listexecuteplanmigrateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExecutePlanMigrateInfoWithCallback(request *ListExecutePlanMigrateInfoRequest, callback func(response *ListExecutePlanMigrateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExecutePlanMigrateInfoResponse
		var err error
		defer close(result)
		response, err = client.ListExecutePlanMigrateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExecutePlanMigrateInfoRequest is the request struct for api ListExecutePlanMigrateInfo
type ListExecutePlanMigrateInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	UserId          string           `position:"Query" name:"UserId"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
}

// ListExecutePlanMigrateInfoResponse is the response struct for api ListExecutePlanMigrateInfo
type ListExecutePlanMigrateInfoResponse struct {
	*responses.BaseResponse
	Total                      int                      `json:"Total" xml:"Total"`
	ExecutePlanMigrateInfoList []ExecutePlanMigrateInfo `json:"ExecutePlanMigrateInfoList" xml:"ExecutePlanMigrateInfoList"`
}

// CreateListExecutePlanMigrateInfoRequest creates a request to invoke ListExecutePlanMigrateInfo API
func CreateListExecutePlanMigrateInfoRequest() (request *ListExecutePlanMigrateInfoRequest) {
	request = &ListExecutePlanMigrateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListExecutePlanMigrateInfo", "emr", "openAPI")
	return
}

// CreateListExecutePlanMigrateInfoResponse creates a response to parse from ListExecutePlanMigrateInfo response
func CreateListExecutePlanMigrateInfoResponse() (response *ListExecutePlanMigrateInfoResponse) {
	response = &ListExecutePlanMigrateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
