package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExecutionPlans invokes the emr.ListExecutionPlans API synchronously
// api document: https://help.aliyun.com/api/emr/listexecutionplans.html
func (client *Client) ListExecutionPlans(request *ListExecutionPlansRequest) (response *ListExecutionPlansResponse, err error) {
	response = CreateListExecutionPlansResponse()
	err = client.DoAction(request, response)
	return
}

// ListExecutionPlansWithChan invokes the emr.ListExecutionPlans API asynchronously
// api document: https://help.aliyun.com/api/emr/listexecutionplans.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExecutionPlansWithChan(request *ListExecutionPlansRequest) (<-chan *ListExecutionPlansResponse, <-chan error) {
	responseChan := make(chan *ListExecutionPlansResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExecutionPlans(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExecutionPlansWithCallback invokes the emr.ListExecutionPlans API asynchronously
// api document: https://help.aliyun.com/api/emr/listexecutionplans.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExecutionPlansWithCallback(request *ListExecutionPlansRequest, callback func(response *ListExecutionPlansResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExecutionPlansResponse
		var err error
		defer close(result)
		response, err = client.ListExecutionPlans(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExecutionPlansRequest is the request struct for api ListExecutionPlans
type ListExecutionPlansRequest struct {
	*requests.RpcRequest
	JobId           string           `position:"Query" name:"JobId"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StatusList      *[]string        `position:"Query" name:"StatusList"  type:"Repeated"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	QueryString     string           `position:"Query" name:"QueryString"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	IsDesc          requests.Boolean `position:"Query" name:"IsDesc"`
	Strategy        string           `position:"Query" name:"Strategy"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	QueryType       string           `position:"Query" name:"QueryType"`
}

// ListExecutionPlansResponse is the response struct for api ListExecutionPlans
type ListExecutionPlansResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	PageNumber     int            `json:"PageNumber" xml:"PageNumber"`
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	ExecutionPlans ExecutionPlans `json:"ExecutionPlans" xml:"ExecutionPlans"`
}

// CreateListExecutionPlansRequest creates a request to invoke ListExecutionPlans API
func CreateListExecutionPlansRequest() (request *ListExecutionPlansRequest) {
	request = &ListExecutionPlansRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListExecutionPlans", "emr", "openAPI")
	return
}

// CreateListExecutionPlansResponse creates a response to parse from ListExecutionPlans response
func CreateListExecutionPlansResponse() (response *ListExecutionPlansResponse) {
	response = &ListExecutionPlansResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
