package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScalingTaskGroup invokes the emr.ListScalingTaskGroup API synchronously
// api document: https://help.aliyun.com/api/emr/listscalingtaskgroup.html
func (client *Client) ListScalingTaskGroup(request *ListScalingTaskGroupRequest) (response *ListScalingTaskGroupResponse, err error) {
	response = CreateListScalingTaskGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListScalingTaskGroupWithChan invokes the emr.ListScalingTaskGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/listscalingtaskgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListScalingTaskGroupWithChan(request *ListScalingTaskGroupRequest) (<-chan *ListScalingTaskGroupResponse, <-chan error) {
	responseChan := make(chan *ListScalingTaskGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScalingTaskGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScalingTaskGroupWithCallback invokes the emr.ListScalingTaskGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/listscalingtaskgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListScalingTaskGroupWithCallback(request *ListScalingTaskGroupRequest, callback func(response *ListScalingTaskGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScalingTaskGroupResponse
		var err error
		defer close(result)
		response, err = client.ListScalingTaskGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScalingTaskGroupRequest is the request struct for api ListScalingTaskGroup
type ListScalingTaskGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// ListScalingTaskGroupResponse is the response struct for api ListScalingTaskGroup
type ListScalingTaskGroupResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	GroupList GroupList `json:"GroupList" xml:"GroupList"`
}

// CreateListScalingTaskGroupRequest creates a request to invoke ListScalingTaskGroup API
func CreateListScalingTaskGroupRequest() (request *ListScalingTaskGroupRequest) {
	request = &ListScalingTaskGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListScalingTaskGroup", "emr", "openAPI")
	return
}

// CreateListScalingTaskGroupResponse creates a response to parse from ListScalingTaskGroup response
func CreateListScalingTaskGroupResponse() (response *ListScalingTaskGroupResponse) {
	response = &ListScalingTaskGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
