package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreListTablePartition invokes the emr.MetastoreListTablePartition API synchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttablepartition.html
func (client *Client) MetastoreListTablePartition(request *MetastoreListTablePartitionRequest) (response *MetastoreListTablePartitionResponse, err error) {
	response = CreateMetastoreListTablePartitionResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreListTablePartitionWithChan invokes the emr.MetastoreListTablePartition API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttablepartition.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListTablePartitionWithChan(request *MetastoreListTablePartitionRequest) (<-chan *MetastoreListTablePartitionResponse, <-chan error) {
	responseChan := make(chan *MetastoreListTablePartitionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreListTablePartition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreListTablePartitionWithCallback invokes the emr.MetastoreListTablePartition API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttablepartition.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListTablePartitionWithCallback(request *MetastoreListTablePartitionRequest, callback func(response *MetastoreListTablePartitionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreListTablePartitionResponse
		var err error
		defer close(result)
		response, err = client.MetastoreListTablePartition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreListTablePartitionRequest is the request struct for api MetastoreListTablePartition
type MetastoreListTablePartitionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	TableId         string           `position:"Query" name:"TableId"`
	DatabaseId      string           `position:"Query" name:"DatabaseId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// MetastoreListTablePartitionResponse is the response struct for api MetastoreListTablePartition
type MetastoreListTablePartitionResponse struct {
	*responses.BaseResponse
	RequestId     string                                     `json:"RequestId" xml:"RequestId"`
	TotalCount    int                                        `json:"TotalCount" xml:"TotalCount"`
	PageNumber    int                                        `json:"PageNumber" xml:"PageNumber"`
	PageSize      int                                        `json:"PageSize" xml:"PageSize"`
	PartitionList PartitionListInMetastoreListTablePartition `json:"PartitionList" xml:"PartitionList"`
}

// CreateMetastoreListTablePartitionRequest creates a request to invoke MetastoreListTablePartition API
func CreateMetastoreListTablePartitionRequest() (request *MetastoreListTablePartitionRequest) {
	request = &MetastoreListTablePartitionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreListTablePartition", "emr", "openAPI")
	return
}

// CreateMetastoreListTablePartitionResponse creates a response to parse from MetastoreListTablePartition response
func CreateMetastoreListTablePartitionResponse() (response *MetastoreListTablePartitionResponse) {
	response = &MetastoreListTablePartitionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
