package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncDataSourceSchemaDatabase invokes the emr.SyncDataSourceSchemaDatabase API synchronously
// api document: https://help.aliyun.com/api/emr/syncdatasourceschemadatabase.html
func (client *Client) SyncDataSourceSchemaDatabase(request *SyncDataSourceSchemaDatabaseRequest) (response *SyncDataSourceSchemaDatabaseResponse, err error) {
	response = CreateSyncDataSourceSchemaDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// SyncDataSourceSchemaDatabaseWithChan invokes the emr.SyncDataSourceSchemaDatabase API asynchronously
// api document: https://help.aliyun.com/api/emr/syncdatasourceschemadatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SyncDataSourceSchemaDatabaseWithChan(request *SyncDataSourceSchemaDatabaseRequest) (<-chan *SyncDataSourceSchemaDatabaseResponse, <-chan error) {
	responseChan := make(chan *SyncDataSourceSchemaDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncDataSourceSchemaDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncDataSourceSchemaDatabaseWithCallback invokes the emr.SyncDataSourceSchemaDatabase API asynchronously
// api document: https://help.aliyun.com/api/emr/syncdatasourceschemadatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SyncDataSourceSchemaDatabaseWithCallback(request *SyncDataSourceSchemaDatabaseRequest, callback func(response *SyncDataSourceSchemaDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncDataSourceSchemaDatabaseResponse
		var err error
		defer close(result)
		response, err = client.SyncDataSourceSchemaDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncDataSourceSchemaDatabaseRequest is the request struct for api SyncDataSourceSchemaDatabase
type SyncDataSourceSchemaDatabaseRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	EtlJobId        string           `position:"Query" name:"EtlJobId"`
	DataSourceId    string           `position:"Query" name:"DataSourceId"`
}

// SyncDataSourceSchemaDatabaseResponse is the response struct for api SyncDataSourceSchemaDatabase
type SyncDataSourceSchemaDatabaseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CommandId string `json:"CommandId" xml:"CommandId"`
}

// CreateSyncDataSourceSchemaDatabaseRequest creates a request to invoke SyncDataSourceSchemaDatabase API
func CreateSyncDataSourceSchemaDatabaseRequest() (request *SyncDataSourceSchemaDatabaseRequest) {
	request = &SyncDataSourceSchemaDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "SyncDataSourceSchemaDatabase", "emr", "openAPI")
	return
}

// CreateSyncDataSourceSchemaDatabaseResponse creates a response to parse from SyncDataSourceSchemaDatabase response
func CreateSyncDataSourceSchemaDatabaseResponse() (response *SyncDataSourceSchemaDatabaseResponse) {
	response = &SyncDataSourceSchemaDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
