package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddCustomInfo invokes the finmall.AddCustomInfo API synchronously
// api document: https://help.aliyun.com/api/finmall/addcustominfo.html
func (client *Client) AddCustomInfo(request *AddCustomInfoRequest) (response *AddCustomInfoResponse, err error) {
	response = CreateAddCustomInfoResponse()
	err = client.DoAction(request, response)
	return
}

// AddCustomInfoWithChan invokes the finmall.AddCustomInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/addcustominfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddCustomInfoWithChan(request *AddCustomInfoRequest) (<-chan *AddCustomInfoResponse, <-chan error) {
	responseChan := make(chan *AddCustomInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddCustomInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddCustomInfoWithCallback invokes the finmall.AddCustomInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/addcustominfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddCustomInfoWithCallback(request *AddCustomInfoRequest, callback func(response *AddCustomInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddCustomInfoResponse
		var err error
		defer close(result)
		response, err = client.AddCustomInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddCustomInfoRequest is the request struct for api AddCustomInfo
type AddCustomInfoRequest struct {
	*requests.RpcRequest
	UserId string `position:"Query" name:"UserId"`
}

// AddCustomInfoResponse is the response struct for api AddCustomInfo
type AddCustomInfoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddCustomInfoRequest creates a request to invoke AddCustomInfo API
func CreateAddCustomInfoRequest() (request *AddCustomInfoRequest) {
	request = &AddCustomInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "AddCustomInfo", "finmall", "openAPI")
	return
}

// CreateAddCustomInfoResponse creates a response to parse from AddCustomInfo response
func CreateAddCustomInfoResponse() (response *AddCustomInfoResponse) {
	response = &AddCustomInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
