package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCreditRepayList invokes the finmall.GetCreditRepayList API synchronously
// api document: https://help.aliyun.com/api/finmall/getcreditrepaylist.html
func (client *Client) GetCreditRepayList(request *GetCreditRepayListRequest) (response *GetCreditRepayListResponse, err error) {
	response = CreateGetCreditRepayListResponse()
	err = client.DoAction(request, response)
	return
}

// GetCreditRepayListWithChan invokes the finmall.GetCreditRepayList API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcreditrepaylist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCreditRepayListWithChan(request *GetCreditRepayListRequest) (<-chan *GetCreditRepayListResponse, <-chan error) {
	responseChan := make(chan *GetCreditRepayListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCreditRepayList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCreditRepayListWithCallback invokes the finmall.GetCreditRepayList API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcreditrepaylist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCreditRepayListWithCallback(request *GetCreditRepayListRequest, callback func(response *GetCreditRepayListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCreditRepayListResponse
		var err error
		defer close(result)
		response, err = client.GetCreditRepayList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCreditRepayListRequest is the request struct for api GetCreditRepayList
type GetCreditRepayListRequest struct {
	*requests.RpcRequest
	QueryExpression string           `position:"Query" name:"QueryExpression"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	UserId          string           `position:"Query" name:"UserId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// GetCreditRepayListResponse is the response struct for api GetCreditRepayList
type GetCreditRepayListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetCreditRepayListRequest creates a request to invoke GetCreditRepayList API
func CreateGetCreditRepayListRequest() (request *GetCreditRepayListRequest) {
	request = &GetCreditRepayListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetCreditRepayList", "finmall", "openAPI")
	return
}

// CreateGetCreditRepayListResponse creates a response to parse from GetCreditRepayList response
func CreateGetCreditRepayListResponse() (response *GetCreditRepayListResponse) {
	response = &GetCreditRepayListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
