package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCreditSignatureInfo invokes the finmall.GetCreditSignatureInfo API synchronously
// api document: https://help.aliyun.com/api/finmall/getcreditsignatureinfo.html
func (client *Client) GetCreditSignatureInfo(request *GetCreditSignatureInfoRequest) (response *GetCreditSignatureInfoResponse, err error) {
	response = CreateGetCreditSignatureInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetCreditSignatureInfoWithChan invokes the finmall.GetCreditSignatureInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcreditsignatureinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCreditSignatureInfoWithChan(request *GetCreditSignatureInfoRequest) (<-chan *GetCreditSignatureInfoResponse, <-chan error) {
	responseChan := make(chan *GetCreditSignatureInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCreditSignatureInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCreditSignatureInfoWithCallback invokes the finmall.GetCreditSignatureInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcreditsignatureinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCreditSignatureInfoWithCallback(request *GetCreditSignatureInfoRequest, callback func(response *GetCreditSignatureInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCreditSignatureInfoResponse
		var err error
		defer close(result)
		response, err = client.GetCreditSignatureInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCreditSignatureInfoRequest is the request struct for api GetCreditSignatureInfo
type GetCreditSignatureInfoRequest struct {
	*requests.RpcRequest
	CreditId string `position:"Query" name:"CreditId"`
	UserId   string `position:"Query" name:"UserId"`
}

// GetCreditSignatureInfoResponse is the response struct for api GetCreditSignatureInfo
type GetCreditSignatureInfoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetCreditSignatureInfoRequest creates a request to invoke GetCreditSignatureInfo API
func CreateGetCreditSignatureInfoRequest() (request *GetCreditSignatureInfoRequest) {
	request = &GetCreditSignatureInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetCreditSignatureInfo", "finmall", "openAPI")
	return
}

// CreateGetCreditSignatureInfoResponse creates a response to parse from GetCreditSignatureInfo response
func CreateGetCreditSignatureInfoResponse() (response *GetCreditSignatureInfoResponse) {
	response = &GetCreditSignatureInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
