package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLatestOverdueRecord invokes the finmall.GetLatestOverdueRecord API synchronously
// api document: https://help.aliyun.com/api/finmall/getlatestoverduerecord.html
func (client *Client) GetLatestOverdueRecord(request *GetLatestOverdueRecordRequest) (response *GetLatestOverdueRecordResponse, err error) {
	response = CreateGetLatestOverdueRecordResponse()
	err = client.DoAction(request, response)
	return
}

// GetLatestOverdueRecordWithChan invokes the finmall.GetLatestOverdueRecord API asynchronously
// api document: https://help.aliyun.com/api/finmall/getlatestoverduerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLatestOverdueRecordWithChan(request *GetLatestOverdueRecordRequest) (<-chan *GetLatestOverdueRecordResponse, <-chan error) {
	responseChan := make(chan *GetLatestOverdueRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLatestOverdueRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLatestOverdueRecordWithCallback invokes the finmall.GetLatestOverdueRecord API asynchronously
// api document: https://help.aliyun.com/api/finmall/getlatestoverduerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLatestOverdueRecordWithCallback(request *GetLatestOverdueRecordRequest, callback func(response *GetLatestOverdueRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLatestOverdueRecordResponse
		var err error
		defer close(result)
		response, err = client.GetLatestOverdueRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLatestOverdueRecordRequest is the request struct for api GetLatestOverdueRecord
type GetLatestOverdueRecordRequest struct {
	*requests.RpcRequest
	CreditId string `position:"Query" name:"CreditId"`
	UserId   string `position:"Query" name:"UserId"`
}

// GetLatestOverdueRecordResponse is the response struct for api GetLatestOverdueRecord
type GetLatestOverdueRecordResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetLatestOverdueRecordRequest creates a request to invoke GetLatestOverdueRecord API
func CreateGetLatestOverdueRecordRequest() (request *GetLatestOverdueRecordRequest) {
	request = &GetLatestOverdueRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetLatestOverdueRecord", "finmall", "openAPI")
	return
}

// CreateGetLatestOverdueRecordResponse creates a response to parse from GetLatestOverdueRecord response
func CreateGetLatestOverdueRecordResponse() (response *GetLatestOverdueRecordResponse) {
	response = &GetLatestOverdueRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
