package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTradeData invokes the finmall.GetTradeData API synchronously
// api document: https://help.aliyun.com/api/finmall/gettradedata.html
func (client *Client) GetTradeData(request *GetTradeDataRequest) (response *GetTradeDataResponse, err error) {
	response = CreateGetTradeDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetTradeDataWithChan invokes the finmall.GetTradeData API asynchronously
// api document: https://help.aliyun.com/api/finmall/gettradedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTradeDataWithChan(request *GetTradeDataRequest) (<-chan *GetTradeDataResponse, <-chan error) {
	responseChan := make(chan *GetTradeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTradeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTradeDataWithCallback invokes the finmall.GetTradeData API asynchronously
// api document: https://help.aliyun.com/api/finmall/gettradedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTradeDataWithCallback(request *GetTradeDataRequest, callback func(response *GetTradeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTradeDataResponse
		var err error
		defer close(result)
		response, err = client.GetTradeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTradeDataRequest is the request struct for api GetTradeData
type GetTradeDataRequest struct {
	*requests.RpcRequest
	CreditId string `position:"Query" name:"CreditId"`
	UserId   string `position:"Query" name:"UserId"`
}

// GetTradeDataResponse is the response struct for api GetTradeData
type GetTradeDataResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetTradeDataRequest creates a request to invoke GetTradeData API
func CreateGetTradeDataRequest() (request *GetTradeDataRequest) {
	request = &GetTradeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetTradeData", "finmall", "openAPI")
	return
}

// CreateGetTradeDataResponse creates a response to parse from GetTradeData response
func CreateGetTradeDataResponse() (response *GetTradeDataResponse) {
	response = &GetTradeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
