package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserInfoAuthorizationAgreement invokes the finmall.GetUserInfoAuthorizationAgreement API synchronously
// api document: https://help.aliyun.com/api/finmall/getuserinfoauthorizationagreement.html
func (client *Client) GetUserInfoAuthorizationAgreement(request *GetUserInfoAuthorizationAgreementRequest) (response *GetUserInfoAuthorizationAgreementResponse, err error) {
	response = CreateGetUserInfoAuthorizationAgreementResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserInfoAuthorizationAgreementWithChan invokes the finmall.GetUserInfoAuthorizationAgreement API asynchronously
// api document: https://help.aliyun.com/api/finmall/getuserinfoauthorizationagreement.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserInfoAuthorizationAgreementWithChan(request *GetUserInfoAuthorizationAgreementRequest) (<-chan *GetUserInfoAuthorizationAgreementResponse, <-chan error) {
	responseChan := make(chan *GetUserInfoAuthorizationAgreementResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserInfoAuthorizationAgreement(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserInfoAuthorizationAgreementWithCallback invokes the finmall.GetUserInfoAuthorizationAgreement API asynchronously
// api document: https://help.aliyun.com/api/finmall/getuserinfoauthorizationagreement.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserInfoAuthorizationAgreementWithCallback(request *GetUserInfoAuthorizationAgreementRequest, callback func(response *GetUserInfoAuthorizationAgreementResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserInfoAuthorizationAgreementResponse
		var err error
		defer close(result)
		response, err = client.GetUserInfoAuthorizationAgreement(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserInfoAuthorizationAgreementRequest is the request struct for api GetUserInfoAuthorizationAgreement
type GetUserInfoAuthorizationAgreementRequest struct {
	*requests.RpcRequest
	CreditId    string `position:"Query" name:"CreditId"`
	FundPartyId string `position:"Query" name:"FundPartyId"`
	UserId      string `position:"Query" name:"UserId"`
}

// GetUserInfoAuthorizationAgreementResponse is the response struct for api GetUserInfoAuthorizationAgreement
type GetUserInfoAuthorizationAgreementResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetUserInfoAuthorizationAgreementRequest creates a request to invoke GetUserInfoAuthorizationAgreement API
func CreateGetUserInfoAuthorizationAgreementRequest() (request *GetUserInfoAuthorizationAgreementRequest) {
	request = &GetUserInfoAuthorizationAgreementRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetUserInfoAuthorizationAgreement", "finmall", "openAPI")
	return
}

// CreateGetUserInfoAuthorizationAgreementResponse creates a response to parse from GetUserInfoAuthorizationAgreement response
func CreateGetUserInfoAuthorizationAgreementResponse() (response *GetUserInfoAuthorizationAgreementResponse) {
	response = &GetUserInfoAuthorizationAgreementResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
