package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetZhimaScore invokes the finmall.GetZhimaScore API synchronously
// api document: https://help.aliyun.com/api/finmall/getzhimascore.html
func (client *Client) GetZhimaScore(request *GetZhimaScoreRequest) (response *GetZhimaScoreResponse, err error) {
	response = CreateGetZhimaScoreResponse()
	err = client.DoAction(request, response)
	return
}

// GetZhimaScoreWithChan invokes the finmall.GetZhimaScore API asynchronously
// api document: https://help.aliyun.com/api/finmall/getzhimascore.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetZhimaScoreWithChan(request *GetZhimaScoreRequest) (<-chan *GetZhimaScoreResponse, <-chan error) {
	responseChan := make(chan *GetZhimaScoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetZhimaScore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetZhimaScoreWithCallback invokes the finmall.GetZhimaScore API asynchronously
// api document: https://help.aliyun.com/api/finmall/getzhimascore.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetZhimaScoreWithCallback(request *GetZhimaScoreRequest, callback func(response *GetZhimaScoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetZhimaScoreResponse
		var err error
		defer close(result)
		response, err = client.GetZhimaScore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetZhimaScoreRequest is the request struct for api GetZhimaScore
type GetZhimaScoreRequest struct {
	*requests.RpcRequest
	UserId string `position:"Query" name:"UserId"`
}

// GetZhimaScoreResponse is the response struct for api GetZhimaScore
type GetZhimaScoreResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetZhimaScoreRequest creates a request to invoke GetZhimaScore API
func CreateGetZhimaScoreRequest() (request *GetZhimaScoreRequest) {
	request = &GetZhimaScoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetZhimaScore", "finmall", "openAPI")
	return
}

// CreateGetZhimaScoreResponse creates a response to parse from GetZhimaScore response
func CreateGetZhimaScoreResponse() (response *GetZhimaScoreResponse) {
	response = &GetZhimaScoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
