package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyCustomer invokes the finmall.VerifyCustomer API synchronously
// api document: https://help.aliyun.com/api/finmall/verifycustomer.html
func (client *Client) VerifyCustomer(request *VerifyCustomerRequest) (response *VerifyCustomerResponse, err error) {
	response = CreateVerifyCustomerResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyCustomerWithChan invokes the finmall.VerifyCustomer API asynchronously
// api document: https://help.aliyun.com/api/finmall/verifycustomer.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifyCustomerWithChan(request *VerifyCustomerRequest) (<-chan *VerifyCustomerResponse, <-chan error) {
	responseChan := make(chan *VerifyCustomerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyCustomer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyCustomerWithCallback invokes the finmall.VerifyCustomer API asynchronously
// api document: https://help.aliyun.com/api/finmall/verifycustomer.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifyCustomerWithCallback(request *VerifyCustomerRequest, callback func(response *VerifyCustomerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyCustomerResponse
		var err error
		defer close(result)
		response, err = client.VerifyCustomer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyCustomerRequest is the request struct for api VerifyCustomer
type VerifyCustomerRequest struct {
	*requests.RpcRequest
	IdCardNumber    string `position:"Query" name:"IdCardNumber"`
	Address         string `position:"Query" name:"Address"`
	IdCardFrontPage string `position:"Query" name:"IdCardFrontPage"`
	PhoneNumber     string `position:"Query" name:"PhoneNumber"`
	BusinessLicense string `position:"Query" name:"BusinessLicense"`
	IdCardBackPage  string `position:"Query" name:"IdCardBackPage"`
	LegalPersonName string `position:"Query" name:"LegalPersonName"`
	EnterpriseName  string `position:"Query" name:"EnterpriseName"`
	UserId          string `position:"Query" name:"UserId"`
	LoanSubject     string `position:"Query" name:"LoanSubject"`
	ZhimaReturnUrl  string `position:"Query" name:"ZhimaReturnUrl"`
	BankCard        string `position:"Query" name:"BankCard"`
	Email           string `position:"Query" name:"Email"`
}

// VerifyCustomerResponse is the response struct for api VerifyCustomer
type VerifyCustomerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateVerifyCustomerRequest creates a request to invoke VerifyCustomer API
func CreateVerifyCustomerRequest() (request *VerifyCustomerRequest) {
	request = &VerifyCustomerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "VerifyCustomer", "finmall", "openAPI")
	return
}

// CreateVerifyCustomerResponse creates a response to parse from VerifyCustomer response
func CreateVerifyCustomerResponse() (response *VerifyCustomerResponse) {
	response = &VerifyCustomerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
