package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePornBatchDetectJob invokes the imm.CreatePornBatchDetectJob API synchronously
// api document: https://help.aliyun.com/api/imm/createpornbatchdetectjob.html
func (client *Client) CreatePornBatchDetectJob(request *CreatePornBatchDetectJobRequest) (response *CreatePornBatchDetectJobResponse, err error) {
	response = CreateCreatePornBatchDetectJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePornBatchDetectJobWithChan invokes the imm.CreatePornBatchDetectJob API asynchronously
// api document: https://help.aliyun.com/api/imm/createpornbatchdetectjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatePornBatchDetectJobWithChan(request *CreatePornBatchDetectJobRequest) (<-chan *CreatePornBatchDetectJobResponse, <-chan error) {
	responseChan := make(chan *CreatePornBatchDetectJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePornBatchDetectJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePornBatchDetectJobWithCallback invokes the imm.CreatePornBatchDetectJob API asynchronously
// api document: https://help.aliyun.com/api/imm/createpornbatchdetectjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatePornBatchDetectJobWithCallback(request *CreatePornBatchDetectJobRequest, callback func(response *CreatePornBatchDetectJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePornBatchDetectJobResponse
		var err error
		defer close(result)
		response, err = client.CreatePornBatchDetectJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePornBatchDetectJobRequest is the request struct for api CreatePornBatchDetectJob
type CreatePornBatchDetectJobRequest struct {
	*requests.RpcRequest
	NotifyTopicName string `position:"Query" name:"NotifyTopicName"`
	NotifyEndpoint  string `position:"Query" name:"NotifyEndpoint"`
	Project         string `position:"Query" name:"Project"`
	ExternalID      string `position:"Query" name:"ExternalID"`
	SrcUri          string `position:"Query" name:"SrcUri"`
	TgtUri          string `position:"Query" name:"TgtUri"`
}

// CreatePornBatchDetectJobResponse is the response struct for api CreatePornBatchDetectJob
type CreatePornBatchDetectJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	JobId      string `json:"JobId" xml:"JobId"`
	TgtLoc     string `json:"TgtLoc" xml:"TgtLoc"`
	Status     string `json:"Status" xml:"Status"`
	CreateTime string `json:"CreateTime" xml:"CreateTime"`
	Percent    int    `json:"Percent" xml:"Percent"`
}

// CreateCreatePornBatchDetectJobRequest creates a request to invoke CreatePornBatchDetectJob API
func CreateCreatePornBatchDetectJobRequest() (request *CreatePornBatchDetectJobRequest) {
	request = &CreatePornBatchDetectJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "CreatePornBatchDetectJob", "imm", "openAPI")
	return
}

// CreateCreatePornBatchDetectJobResponse creates a response to parse from CreatePornBatchDetectJob response
func CreateCreatePornBatchDetectJobResponse() (response *CreatePornBatchDetectJobResponse) {
	response = &CreatePornBatchDetectJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
