package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFaceSearchGroups invokes the imm.ListFaceSearchGroups API synchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroups.html
func (client *Client) ListFaceSearchGroups(request *ListFaceSearchGroupsRequest) (response *ListFaceSearchGroupsResponse, err error) {
	response = CreateListFaceSearchGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFaceSearchGroupsWithChan invokes the imm.ListFaceSearchGroups API asynchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFaceSearchGroupsWithChan(request *ListFaceSearchGroupsRequest) (<-chan *ListFaceSearchGroupsResponse, <-chan error) {
	responseChan := make(chan *ListFaceSearchGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFaceSearchGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFaceSearchGroupsWithCallback invokes the imm.ListFaceSearchGroups API asynchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFaceSearchGroupsWithCallback(request *ListFaceSearchGroupsRequest, callback func(response *ListFaceSearchGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFaceSearchGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListFaceSearchGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFaceSearchGroupsRequest is the request struct for api ListFaceSearchGroups
type ListFaceSearchGroupsRequest struct {
	*requests.RpcRequest
	MaxKeys requests.Integer `position:"Query" name:"MaxKeys"`
	Marker  string           `position:"Query" name:"Marker"`
	Project string           `position:"Query" name:"Project"`
}

// ListFaceSearchGroupsResponse is the response struct for api ListFaceSearchGroups
type ListFaceSearchGroupsResponse struct {
	*responses.BaseResponse
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	NextMarker string       `json:"NextMarker" xml:"NextMarker"`
	Groups     []GroupsItem `json:"Groups" xml:"Groups"`
}

// CreateListFaceSearchGroupsRequest creates a request to invoke ListFaceSearchGroups API
func CreateListFaceSearchGroupsRequest() (request *ListFaceSearchGroupsRequest) {
	request = &ListFaceSearchGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "ListFaceSearchGroups", "imm", "openAPI")
	return
}

// CreateListFaceSearchGroupsResponse creates a response to parse from ListFaceSearchGroups response
func CreateListFaceSearchGroupsResponse() (response *ListFaceSearchGroupsResponse) {
	response = &ListFaceSearchGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
