package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePredictDatas invokes the ivision.DeletePredictDatas API synchronously
// api document: https://help.aliyun.com/api/ivision/deletepredictdatas.html
func (client *Client) DeletePredictDatas(request *DeletePredictDatasRequest) (response *DeletePredictDatasResponse, err error) {
	response = CreateDeletePredictDatasResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePredictDatasWithChan invokes the ivision.DeletePredictDatas API asynchronously
// api document: https://help.aliyun.com/api/ivision/deletepredictdatas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeletePredictDatasWithChan(request *DeletePredictDatasRequest) (<-chan *DeletePredictDatasResponse, <-chan error) {
	responseChan := make(chan *DeletePredictDatasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePredictDatas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePredictDatasWithCallback invokes the ivision.DeletePredictDatas API asynchronously
// api document: https://help.aliyun.com/api/ivision/deletepredictdatas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeletePredictDatasWithCallback(request *DeletePredictDatasRequest, callback func(response *DeletePredictDatasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePredictDatasResponse
		var err error
		defer close(result)
		response, err = client.DeletePredictDatas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePredictDatasRequest is the request struct for api DeletePredictDatas
type DeletePredictDatasRequest struct {
	*requests.RpcRequest
	DataIds     string           `position:"Query" name:"DataIds"`
	ProjectId   string           `position:"Query" name:"ProjectId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	IterationId string           `position:"Query" name:"IterationId"`
}

// DeletePredictDatasResponse is the response struct for api DeletePredictDatas
type DeletePredictDatasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePredictDatasRequest creates a request to invoke DeletePredictDatas API
func CreateDeletePredictDatasRequest() (request *DeletePredictDatasRequest) {
	request = &DeletePredictDatasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DeletePredictDatas", "ivision", "openAPI")
	return
}

// CreateDeletePredictDatasResponse creates a response to parse from DeletePredictDatas response
func CreateDeletePredictDatasResponse() (response *DeletePredictDatasResponse) {
	response = &DeletePredictDatasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
