package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAlias invokes the kms.CreateAlias API synchronously
// api document: https://help.aliyun.com/api/kms/createalias.html
func (client *Client) CreateAlias(request *CreateAliasRequest) (response *CreateAliasResponse, err error) {
	response = CreateCreateAliasResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAliasWithChan invokes the kms.CreateAlias API asynchronously
// api document: https://help.aliyun.com/api/kms/createalias.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAliasWithChan(request *CreateAliasRequest) (<-chan *CreateAliasResponse, <-chan error) {
	responseChan := make(chan *CreateAliasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAlias(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAliasWithCallback invokes the kms.CreateAlias API asynchronously
// api document: https://help.aliyun.com/api/kms/createalias.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAliasWithCallback(request *CreateAliasRequest, callback func(response *CreateAliasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAliasResponse
		var err error
		defer close(result)
		response, err = client.CreateAlias(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAliasRequest is the request struct for api CreateAlias
type CreateAliasRequest struct {
	*requests.RpcRequest
	AliasName string `position:"Query" name:"AliasName"`
	KeyId     string `position:"Query" name:"KeyId"`
	STSToken  string `position:"Query" name:"STSToken"`
}

// CreateAliasResponse is the response struct for api CreateAlias
type CreateAliasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateAliasRequest creates a request to invoke CreateAlias API
func CreateCreateAliasRequest() (request *CreateAliasRequest) {
	request = &CreateAliasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "CreateAlias", "kms", "openAPI")
	return
}

// CreateCreateAliasResponse creates a response to parse from CreateAlias response
func CreateCreateAliasResponse() (response *CreateAliasResponse) {
	response = &CreateAliasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
