package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveMixConfig invokes the live.AddLiveMixConfig API synchronously
// api document: https://help.aliyun.com/api/live/addlivemixconfig.html
func (client *Client) AddLiveMixConfig(request *AddLiveMixConfigRequest) (response *AddLiveMixConfigResponse, err error) {
	response = CreateAddLiveMixConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveMixConfigWithChan invokes the live.AddLiveMixConfig API asynchronously
// api document: https://help.aliyun.com/api/live/addlivemixconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddLiveMixConfigWithChan(request *AddLiveMixConfigRequest) (<-chan *AddLiveMixConfigResponse, <-chan error) {
	responseChan := make(chan *AddLiveMixConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveMixConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveMixConfigWithCallback invokes the live.AddLiveMixConfig API asynchronously
// api document: https://help.aliyun.com/api/live/addlivemixconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddLiveMixConfigWithCallback(request *AddLiveMixConfigRequest, callback func(response *AddLiveMixConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveMixConfigResponse
		var err error
		defer close(result)
		response, err = client.AddLiveMixConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveMixConfigRequest is the request struct for api AddLiveMixConfig
type AddLiveMixConfigRequest struct {
	*requests.RpcRequest
	Template      string           `position:"Query" name:"Template"`
	AppName       string           `position:"Query" name:"AppName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// AddLiveMixConfigResponse is the response struct for api AddLiveMixConfig
type AddLiveMixConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveMixConfigRequest creates a request to invoke AddLiveMixConfig API
func CreateAddLiveMixConfigRequest() (request *AddLiveMixConfigRequest) {
	request = &AddLiveMixConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveMixConfig", "live", "openAPI")
	return
}

// CreateAddLiveMixConfigResponse creates a response to parse from AddLiveMixConfig response
func CreateAddLiveMixConfigResponse() (response *AddLiveMixConfigResponse) {
	response = &AddLiveMixConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
