package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveMixConfig invokes the live.DescribeLiveMixConfig API synchronously
// api document: https://help.aliyun.com/api/live/describelivemixconfig.html
func (client *Client) DescribeLiveMixConfig(request *DescribeLiveMixConfigRequest) (response *DescribeLiveMixConfigResponse, err error) {
	response = CreateDescribeLiveMixConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveMixConfigWithChan invokes the live.DescribeLiveMixConfig API asynchronously
// api document: https://help.aliyun.com/api/live/describelivemixconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveMixConfigWithChan(request *DescribeLiveMixConfigRequest) (<-chan *DescribeLiveMixConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveMixConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveMixConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveMixConfigWithCallback invokes the live.DescribeLiveMixConfig API asynchronously
// api document: https://help.aliyun.com/api/live/describelivemixconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveMixConfigWithCallback(request *DescribeLiveMixConfigRequest, callback func(response *DescribeLiveMixConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveMixConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveMixConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveMixConfigRequest is the request struct for api DescribeLiveMixConfig
type DescribeLiveMixConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveMixConfigResponse is the response struct for api DescribeLiveMixConfig
type DescribeLiveMixConfigResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	MixConfigList MixConfigList `json:"MixConfigList" xml:"MixConfigList"`
}

// CreateDescribeLiveMixConfigRequest creates a request to invoke DescribeLiveMixConfig API
func CreateDescribeLiveMixConfigRequest() (request *DescribeLiveMixConfigRequest) {
	request = &DescribeLiveMixConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveMixConfig", "live", "openAPI")
	return
}

// CreateDescribeLiveMixConfigResponse creates a response to parse from DescribeLiveMixConfig response
func CreateDescribeLiveMixConfigResponse() (response *DescribeLiveMixConfigResponse) {
	response = &DescribeLiveMixConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
