package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveRecordNotifyConfig invokes the live.UpdateLiveRecordNotifyConfig API synchronously
// api document: https://help.aliyun.com/api/live/updateliverecordnotifyconfig.html
func (client *Client) UpdateLiveRecordNotifyConfig(request *UpdateLiveRecordNotifyConfigRequest) (response *UpdateLiveRecordNotifyConfigResponse, err error) {
	response = CreateUpdateLiveRecordNotifyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveRecordNotifyConfigWithChan invokes the live.UpdateLiveRecordNotifyConfig API asynchronously
// api document: https://help.aliyun.com/api/live/updateliverecordnotifyconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateLiveRecordNotifyConfigWithChan(request *UpdateLiveRecordNotifyConfigRequest) (<-chan *UpdateLiveRecordNotifyConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveRecordNotifyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveRecordNotifyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveRecordNotifyConfigWithCallback invokes the live.UpdateLiveRecordNotifyConfig API asynchronously
// api document: https://help.aliyun.com/api/live/updateliverecordnotifyconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateLiveRecordNotifyConfigWithCallback(request *UpdateLiveRecordNotifyConfigRequest, callback func(response *UpdateLiveRecordNotifyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveRecordNotifyConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveRecordNotifyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveRecordNotifyConfigRequest is the request struct for api UpdateLiveRecordNotifyConfig
type UpdateLiveRecordNotifyConfigRequest struct {
	*requests.RpcRequest
	OnDemandUrl      string           `position:"Query" name:"OnDemandUrl"`
	SecurityToken    string           `position:"Query" name:"SecurityToken"`
	DomainName       string           `position:"Query" name:"DomainName"`
	NotifyUrl        string           `position:"Query" name:"NotifyUrl"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	NeedStatusNotify requests.Boolean `position:"Query" name:"NeedStatusNotify"`
}

// UpdateLiveRecordNotifyConfigResponse is the response struct for api UpdateLiveRecordNotifyConfig
type UpdateLiveRecordNotifyConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveRecordNotifyConfigRequest creates a request to invoke UpdateLiveRecordNotifyConfig API
func CreateUpdateLiveRecordNotifyConfigRequest() (request *UpdateLiveRecordNotifyConfigRequest) {
	request = &UpdateLiveRecordNotifyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveRecordNotifyConfig", "live", "openAPI")
	return
}

// CreateUpdateLiveRecordNotifyConfigResponse creates a response to parse from UpdateLiveRecordNotifyConfig response
func CreateUpdateLiveRecordNotifyConfigResponse() (response *UpdateLiveRecordNotifyConfigResponse) {
	response = &UpdateLiveRecordNotifyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
