package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVulTarget invokes the aegis.ModifyVulTarget API synchronously
// api document: https://help.aliyun.com/api/aegis/modifyvultarget.html
func (client *Client) ModifyVulTarget(request *ModifyVulTargetRequest) (response *ModifyVulTargetResponse, err error) {
	response = CreateModifyVulTargetResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVulTargetWithChan invokes the aegis.ModifyVulTarget API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyvultarget.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVulTargetWithChan(request *ModifyVulTargetRequest) (<-chan *ModifyVulTargetResponse, <-chan error) {
	responseChan := make(chan *ModifyVulTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVulTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVulTargetWithCallback invokes the aegis.ModifyVulTarget API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyvultarget.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVulTargetWithCallback(request *ModifyVulTargetRequest, callback func(response *ModifyVulTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVulTargetResponse
		var err error
		defer close(result)
		response, err = client.ModifyVulTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVulTargetRequest is the request struct for api ModifyVulTarget
type ModifyVulTargetRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Config   string `position:"Query" name:"Config"`
	Target   string `position:"Query" name:"Target"`
}

// ModifyVulTargetResponse is the response struct for api ModifyVulTarget
type ModifyVulTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVulTargetRequest creates a request to invoke ModifyVulTarget API
func CreateModifyVulTargetRequest() (request *ModifyVulTargetRequest) {
	request = &ModifyVulTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ModifyVulTarget", "vipaegis", "openAPI")
	return
}

// CreateModifyVulTargetResponse creates a response to parse from ModifyVulTarget response
func CreateModifyVulTargetResponse() (response *ModifyVulTargetResponse) {
	response = &ModifyVulTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
