package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFlowRule invokes the ahas_openapi.ModifyFlowRule API synchronously
func (client *Client) ModifyFlowRule(request *ModifyFlowRuleRequest) (response *ModifyFlowRuleResponse, err error) {
	response = CreateModifyFlowRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFlowRuleWithChan invokes the ahas_openapi.ModifyFlowRule API asynchronously
func (client *Client) ModifyFlowRuleWithChan(request *ModifyFlowRuleRequest) (<-chan *ModifyFlowRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyFlowRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFlowRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFlowRuleWithCallback invokes the ahas_openapi.ModifyFlowRule API asynchronously
func (client *Client) ModifyFlowRuleWithCallback(request *ModifyFlowRuleRequest, callback func(response *ModifyFlowRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFlowRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyFlowRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFlowRuleRequest is the request struct for api ModifyFlowRule
type ModifyFlowRuleRequest struct {
	*requests.RpcRequest
	RefResource       string           `position:"Query" name:"RefResource"`
	WarmUpPeriodSec   requests.Integer `position:"Query" name:"WarmUpPeriodSec"`
	ControlBehavior   string           `position:"Query" name:"ControlBehavior"`
	ThresholdMode     requests.Integer `position:"Query" name:"ThresholdMode"`
	Threshold         requests.Float   `position:"Query" name:"Threshold"`
	AhasRegionId      string           `position:"Query" name:"AhasRegionId"`
	LimitOrigin       string           `position:"Query" name:"LimitOrigin"`
	Namespace         string           `position:"Query" name:"Namespace"`
	RelationStrategy  requests.Integer `position:"Query" name:"RelationStrategy"`
	MaxQueueingTimeMs requests.Integer `position:"Query" name:"MaxQueueingTimeMs"`
	RuleId            requests.Integer `position:"Query" name:"RuleId"`
}

// ModifyFlowRuleResponse is the response struct for api ModifyFlowRule
type ModifyFlowRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyFlowRuleRequest creates a request to invoke ModifyFlowRule API
func CreateModifyFlowRuleRequest() (request *ModifyFlowRuleRequest) {
	request = &ModifyFlowRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ModifyFlowRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyFlowRuleResponse creates a response to parse from ModifyFlowRule response
func CreateModifyFlowRuleResponse() (response *ModifyFlowRuleResponse) {
	response = &ModifyFlowRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
