package aigen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateTextTexture invokes the aigen.GenerateTextTexture API synchronously
func (client *Client) GenerateTextTexture(request *GenerateTextTextureRequest) (response *GenerateTextTextureResponse, err error) {
	response = CreateGenerateTextTextureResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateTextTextureWithChan invokes the aigen.GenerateTextTexture API asynchronously
func (client *Client) GenerateTextTextureWithChan(request *GenerateTextTextureRequest) (<-chan *GenerateTextTextureResponse, <-chan error) {
	responseChan := make(chan *GenerateTextTextureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateTextTexture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateTextTextureWithCallback invokes the aigen.GenerateTextTexture API asynchronously
func (client *Client) GenerateTextTextureWithCallback(request *GenerateTextTextureRequest, callback func(response *GenerateTextTextureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateTextTextureResponse
		var err error
		defer close(result)
		response, err = client.GenerateTextTexture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateTextTextureRequest is the request struct for api GenerateTextTexture
type GenerateTextTextureRequest struct {
	*requests.RpcRequest
	TextContent      string           `position:"Body" name:"TextContent"`
	TextureStyle     string           `position:"Query" name:"TextureStyle"`
	FontName         string           `position:"Body" name:"FontName"`
	TtfUrl           string           `position:"Body" name:"TtfUrl"`
	N                requests.Integer `position:"Body" name:"N"`
	Async            requests.Boolean `position:"Body" name:"Async"`
	AlphaChannel     requests.Boolean `position:"Body" name:"AlphaChannel"`
	ImageUrl         string           `position:"Body" name:"ImageUrl"`
	ImageShortSize   requests.Integer `position:"Body" name:"ImageShortSize"`
	Prompt           string           `position:"Body" name:"Prompt"`
	OutputImageRatio string           `position:"Body" name:"OutputImageRatio"`
}

// GenerateTextTextureResponse is the response struct for api GenerateTextTexture
type GenerateTextTextureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateTextTextureRequest creates a request to invoke GenerateTextTexture API
func CreateGenerateTextTextureRequest() (request *GenerateTextTextureRequest) {
	request = &GenerateTextTextureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aigen", "2024-01-11", "GenerateTextTexture", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateTextTextureResponse creates a response to parse from GenerateTextTexture response
func CreateGenerateTextTextureResponse() (response *GenerateTextTextureResponse) {
	response = &GenerateTextTextureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
