package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResources invokes the aiworkspace.ListResources API synchronously
func (client *Client) ListResources(request *ListResourcesRequest) (response *ListResourcesResponse, err error) {
	response = CreateListResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourcesWithChan invokes the aiworkspace.ListResources API asynchronously
func (client *Client) ListResourcesWithChan(request *ListResourcesRequest) (<-chan *ListResourcesResponse, <-chan error) {
	responseChan := make(chan *ListResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourcesWithCallback invokes the aiworkspace.ListResources API asynchronously
func (client *Client) ListResourcesWithCallback(request *ListResourcesRequest, callback func(response *ListResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourcesResponse
		var err error
		defer close(result)
		response, err = client.ListResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourcesRequest is the request struct for api ListResources
type ListResourcesRequest struct {
	*requests.RoaRequest
	PageSize     string `position:"Query" name:"PageSize"`
	ProductTypes string `position:"Query" name:"ProductTypes"`
	ResourceName string `position:"Query" name:"ResourceName"`
	GroupName    string `position:"Query" name:"GroupName"`
	PageNumber   string `position:"Query" name:"PageNumber"`
	WorkspaceId  string `position:"Query" name:"WorkspaceId"`
	Option       string `position:"Query" name:"Option"`
	Verbose      string `position:"Query" name:"Verbose"`
}

// ListResourcesResponse is the response struct for api ListResources
type ListResourcesResponse struct {
	*responses.BaseResponse
	RequestId  string          `json:"RequestId" xml:"RequestId"`
	TotalCount int64           `json:"TotalCount" xml:"TotalCount"`
	Resources  []ResourcesItem `json:"Resources" xml:"Resources"`
}

// CreateListResourcesRequest creates a request to invoke ListResources API
func CreateListResourcesRequest() (request *ListResourcesRequest) {
	request = &ListResourcesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "ListResources", "/api/v1/resources", "", "")
	request.Method = requests.GET
	return
}

// CreateListResourcesResponse creates a response to parse from ListResources response
func CreateListResourcesResponse() (response *ListResourcesResponse) {
	response = &ListResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
