package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestRoaDue invokes the amp.TestRoaDue API synchronously
func (client *Client) TestRoaDue(request *TestRoaDueRequest) (response *TestRoaDueResponse, err error) {
	response = CreateTestRoaDueResponse()
	err = client.DoAction(request, response)
	return
}

// TestRoaDueWithChan invokes the amp.TestRoaDue API asynchronously
func (client *Client) TestRoaDueWithChan(request *TestRoaDueRequest) (<-chan *TestRoaDueResponse, <-chan error) {
	responseChan := make(chan *TestRoaDueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestRoaDue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestRoaDueWithCallback invokes the amp.TestRoaDue API asynchronously
func (client *Client) TestRoaDueWithCallback(request *TestRoaDueRequest, callback func(response *TestRoaDueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestRoaDueResponse
		var err error
		defer close(result)
		response, err = client.TestRoaDue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestRoaDueRequest is the request struct for api TestRoaDue
type TestRoaDueRequest struct {
	*requests.RoaRequest
	Body TestRoaDueBody `position:"Body" name:"body"  type:"Struct"`
}

// TestRoaDueBody is a repeated param struct in TestRoaDueRequest
type TestRoaDueBody struct {
	Name string `name:"Name"`
}

// TestRoaDueResponse is the response struct for api TestRoaDue
type TestRoaDueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateTestRoaDueRequest creates a request to invoke TestRoaDue API
func CreateTestRoaDueRequest() (request *TestRoaDueRequest) {
	request = &TestRoaDueRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "TestRoaDue", "/efe/efe", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTestRoaDueResponse creates a response to parse from TestRoaDue response
func CreateTestRoaDueResponse() (response *TestRoaDueResponse) {
	response = &TestRoaDueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
