package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSurveyResources invokes the apds.DeleteSurveyResources API synchronously
func (client *Client) DeleteSurveyResources(request *DeleteSurveyResourcesRequest) (response *DeleteSurveyResourcesResponse, err error) {
	response = CreateDeleteSurveyResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSurveyResourcesWithChan invokes the apds.DeleteSurveyResources API asynchronously
func (client *Client) DeleteSurveyResourcesWithChan(request *DeleteSurveyResourcesRequest) (<-chan *DeleteSurveyResourcesResponse, <-chan error) {
	responseChan := make(chan *DeleteSurveyResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSurveyResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSurveyResourcesWithCallback invokes the apds.DeleteSurveyResources API asynchronously
func (client *Client) DeleteSurveyResourcesWithCallback(request *DeleteSurveyResourcesRequest, callback func(response *DeleteSurveyResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSurveyResourcesResponse
		var err error
		defer close(result)
		response, err = client.DeleteSurveyResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSurveyResourcesRequest is the request struct for api DeleteSurveyResources
type DeleteSurveyResourcesRequest struct {
	*requests.RoaRequest
	Ids string `position:"Query" name:"ids"`
}

// DeleteSurveyResourcesResponse is the response struct for api DeleteSurveyResources
type DeleteSurveyResourcesResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"Error" xml:"Error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateDeleteSurveyResourcesRequest creates a request to invoke DeleteSurveyResources API
func CreateDeleteSurveyResourcesRequest() (request *DeleteSurveyResourcesRequest) {
	request = &DeleteSurveyResourcesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "DeleteSurveyResources", "/okss-services/confirm-resource/destroy", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteSurveyResourcesResponse creates a response to parse from DeleteSurveyResources response
func CreateDeleteSurveyResourcesResponse() (response *DeleteSurveyResourcesResponse) {
	response = &DeleteSurveyResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
