package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAntChainContractProjectContentTree invokes the baas.DescribeAntChainContractProjectContentTree API synchronously
// api document: https://help.aliyun.com/api/baas/describeantchaincontractprojectcontenttree.html
func (client *Client) DescribeAntChainContractProjectContentTree(request *DescribeAntChainContractProjectContentTreeRequest) (response *DescribeAntChainContractProjectContentTreeResponse, err error) {
	response = CreateDescribeAntChainContractProjectContentTreeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAntChainContractProjectContentTreeWithChan invokes the baas.DescribeAntChainContractProjectContentTree API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchaincontractprojectcontenttree.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainContractProjectContentTreeWithChan(request *DescribeAntChainContractProjectContentTreeRequest) (<-chan *DescribeAntChainContractProjectContentTreeResponse, <-chan error) {
	responseChan := make(chan *DescribeAntChainContractProjectContentTreeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAntChainContractProjectContentTree(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAntChainContractProjectContentTreeWithCallback invokes the baas.DescribeAntChainContractProjectContentTree API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchaincontractprojectcontenttree.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainContractProjectContentTreeWithCallback(request *DescribeAntChainContractProjectContentTreeRequest, callback func(response *DescribeAntChainContractProjectContentTreeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAntChainContractProjectContentTreeResponse
		var err error
		defer close(result)
		response, err = client.DescribeAntChainContractProjectContentTree(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAntChainContractProjectContentTreeRequest is the request struct for api DescribeAntChainContractProjectContentTree
type DescribeAntChainContractProjectContentTreeRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
}

// DescribeAntChainContractProjectContentTreeResponse is the response struct for api DescribeAntChainContractProjectContentTree
type DescribeAntChainContractProjectContentTreeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeAntChainContractProjectContentTreeRequest creates a request to invoke DescribeAntChainContractProjectContentTree API
func CreateDescribeAntChainContractProjectContentTreeRequest() (request *DescribeAntChainContractProjectContentTreeRequest) {
	request = &DescribeAntChainContractProjectContentTreeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeAntChainContractProjectContentTree", "baas", "openAPI")
	return
}

// CreateDescribeAntChainContractProjectContentTreeResponse creates a response to parse from DescribeAntChainContractProjectContentTree response
func CreateDescribeAntChainContractProjectContentTreeResponse() (response *DescribeAntChainContractProjectContentTreeResponse) {
	response = &DescribeAntChainContractProjectContentTreeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
