package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMainDomain invokes the beian.GetMainDomain API synchronously
func (client *Client) GetMainDomain(request *GetMainDomainRequest) (response *GetMainDomainResponse, err error) {
	response = CreateGetMainDomainResponse()
	err = client.DoAction(request, response)
	return
}

// GetMainDomainWithChan invokes the beian.GetMainDomain API asynchronously
func (client *Client) GetMainDomainWithChan(request *GetMainDomainRequest) (<-chan *GetMainDomainResponse, <-chan error) {
	responseChan := make(chan *GetMainDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMainDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMainDomainWithCallback invokes the beian.GetMainDomain API asynchronously
func (client *Client) GetMainDomainWithCallback(request *GetMainDomainRequest, callback func(response *GetMainDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMainDomainResponse
		var err error
		defer close(result)
		response, err = client.GetMainDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMainDomainRequest is the request struct for api GetMainDomain
type GetMainDomainRequest struct {
	*requests.RpcRequest
	Domain string `position:"Query" name:"Domain"`
}

// GetMainDomainResponse is the response struct for api GetMainDomain
type GetMainDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetMainDomainRequest creates a request to invoke GetMainDomain API
func CreateGetMainDomainRequest() (request *GetMainDomainRequest) {
	request = &GetMainDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "GetMainDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMainDomainResponse creates a response to parse from GetMainDomain response
func CreateGetMainDomainResponse() (response *GetMainDomainResponse) {
	response = &GetMainDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
