package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPriceEntityList invokes the bssopenapi.QueryPriceEntityList API synchronously
func (client *Client) QueryPriceEntityList(request *QueryPriceEntityListRequest) (response *QueryPriceEntityListResponse, err error) {
	response = CreateQueryPriceEntityListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPriceEntityListWithChan invokes the bssopenapi.QueryPriceEntityList API asynchronously
func (client *Client) QueryPriceEntityListWithChan(request *QueryPriceEntityListRequest) (<-chan *QueryPriceEntityListResponse, <-chan error) {
	responseChan := make(chan *QueryPriceEntityListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPriceEntityList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPriceEntityListWithCallback invokes the bssopenapi.QueryPriceEntityList API asynchronously
func (client *Client) QueryPriceEntityListWithCallback(request *QueryPriceEntityListRequest, callback func(response *QueryPriceEntityListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPriceEntityListResponse
		var err error
		defer close(result)
		response, err = client.QueryPriceEntityList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPriceEntityListRequest is the request struct for api QueryPriceEntityList
type QueryPriceEntityListRequest struct {
	*requests.RpcRequest
	CommodityCode string `position:"Query" name:"CommodityCode"`
}

// QueryPriceEntityListResponse is the response struct for api QueryPriceEntityList
type QueryPriceEntityListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryPriceEntityListRequest creates a request to invoke QueryPriceEntityList API
func CreateQueryPriceEntityListRequest() (request *QueryPriceEntityListRequest) {
	request = &QueryPriceEntityListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryPriceEntityList", "bssopenapi", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryPriceEntityListResponse creates a response to parse from QueryPriceEntityList response
func CreateQueryPriceEntityListResponse() (response *QueryPriceEntityListResponse) {
	response = &QueryPriceEntityListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
